package cn.kinyun.pay.business.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PayMessageType {

    ORDER(1, "下单"),

    REFUND(2, "退款"),

    TRANS(3, "转账"),
    ;

    private Integer value;

    private String desc;

    PayMessageType(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, PayMessageType> MAP;

    static {
        MAP = Arrays.stream(PayMessageType.values()).collect(Collectors.toMap(a -> a.getValue(), a -> a));
    }

    public static PayMessageType getType(Integer value) {
        return MAP.get(value);
    }
}
