package cn.kinyun.pay.business.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PayEventType {

    RefundAuditPass(1, "实际退款审批通过"),

    TransWrongAccount(2, "转账账户信息有误"),

    TransAuditPass(3,"实际转账审批通过"),

    RefundAuditReject(4,"实际退款审批拒绝"),

    TransAuditReject(5,"实际转账审批拒绝"),
    ;

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    PayEventType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, PayEventType> MAP;

    static {
        MAP = Arrays.stream(PayEventType.values()).collect(Collectors.toMap(a -> a.getType(), a -> a));
    }

    public static PayEventType getByType(Integer type) {
        return MAP.get(type);
    }
}
