package cn.kinyun.pay.business.enums;

import com.google.common.collect.ImmutableMap;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by jiangtiteng on 2018/12/6
 */
public enum PayChannelType {
    WEIXIN_NATIVE(1, "微信扫码支付", "weixin"),

    WEIXIN_APP(2, "微信APP支付", "weixin"),

    WEIXIN_H5(3, "微信手机网站支付", "weixin"),

    WEIXIN_JSAPI(4, "微信公众号支付","weixin"),

    WEIXIN_WEAPPLET(5, "微信小程序支付","weixin"),

    WEIXIN_PRE_CREATE(6, "微信当面付","weixin"),

    ALIPAY_PRE_CREATE(7, "支付宝当面付-扫码支付","alipay"),

    ALIPAY_APP(8, "支付宝APP支付","alipay"),

    ALIPAY_WAP(9, "支付宝手机网站支付","alipay"),

    ALIPAY_PAGE(10, "支付宝电脑网站支付","alipay");

    static Map<Integer, PayChannelType> MAP;

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(PayChannelType.values()).collect(Collectors.toMap(PayChannelType::getValue, e -> e)));
    }

    private Integer value;

    private String desc;

    private String serviceCode;

    PayChannelType(Integer value, String desc, String serviceCode) {
        this.value = value;
        this.desc = desc;
        this.serviceCode = serviceCode;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public String getServiceCode() {
        return serviceCode;
    }

    public static PayChannelType get(Integer value) {
        return MAP.get(value);
    }
}
