package cn.kinyun.pay.business.dto.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.UUID;

@Data
public class PayMessageDto implements Serializable {

    private static final long serialVersionUID = 5623290113330896336L;
    /**
     * appId
     */
    private String appId;
    /**
     * 消息uuid
     */
    private String uniqueId;
    /**
     * 消息类型1:支付2:退款3:转账
     */
    private Integer msgType;
    /**
     * 业务系统订单号
     */
    private String bizOrderNum;
    /**
     * 业务系统退单号
     */
    private String bizRefundNum;
    /**
     * 业务系统转账单号
     */
    private String bizTransNum;
    /**
     * 支付系统订单号
     */
    private String orderNum;
    /**
     * 消息体, 冗余信息
     *
     * msgType=2 退款时, body的结构为 {@link RefundDetailDto} 组成的JSON数组
     * msgType=3 转账时, body的结构为 {@link TransDetailDto} 组成的JSON对象
     *
     */
    private String body;

    public PayMessageDto() {
        this.uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
    }
}
