package cn.kinyun.pay.business.dto.vo;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import java.io.Serializable;

/**
 * Created by jiangtiteng on 2019-01-03
 */
@Data
public class OrderHeaderDto implements Serializable {
    /**
     * 业务订单号
     */
    private String bizOrderNum;

    /**
     * 订单总金额 单位为分
     */
    private String amount;

    /**
     * 业务订单数据 json格式
     */
    private String bizOrderInfos;

    public Long validate() {
        Preconditions.checkArgument(StringUtils.isNoneBlank(bizOrderNum), "无效的bizOrderNum");
        Preconditions.checkArgument(StringUtils.isNotBlank(amount) && amount.matches("\\d+"), "无效的amount,金额必须以分为单位,且是一个正整数");
        Long amountNum = NumberUtils.toLong(amount);
        Preconditions.checkArgument(amountNum > 0 && amountNum < 100000000000L, "amount取值范围为:(0,100000000000)");
        return amountNum;
    }
}
