package cn.kinyun.pay.business.dto.response;

import lombok.Data;

import java.io.Serializable;

/**
 * Created by jiangtiteng on 2018/12/6
 */

@Data
public class BaseResponse<T> implements Serializable {
    /**
     * requestId
     */
    private String requestId;

    /**
     * 成功标记
     */
    private boolean success;

    /**
     * 错误码,成功时为空
     */
    private int code;

    /**
     * 错误信息,成功时可为空
     */
    private String msg;

    /**
     * 第三方错误code
     */
    private String thirdPartCode;

    /**
     * 第三方错误描述
     */
    private String thirdPartMsg;

    private T data;

    public static BaseResponse serviceError(String errMsg) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setSuccess(false);
        baseResponse.setCode(500);
        baseResponse.setMsg(errMsg);
        return baseResponse;
    }

    public static BaseResponse fail(String thirdPartCode,String thirdPartMsg){
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setSuccess(false);
        baseResponse.setCode(500);
        baseResponse.setMsg("业务执行失败");
        baseResponse.setThirdPartCode(thirdPartCode);
        baseResponse.setThirdPartMsg(thirdPartMsg);
        return baseResponse;
    }

    public static BaseResponse paramsError(String errMsg) {
        return paramsError(errMsg, null);
    }

    public static BaseResponse paramsError(String errMsg, String requestId) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setSuccess(false);
        baseResponse.setCode(400);
        baseResponse.setMsg(errMsg);
        baseResponse.setRequestId(requestId);
        return baseResponse;
    }

    public static BaseResponse ok(Serializable data) {
        return ok(data, null);

    }

    public static BaseResponse ok(Serializable data, String requestId) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setSuccess(true);
        baseResponse.setCode(0);
        baseResponse.setData(data);
        baseResponse.setRequestId(requestId);
        return baseResponse;

    }
}