package cn.kinyun.pay.business.dto.request.trans;

import cn.kinyun.pay.business.dto.request.BaseRequest;
import cn.kinyun.pay.business.enums.PayTransChannelType;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 用于转账失败时,更新收款人信息
 */
@Data
public class TransTargetInfoReq extends BaseRequest {

    /**
     * 业务订单号
     */
    private String bizOrderNum;
    /**
     * 业务装置转账单号
     */
    private String bizTransNum;

    /**
     * 转账类型
     * <p>
     * 取值为: {@link cn.kinyun.pay.business.enums.PayTransChannelType}
     */
    private Integer payTransType;

//    /**
//     * 账号类型
//     * <p>
//     * {@link cn.kinyun.pay.business.enums.PayeeAccountType}
//     */
//    private Integer accountType;
//    /**
//     * 账号(银行卡号,支付宝账号,微信账号等)
//     */
//    private String account;
//    /**
//     * 银行卡持有人姓名
//     */
//    private String userName;

    private AliPayAccount accountInfo;

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument(StringUtils.isNotBlank(bizOrderNum) || StringUtils.isNotBlank(bizTransNum), "bizOrderNum, bizTransNum不能同时为空");
        Preconditions.checkArgument(Objects.nonNull(payTransType) && PayTransChannelType.get(payTransType) != null, "payTransType转账类型不能为空");
        Preconditions.checkArgument(Objects.nonNull(accountInfo), "accountInfo不能为空");
        accountInfo.validate();
//        Preconditions.checkArgument(accountType != null && PayeeAccountType.getByType(accountType) != null, "accountType不存在");
//        Preconditions.checkArgument(StringUtils.isNotBlank(account), "account 不能为空");
//        Preconditions.checkArgument(StringUtils.isNotBlank(userName), "userName 不能为空");
    }
}
