package cn.kinyun.pay.business.dto.request.trans;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

@Data
public class AliPayAccount extends BaseAccountInfo implements Serializable {
    /**
     * 0: 支付宝会员的用户 ID, ALIPAY_USER_ID,
     * 1: 支付宝登录号        ALIPAY_LOGON_ID
     * 2: 银行卡             BANKCARD_ACCOUNT
     */
    private int identityType;

    /**
     * 参与方真实姓名，如果非空，将校验收款支付宝账号姓名一致性。
     * 当identityType=1或2时，本字段必填
     */
    private String name;
    /**
     * 收款账户类型:
     * 1: 对公  如果银行卡为对公，必须传递省市支行信息或者联行号
     * 2: 对私
     */
    private Integer accountType;
    /**
     * 银行机构名称(对公转账时必填)
     */
    private String instName;
    /**
     * 银行所在省份(对公转账时必填)
     */
    private String instProvince;
    /**
     * 收款银行所在市(对公转账时必填)
     */
    private String instCity;
    /**
     * 收款银行所属支行(对公转账时必填)
     */
    private String instBranchName;
    /**
     * 收款行支行联号(若转账的银行卡机构不在 银行机构名称 中，本参数必填。)
     */
    private String bankCode;

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument(identityType >= 0 && identityType <= 2, "identityType 类型错误");

        if (identityType >= 1) {
            Preconditions.checkArgument(StringUtils.isNotEmpty(name), "当identity_type=ALIPAY_LOGON_ID或BANKCARD_ACCOUNT时，name字段必填");
        }

        // 转银行卡时需要特殊校验
        if (identityType == 2) {
            Preconditions.checkArgument(Objects.nonNull(accountType) && accountType >= 1 && accountType <= 2, "accountType 不能为空,且取值为1或2,1:对公;2:对私");
            if (accountType == 1) {
                // 对公
                Preconditions.checkArgument(
                        StringUtils.isNotBlank(bankCode)
                                ||
                                (StringUtils.isNotBlank(instName) && StringUtils.isNotBlank(instProvince) && StringUtils.isNotBlank(instCity) && StringUtils.isNotBlank(instBranchName)), "如果银行卡为对公，必须传递省市支行信息或者联行号");
            } else {
                // 对私
            }
        }
    }
}
