package cn.kinyun.pay.business.dto.request;


import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
public class OrderQueryRequest extends BaseRequest {
    /**
     * 支付单号
     */
    private String orderNum;

    @Override
    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotEmpty(orderNum), "支付订单号不能为空");
    }
}
