/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.link.common_dto.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OpPlatform {
    UNKNOWN(-1, "unknown"),
    MANAGER(1, "manager\u4e3b\u63a7\u53f0\u670d\u52a1"),
    LOGIC(2, "logic\u670d\u52a1"),
    WEB(0, "web\u7aef"),
    TEST(3, "test"),
    SERVICE(4, "service\u670d\u52a1"),
    MANAGER_API(5, "manager_api\u670d\u52a1"),
    LINK(6, "link");

    private int type;
    private String desc;
    static final Map<Integer, OpPlatform> MAP;

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private OpPlatform(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static OpPlatform getInstance(int type) {
        return MAP.getOrDefault(type, UNKNOWN);
    }

    public static String getPlatformName(Integer type) {
        return MAP.containsKey(type) ? MAP.get(type).getDesc() : "\u672a\u77e5\u5e73\u53f0,type=" + type;
    }

    static {
        MAP = Maps.newHashMap();
        MAP.putAll(Arrays.stream(OpPlatform.values()).collect(Collectors.toMap(a -> a.getType(), Function.identity())));
    }
}

