/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.link.common_dto.dto;

import cn.kinyun.link.common_dto.dto.PageDto;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseResponse<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(BaseResponse.class);
    private static final long serialVersionUID = -995208941757795218L;
    private long code;
    private String msg;
    private T data;
    private PageDto pageDto;
    private String requestId;

    public BaseResponse() {
    }

    public BaseResponse(long code, String msg, T data, PageDto pageDto) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.pageDto = pageDto;
    }

    public BaseResponse<T> badRequest() {
        this.code = ResponseCodeType.REQUEST_PARAM_NOT_INVALID.getCode();
        return this;
    }

    public BaseResponse<T> okRequest() {
        this.code = ResponseCodeType.SUCCESS.getCode();
        return this;
    }

    public BaseResponse<T> offline() {
        this.code = ResponseCodeType.WEWORK_OFFLINE.getCode();
        this.msg = ResponseCodeType.WEWORK_OFFLINE.getDesc();
        return this;
    }

    public BaseResponse<T> data(T data) {
        this.data = data;
        return this;
    }

    public BaseResponse<T> msg(String msg) {
        this.msg = msg;
        return this;
    }

    public BaseResponse<T> code(long code) {
        this.code = code;
        return this;
    }

    public BaseResponse<T> pageDto(PageDto pageDto) {
        this.pageDto = pageDto;
        return this;
    }

    public BaseResponse<T> requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public BaseResponse<T> log() {
        log.info("BaseResponse {}", (Object)StringUtils.abbreviate((String)this.toString(), (int)0, (int)5000));
        return this;
    }

    public static <T> BaseResponse<T> ok(T data) {
        return new BaseResponse<T>(ResponseCodeType.SUCCESS.getCode(), "", data, null);
    }

    public static <T> BaseResponse<T> code(ResponseCodeType responseCodeType) {
        return new BaseResponse<Object>(responseCodeType.getCode(), responseCodeType.getDesc(), null, null);
    }

    public long getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $code = this.getCode();
        result = result * 59 + (int)($code >>> 32 ^ $code);
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", pageDto=" + this.getPageDto() + ", requestId=" + this.getRequestId() + ")";
    }
}

