/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.link.common_dto.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum LinkOpType {
    DEFAULT(0, "\u9ed8\u8ba4\u7c7b\u578b", "default", 0),
    BATCHPUSH(1, "\u6279\u91cf\u7fa4\u53d1", "MsgSend", 1),
    BATCHPUSH_NOTICE(2, "\u6279\u91cf\u4fee\u6539\u7fa4\u516c\u544a", "", 1);

    int value;
    String desc;
    String commandType;
    int channel;
    private static final Map<String, LinkOpType> MAP;
    private static final Map<Integer, LinkOpType> MAP2;

    private LinkOpType(int value, String desc, String commandType, int channel) {
        this.value = value;
        this.desc = desc;
        this.commandType = commandType;
        this.channel = channel;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getCommandType() {
        return this.commandType;
    }

    public int getChannel() {
        return this.channel;
    }

    public static LinkOpType getInstance(String commandType) {
        return MAP.get(commandType);
    }

    public static LinkOpType getByType(Integer type) {
        return MAP2.get(type);
    }

    static {
        MAP = Maps.newHashMap();
        MAP2 = Maps.newHashMap();
        MAP.putAll(Arrays.stream(LinkOpType.values()).collect(Collectors.toMap(LinkOpType::getCommandType, a -> a)));
        MAP2.putAll(Arrays.stream(LinkOpType.values()).collect(Collectors.toMap(LinkOpType::getValue, a -> a)));
    }
}

