/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.link.common_dto.dto;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ResponseCodeType {
    UNKNOWN(-1, "unknown", "\u672a\u77e5code"),
    SUCCESS(0, "success", "\u6210\u529f"),
    ANDROID_PROCESS_ERROR(102, "androidProcessError", "\u79fb\u52a8\u7aef\u5904\u7406\u5f02\u5e38"),
    WEWORK_OFFLINE(400, "Offline", "\u4f01\u5fae\u53f7\u4e0d\u5728\u7ebf"),
    REQUEST_PARAM_NOT_INVALID(401, "RequestParamNotInvalid", "\u53c2\u6570\u6821\u9a8c\u5f02\u5e38"),
    BIZ_ID_NOT_EXISTS(402, "BizIdNotExists", "\u5546\u6237\u4e0d\u5b58\u5728"),
    THRESHOLD_EXCEEDED(430, "Threshold Exceeded", "\u989d\u5ea6\u8d85\u9650"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error", "\u5185\u90e8\u670d\u52a1\u5668\u9519\u8bef"),
    CONCURRENT_MODIFY(511, "ConcurrentModify", "\u5e76\u53d1\u4fee\u6539,\u8bf7\u7a0d\u540e\u518d\u8bd5"),
    BATCH_PUSH_CONCURRENT_MODIFY(512, "BatchPushConcurrentModify", "\u6d88\u606f\u7fa4\u53d1\u5e76\u53d1\u4fee\u6539,\u8bf7\u7b49\u5f85\u4e0a\u4e00\u4e2a\u4fee\u6539\u5b8c\u6210\u540e\u518d\u7ee7\u7eed"),
    WEWORK_REQUEST_FREQUENTLY(513, "weworkRequestFrequently", "\u4f01\u5fae\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41"),
    SEND_TIME_OVER_24(514, "SendTimeOver24", "\u4e0d\u5728\u8fd0\u8425\u65f6\u95f4\u6bb5\u5185"),
    CANCEL(515, "CANCEL", "\u53d6\u6d88"),
    REQUEST_TIMEOUT(2000, "REQUEST_TIMEOUT", "\u8bf7\u6c42\u8d85\u65f6"),
    UNKNOWN_CMD(516, "unknownCMD", "\u672a\u77e5cmd"),
    EXPIRE(517, "expire", "\u8d85\u8fc7\u7ec8\u6b62\u65f6\u95f4");

    int code;
    String msg;
    String desc;
    static final Map<Integer, ResponseCodeType> MAP;
    static final Map<Integer, ResponseCodeType> AndroidCodeMap;
    static final Map<Integer, ResponseCodeType> LinkCodeMap;

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getMsg() {
        return this.msg;
    }

    private ResponseCodeType(int code, String msg, String desc) {
        this.code = code;
        this.msg = msg;
        this.desc = desc;
    }

    public static ResponseCodeType getInstance(int code) {
        return MAP.getOrDefault(code, UNKNOWN);
    }

    public static boolean isAndroid(int code) {
        return AndroidCodeMap.containsKey(code);
    }

    public static boolean isLink(int code) {
        return LinkCodeMap.containsKey(code);
    }

    static {
        MAP = Arrays.stream(ResponseCodeType.values()).collect(Collectors.toMap(ResponseCodeType::getCode, a -> a));
        AndroidCodeMap = Maps.newHashMap();
        AndroidCodeMap.put(ResponseCodeType.ANDROID_PROCESS_ERROR.code, ANDROID_PROCESS_ERROR);
        LinkCodeMap = Arrays.stream(ResponseCodeType.values()).filter(a -> !AndroidCodeMap.containsKey(a.getCode())).collect(Collectors.toMap(ResponseCodeType::getCode, a -> a));
    }
}

