/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.link.common_dto.dto;

import java.io.Serializable;

public class PageDto
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9103057732548944201L;
    private static final int DEF_PAGE_SIZE = 20;
    private static final int DEF_PAGE_NUM = 1;
    private static final PageDto DEF_PAGE_DTO = new PageDto();
    private Integer count = 0;
    private Integer curPageCount;
    private Integer pageNum = 1;
    private Integer pageSize = 20;
    private boolean needCount = true;

    public static final PageDto getDefPageDto() {
        try {
            return (PageDto)DEF_PAGE_DTO.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        if (count == null) {
            count = 0;
        }
        this.count = count;
    }

    public Integer getCurPageCount() {
        return this.curPageCount;
    }

    public void setCurPageCount(Integer curPageCount) {
        if (curPageCount == null) {
            curPageCount = 0;
        }
        this.curPageCount = curPageCount;
    }

    public Integer getPageNum() {
        if (this.pageNum == null || this.pageNum <= 0) {
            this.pageNum = 1;
        }
        return this.pageNum;
    }

    public Integer getTotalPageNum() {
        if (this.count == 0) {
            return 0;
        }
        return (int)Math.ceil((double)this.count.intValue() / this.pageSize.doubleValue());
    }

    public void setPageNum(Integer pageNum) {
        if (pageNum == null || pageNum <= 0) {
            pageNum = 1;
        }
        this.pageNum = pageNum;
    }

    public void increasePageNum() {
        PageDto pageDto = this;
        Integer n = pageDto.pageNum;
        Integer n2 = pageDto.pageNum = Integer.valueOf(pageDto.pageNum + 1);
    }

    public Integer getPageSize() {
        if (this.pageSize == null || this.pageSize <= 0) {
            this.pageSize = 20;
        }
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        if (pageSize == null || pageSize <= 0) {
            pageSize = 20;
        }
        this.pageSize = pageSize;
    }

    public void validate() {
        int pageNum = this.getPageNum();
        int pageSize = this.getPageSize();
        int count = this.getCount();
        if (count <= 0) {
            this.setPageNum(1);
            return;
        }
        int lastPageNum = (count - 1) / pageSize + 1;
        if (lastPageNum > pageNum) {
            this.setCurPageCount(pageSize);
            return;
        }
        int lastPageSize = (count - 1) % pageSize + 1;
        this.setCurPageCount(lastPageSize);
        if (lastPageNum < pageNum) {
            this.setPageNum(lastPageNum);
            return;
        }
    }

    public int firstNum() {
        int pageNum = this.getPageNum();
        int pageSize = this.getPageSize();
        return (pageNum - 1) * pageSize;
    }

    public int getOffset() {
        return this.firstNum();
    }

    protected Object clone() throws CloneNotSupportedException {
        PageDto pageDto = new PageDto();
        pageDto.count = this.count;
        pageDto.curPageCount = this.curPageCount;
        pageDto.pageNum = this.pageNum;
        pageDto.pageSize = this.pageSize;
        return pageDto;
    }

    public boolean isNeedCount() {
        return this.needCount;
    }

    public void setNeedCount(boolean needCount) {
        this.needCount = needCount;
    }
}

