/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.link.service.push.request;

import cn.kinyun.link.common_dto.dto.BaseRequest;
import cn.kinyun.link.common_dto.enums.LinkOpType;
import cn.kinyun.link.service.push.request.BaseSendReq;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BatchPushMessageReq
extends BaseRequest
implements Serializable {
    private static final long serialVersionUID = 408211932205695706L;
    private Long taskId;
    private Long detailId;
    private LinkOpType taskType;
    private Date sendDate;
    private int type;
    private String targetId;
    private List<BaseSendReq> list;

    public boolean validate() {
        boolean checkContent = false;
        if (CollectionUtils.isNotEmpty(this.list)) {
            checkContent = true;
            this.list.forEach(a -> {
                a.setBizId(this.getBizId());
                a.setChannelId(this.getChannelId());
                a.setControl(this.isControl());
                a.setCorpId(this.getCorpId());
                a.setOpPlatform(this.getOpPlatform());
                a.setWeworkId(this.getWeworkId());
                a.setTargetId(this.targetId);
                if (a instanceof BaseSendReq) {
                    BaseSendReq baseSendReq = a;
                    baseSendReq.setType(this.type);
                }
                a.validate();
            });
        }
        if (this.taskType != null) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.targetId), (Object)"targetId can not be null or empty");
            Preconditions.checkArgument((this.taskId != null ? 1 : 0) != 0, (Object)"taskId can not be null or empty");
            Preconditions.checkArgument((this.sendDate != null ? 1 : 0) != 0, (Object)"sendDate can not be null or empty");
            return super.validate() && StringUtils.isNotEmpty((CharSequence)this.targetId) && checkContent && this.taskId != null && this.sendDate != null;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.targetId), (Object)"targetId can not be null or empty");
        return super.validate() && StringUtils.isNotEmpty((CharSequence)this.targetId) && checkContent;
    }

    public String toString() {
        return "BatchPushMessageReq(super=" + super.toString() + ", taskId=" + this.getTaskId() + ", detailId=" + this.getDetailId() + ", taskType=" + this.getTaskType() + ", sendDate=" + this.getSendDate() + ", type=" + this.getType() + ", targetId=" + this.getTargetId() + ", list=" + this.getList() + ")";
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public Long getDetailId() {
        return this.detailId;
    }

    public LinkOpType getTaskType() {
        return this.taskType;
    }

    public Date getSendDate() {
        return this.sendDate;
    }

    public int getType() {
        return this.type;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public List<BaseSendReq> getList() {
        return this.list;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }

    public void setTaskType(LinkOpType taskType) {
        this.taskType = taskType;
    }

    public void setSendDate(Date sendDate) {
        this.sendDate = sendDate;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setList(List<BaseSendReq> list) {
        this.list = list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchPushMessageReq)) {
            return false;
        }
        BatchPushMessageReq other = (BatchPushMessageReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$taskId = this.getTaskId();
        Long other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        Long this$detailId = this.getDetailId();
        Long other$detailId = other.getDetailId();
        if (this$detailId == null ? other$detailId != null : !((Object)this$detailId).equals(other$detailId)) {
            return false;
        }
        LinkOpType this$taskType = this.getTaskType();
        LinkOpType other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) {
            return false;
        }
        Date this$sendDate = this.getSendDate();
        Date other$sendDate = other.getSendDate();
        if (this$sendDate == null ? other$sendDate != null : !((Object)this$sendDate).equals(other$sendDate)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        String this$targetId = this.getTargetId();
        String other$targetId = other.getTargetId();
        if (this$targetId == null ? other$targetId != null : !this$targetId.equals(other$targetId)) {
            return false;
        }
        List<BaseSendReq> this$list = this.getList();
        List<BaseSendReq> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BatchPushMessageReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        Long $detailId = this.getDetailId();
        result = result * 59 + ($detailId == null ? 43 : ((Object)$detailId).hashCode());
        LinkOpType $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
        Date $sendDate = this.getSendDate();
        result = result * 59 + ($sendDate == null ? 43 : ((Object)$sendDate).hashCode());
        result = result * 59 + this.getType();
        String $targetId = this.getTargetId();
        result = result * 59 + ($targetId == null ? 43 : $targetId.hashCode());
        List<BaseSendReq> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }
}

