/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.link.service.conversation.request;

import cn.kinyun.link.common_dto.dto.BaseRequest;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CreateRoomAndRenameReq
extends BaseRequest
implements Serializable {
    private String roomName;
    private List<String> targetIds;

    public boolean validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.roomName), (Object)"roomName can not be null or empty");
        Preconditions.checkArgument((CollectionUtils.isEmpty(this.targetIds) || CollectionUtils.isNotEmpty(this.targetIds) && this.targetIds.size() >= 2 ? 1 : 0) != 0, (Object)"targetIds must be empty or size>=2");
        return super.validate() && StringUtils.isNotBlank((CharSequence)this.roomName);
    }

    public String toString() {
        return "CreateRoomAndRenameReq(super=" + super.toString() + ", roomName=" + this.getRoomName() + ", targetIds=" + this.getTargetIds() + ")";
    }

    public String getRoomName() {
        return this.roomName;
    }

    public List<String> getTargetIds() {
        return this.targetIds;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public void setTargetIds(List<String> targetIds) {
        this.targetIds = targetIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateRoomAndRenameReq)) {
            return false;
        }
        CreateRoomAndRenameReq other = (CreateRoomAndRenameReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$roomName = this.getRoomName();
        String other$roomName = other.getRoomName();
        if (this$roomName == null ? other$roomName != null : !this$roomName.equals(other$roomName)) {
            return false;
        }
        List<String> this$targetIds = this.getTargetIds();
        List<String> other$targetIds = other.getTargetIds();
        return !(this$targetIds == null ? other$targetIds != null : !((Object)this$targetIds).equals(other$targetIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateRoomAndRenameReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $roomName = this.getRoomName();
        result = result * 59 + ($roomName == null ? 43 : $roomName.hashCode());
        List<String> $targetIds = this.getTargetIds();
        result = result * 59 + ($targetIds == null ? 43 : ((Object)$targetIds).hashCode());
        return result;
    }
}

