/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.electricity.customer.impl;

import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.order.OrderSubmitReq;
import cn.kinyun.customer.center.enums.electricity.PlatformEnum;
import cn.kinyun.customer.center.enums.electricity.YzMessageTypeEnum;
import cn.kinyun.electricity.common.dto.PlatformMsgDto;
import cn.kinyun.electricity.customer.YZCustomerService;
import cn.kinyun.electricity.customer.dto.msg.CustomerAuthMobileMsg;
import cn.kinyun.electricity.customer.dto.msg.CustomerEventMsg;
import cn.kinyun.electricity.customer.dto.msg.CustomerMobileChangeMsg;
import cn.kinyun.electricity.customer.dto.msg.CustomerMsgEntity;
import cn.kinyun.electricity.customer.dto.msg.CustomerRelAddMsg;
import cn.kinyun.electricity.customer.dto.req.CustomerListReq;
import cn.kinyun.electricity.customer.dto.req.CustomerQueryListReq;
import cn.kinyun.electricity.customer.dto.req.CustomerReq;
import cn.kinyun.electricity.customer.dto.req.CustomerUserInfoReq;
import cn.kinyun.electricity.customer.dto.req.CustomerUserReq;
import cn.kinyun.electricity.customer.dto.req.EleCustomerDetailReq;
import cn.kinyun.electricity.customer.dto.resp.CustomerAddressResp;
import cn.kinyun.electricity.customer.dto.resp.CustomerDetailResp;
import cn.kinyun.electricity.dal.entity.ElectricityBizShopRelation;
import cn.kinyun.electricity.dal.entity.ElectricityCustomerInfo;
import cn.kinyun.electricity.dal.entity.ElectricityMsgCallbackRecord;
import cn.kinyun.electricity.dal.mapper.ElectricityBizShopRelationMapper;
import cn.kinyun.electricity.dal.mapper.ElectricityCustomerInfoMapper;
import cn.kinyun.electricity.dal.mapper.ElectricityMsgCallbackRecordMapper;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.youzan.cloud.open.sdk.api.API;
import com.youzan.cloud.open.sdk.api.ApiParams;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.core.client.auth.Auth;
import com.youzan.cloud.open.sdk.core.client.auth.Token;
import com.youzan.cloud.open.sdk.core.client.core.YouZanClient;
import com.youzan.cloud.open.sdk.gen.v1_0_0.api.YouzanScrmCustomerList;
import com.youzan.cloud.open.sdk.gen.v1_0_0.api.YouzanScrmCustomerListPhone;
import com.youzan.cloud.open.sdk.gen.v1_0_0.api.YouzanScrmCustomerListYzopenid;
import com.youzan.cloud.open.sdk.gen.v1_0_0.api.YouzanUserOpenidGet;
import com.youzan.cloud.open.sdk.gen.v1_0_0.api.YouzanUsersInfoQuery;
import com.youzan.cloud.open.sdk.gen.v1_0_0.model.YouzanScrmCustomerListParams;
import com.youzan.cloud.open.sdk.gen.v1_0_0.model.YouzanScrmCustomerListPhoneParams;
import com.youzan.cloud.open.sdk.gen.v1_0_0.model.YouzanScrmCustomerListPhoneResult;
import com.youzan.cloud.open.sdk.gen.v1_0_0.model.YouzanScrmCustomerListResult;
import com.youzan.cloud.open.sdk.gen.v1_0_0.model.YouzanScrmCustomerListYzopenidParams;
import com.youzan.cloud.open.sdk.gen.v1_0_0.model.YouzanScrmCustomerListYzopenidResult;
import com.youzan.cloud.open.sdk.gen.v1_0_0.model.YouzanUserOpenidGetParams;
import com.youzan.cloud.open.sdk.gen.v1_0_0.model.YouzanUserOpenidGetResult;
import com.youzan.cloud.open.sdk.gen.v1_0_0.model.YouzanUsersInfoQueryParams;
import com.youzan.cloud.open.sdk.gen.v1_0_0.model.YouzanUsersInfoQueryResult;
import com.youzan.cloud.open.sdk.gen.v1_0_1.api.YouzanScrmCustomerDetailGet;
import com.youzan.cloud.open.sdk.gen.v1_0_1.model.YouzanScrmCustomerDetailGetParams;
import com.youzan.cloud.open.sdk.gen.v1_0_1.model.YouzanScrmCustomerDetailGetResult;
import com.youzan.cloud.open.sdk.gen.v3_1_0.api.YouzanScrmCustomerGet;
import com.youzan.cloud.open.sdk.gen.v3_1_0.model.YouzanScrmCustomerGetParams;
import com.youzan.cloud.open.sdk.gen.v3_1_0.model.YouzanScrmCustomerGetResult;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class YZCustomerServiceImpl
implements YZCustomerService {
    private static final Logger log = LoggerFactory.getLogger(YZCustomerServiceImpl.class);
    @Resource
    private ElectricityBizShopRelationMapper electricityBizShopRelationMapper;
    @Resource
    private ElectricityCustomerInfoMapper customerInfoMapper;
    @Resource
    private ElectricityMsgCallbackRecordMapper callbackRecordMapper;
    @Resource
    private YouZanClient yzClient;

    private ElectricityBizShopRelation getAccessToken(String shopId, Integer platform) {
        log.info("getAccessToken, shopId:{}, platform:{}", (Object)shopId, (Object)platform);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)shopId), (Object)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(platform), (Object)"\u5e73\u53f0\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        ElectricityBizShopRelation electricityBizShopRelation = this.electricityBizShopRelationMapper.selectByShopIdAndPlatform(shopId, platform);
        if (Objects.isNull(electricityBizShopRelation)) {
            log.info("\u6839\u636eshopId:{},platform:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)shopId, (Object)platform);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u5408\u6cd5\u7684shopId\u548cplatform");
        }
        return electricityBizShopRelation;
    }

    @Override
    public CustomerDetailResp queryYZCustomerDetail(EleCustomerDetailReq req) {
        log.info("queryYZCustomerDetail req: {}", (Object)req);
        req.validate();
        ElectricityBizShopRelation electricityBizShopRelation = this.getAccessToken(req.getShopId(), req.getPlatform());
        Token token = new Token(electricityBizShopRelation.getAccessToken());
        YouzanScrmCustomerGet youzanScrmCustomerGet = new YouzanScrmCustomerGet();
        YouzanScrmCustomerGetParams youzanScrmCustomerGetParams = new YouzanScrmCustomerGetParams();
        YouzanScrmCustomerGetParams.YouzanScrmCustomerGetParamsAccount youzanScrmCustomerGetParamsAccount = new YouzanScrmCustomerGetParams.YouzanScrmCustomerGetParamsAccount();
        youzanScrmCustomerGetParams.setAccount(youzanScrmCustomerGetParamsAccount);
        youzanScrmCustomerGetParamsAccount.setAccountId(req.getAccountId());
        youzanScrmCustomerGetParamsAccount.setAccountType(req.getAccountType());
        youzanScrmCustomerGet.setAPIParams((ApiParams)youzanScrmCustomerGetParams);
        YouzanScrmCustomerGetResult result = null;
        try {
            result = (YouzanScrmCustomerGetResult)this.yzClient.invoke((API)youzanScrmCustomerGet, (Auth)token, YouzanScrmCustomerGetResult.class);
        }
        catch (SDKException e) {
            e.printStackTrace();
        }
        if (Objects.isNull(result) || result.getCode() != 200) {
            log.info("\u6839\u636eshopId:{},platform:{} \u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25", (Object)req.getShopId(), (Object)req.getPlatform());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
        }
        YouzanScrmCustomerGetResult.YouzanScrmCustomerGetResultData data = result.getData();
        YouzanScrmCustomerGetResult.YouzanScrmCustomerGetResultContactaddress contactAddress = data.getContactAddress();
        CustomerDetailResp resp = new CustomerDetailResp();
        resp.setPlatform(req.getPlatform());
        resp.setShopId(req.getShopId());
        resp.setAppId(electricityBizShopRelation.getAppId());
        resp.setMobile(data.getMobile());
        resp.setName(data.getName());
        resp.setRemark(data.getRemark());
        resp.setGender((int)data.getGender());
        resp.setSourceChannel(data.getSourceChannel());
        CustomerAddressResp addressResp = new CustomerAddressResp();
        addressResp.setAddress(contactAddress.getAddress());
        addressResp.setProvince(contactAddress.getProvince());
        addressResp.setCity(contactAddress.getCity());
        addressResp.setCounty(contactAddress.getCounty());
        addressResp.setAreaCode(contactAddress.getAreaCode());
        resp.setAddress(addressResp.transAddress());
        log.info("queryYZCustomerDetail get resp\uff1a {}", (Object)resp);
        ElectricityCustomerInfo electricityCustomerInfo = this.customerInfoMapper.queryCustomerInfoByMobile(req.getShopId(), req.getPlatform(), data.getMobile());
        if (electricityCustomerInfo == null) {
            electricityCustomerInfo = new ElectricityCustomerInfo();
            electricityCustomerInfo.setPlatform(req.getPlatform());
            electricityCustomerInfo.setShopId(req.getShopId());
            electricityCustomerInfo.setAppId(electricityBizShopRelation.getAppId());
            electricityCustomerInfo.setBizId(electricityBizShopRelation.getBizId());
            electricityCustomerInfo.setMobile(data.getMobile());
            electricityCustomerInfo.setName(data.getName());
            electricityCustomerInfo.setRemark(data.getRemark());
            electricityCustomerInfo.setGender(Integer.valueOf(data.getGender().shortValue()));
            electricityCustomerInfo.setAddress(addressResp.transAddress());
            electricityCustomerInfo.setSourceChannel(data.getSourceChannel());
            electricityCustomerInfo.setIsDeleted(Integer.valueOf(0));
            electricityCustomerInfo.setIsSync(Integer.valueOf(0));
            electricityCustomerInfo.setCreateTime(new Date());
            electricityCustomerInfo.setUpdateTime(new Date());
            this.customerInfoMapper.insertSelective((Object)electricityCustomerInfo);
        } else {
            electricityCustomerInfo.setMobile(data.getMobile());
            electricityCustomerInfo.setName(data.getName());
            electricityCustomerInfo.setRemark(data.getRemark());
            electricityCustomerInfo.setGender(Integer.valueOf(data.getGender().shortValue()));
            electricityCustomerInfo.setAddress(addressResp.transAddress());
            electricityCustomerInfo.setSourceChannel(data.getSourceChannel());
            electricityCustomerInfo.setUpdateTime(new Date());
            this.customerInfoMapper.updateByPrimaryKeySelective((Object)electricityCustomerInfo);
        }
        return resp;
    }

    @Override
    public String getYZOpenId(CustomerUserReq req) {
        log.info("getYZOpenId get userId: {}, shopId: {}, platform: {}", new Object[]{req.getUserId(), req.getShopId(), req.getPlatform()});
        Preconditions.checkArgument((boolean)Objects.nonNull(req.getUserId()), (Object)"userId\u4e0d\u80fd\u4e3a\u7a7a");
        ElectricityBizShopRelation relation = this.getAccessToken(req.getShopId(), req.getPlatform());
        Token token = new Token(relation.getAccessToken());
        YouzanUserOpenidGet youzanUserOpenidGet = new YouzanUserOpenidGet();
        YouzanUserOpenidGetParams youzanUserOpenidGetParams = new YouzanUserOpenidGetParams();
        youzanUserOpenidGetParams.setUserId(req.getUserId());
        youzanUserOpenidGet.setAPIParams((ApiParams)youzanUserOpenidGetParams);
        YouzanUserOpenidGetResult result = null;
        try {
            result = (YouzanUserOpenidGetResult)this.yzClient.invoke((API)youzanUserOpenidGet, (Auth)token, YouzanUserOpenidGetResult.class);
        }
        catch (SDKException e) {
            e.printStackTrace();
        }
        if (Objects.isNull(result) || result.getCode() != 200) {
            log.info("\u6839\u636eshopId:{},platform:{} \u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25", (Object)req.getShopId(), (Object)req.getPlatform());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25");
        }
        YouzanUserOpenidGetResult.YouzanUserOpenidGetResultData data = result.getData();
        Long yzUserId = data.getUserId();
        String yzOpenId = data.getYzOpenId();
        log.info("getYZOpenId get yzUserId: {}, yzOpenId: {}", (Object)yzUserId, (Object)yzOpenId);
        ElectricityCustomerInfo electricityCustomerInfo = this.customerInfoMapper.queryCustomerInfoByplatformUserId(req.getShopId(), req.getPlatform(), yzUserId);
        if (electricityCustomerInfo != null) {
            electricityCustomerInfo.setPlatformOpenId(yzOpenId);
            electricityCustomerInfo.setUpdateTime(new Date());
            this.customerInfoMapper.updateByPrimaryKeySelective((Object)electricityCustomerInfo);
        }
        return yzOpenId;
    }

    @Override
    public CustomerDetailResp queryYZCustomerDetailInfo(CustomerReq req) {
        ElectricityCustomerInfo customerInfo;
        log.info("queryYZCustomerDetailInfo get yzOpenId: {}, shopId: {}, platform: {}", new Object[]{req.getYxOpenId(), req.getShopId(), req.getPlatform()});
        Preconditions.checkArgument((boolean)Objects.nonNull(req.getYxOpenId()), (Object)"openId\u4e0d\u80fd\u4e3a\u7a7a");
        ElectricityBizShopRelation relation = this.getAccessToken(req.getShopId(), req.getPlatform());
        Token token = new Token(relation.getAccessToken());
        YouzanScrmCustomerDetailGet youzanScrmCustomerDetailGet = new YouzanScrmCustomerDetailGet();
        YouzanScrmCustomerDetailGetParams youzanScrmCustomerDetailGetParams = new YouzanScrmCustomerDetailGetParams();
        String fields = "user_base,tags,benefit_cards,benefit_level,benefit_rights,credit,behavior,giftcard,prepaid,coupon";
        youzanScrmCustomerDetailGetParams.setFields(fields);
        youzanScrmCustomerDetailGetParams.setYzOpenId(req.getYxOpenId());
        youzanScrmCustomerDetailGet.setAPIParams((ApiParams)youzanScrmCustomerDetailGetParams);
        YouzanScrmCustomerDetailGetResult result = null;
        try {
            result = (YouzanScrmCustomerDetailGetResult)this.yzClient.invoke((API)youzanScrmCustomerDetailGet, (Auth)token, YouzanScrmCustomerDetailGetResult.class);
        }
        catch (SDKException e) {
            e.printStackTrace();
        }
        if (Objects.isNull(result) || result.getCode() != 200) {
            log.info("\u6839\u636eshopId:{},platform:{} \u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25", (Object)req.getShopId(), (Object)req.getPlatform());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25");
        }
        YouzanScrmCustomerDetailGetResult.YouzanScrmCustomerDetailGetResultData data = result.getData();
        String address = "";
        if (StringUtils.isNotBlank((CharSequence)data.getProvinceName())) {
            address = data.getProvinceName();
        }
        if (StringUtils.isNotBlank((CharSequence)data.getCityName())) {
            address = address + data.getCityName();
        }
        if (StringUtils.isNotBlank((CharSequence)data.getCountyName())) {
            address = address + data.getCountyName();
        }
        if ((customerInfo = this.customerInfoMapper.queryCustomerInfoByPlatformOpenId(req.getShopId(), req.getPlatform(), req.getYxOpenId())) == null) {
            customerInfo = new ElectricityCustomerInfo();
            customerInfo.setBizId(relation.getBizId());
            customerInfo.setPlatform(req.getPlatform());
            customerInfo.setShopId(req.getShopId());
            customerInfo.setAppId(relation.getAppId());
            customerInfo.setCreateTime(new Date());
            customerInfo.setUpdateTime(new Date());
            customerInfo.setIsDeleted(Integer.valueOf(0));
            customerInfo.setIsSync(Integer.valueOf(0));
            if (StringUtils.isNotBlank((CharSequence)data.getMobile())) {
                customerInfo.setMobile(data.getMobile());
            }
            customerInfo.setGender(Integer.valueOf(data.getGender().shortValue()));
            customerInfo.setName(data.getName());
            customerInfo.setRemark(data.getRemark());
            customerInfo.setWxId(data.getWeiXin());
            customerInfo.setWxNickname(data.getWxNickname());
            customerInfo.setWxAvatar(data.getWxAvatar());
            customerInfo.setAddress(address);
            this.customerInfoMapper.insertSelective((Object)customerInfo);
        } else {
            if (StringUtils.isNotBlank((CharSequence)data.getMobile())) {
                customerInfo.setMobile(data.getMobile());
            }
            customerInfo.setGender(Integer.valueOf(data.getGender().shortValue()));
            customerInfo.setName(data.getName());
            customerInfo.setRemark(data.getRemark());
            customerInfo.setWxId(data.getWeiXin());
            customerInfo.setWxNickname(data.getWxNickname());
            customerInfo.setWxAvatar(data.getWxAvatar());
            customerInfo.setAddress(address);
            customerInfo.setUpdateTime(new Date());
            this.customerInfoMapper.updateByPrimaryKeySelective((Object)customerInfo);
        }
        CustomerDetailResp resp = new CustomerDetailResp();
        resp.setPlatform(req.getPlatform());
        resp.setShopId(req.getShopId());
        resp.setAppId(relation.getAppId());
        resp.setMobile(data.getMobile());
        resp.setGender((int)data.getGender());
        resp.setName(data.getName());
        resp.setRemark(data.getRemark());
        resp.setWxId(data.getWeiXin());
        resp.setWxNickName(data.getWxNickname());
        resp.setWxAvatar(data.getWxAvatar());
        resp.setAddress(address);
        return resp;
    }

    @Override
    public List<CustomerDetailResp> getYZCustomerList(CustomerListReq req) {
        log.info("getYZCustomerList get shopId: {}, platform: {}", (Object)req.getShopId(), (Object)req.getPlatform());
        ElectricityBizShopRelation relation = this.getAccessToken(req.getShopId(), req.getPlatform());
        Token token = new Token(relation.getAccessToken());
        YouzanScrmCustomerList youzanScrmCustomerList = new YouzanScrmCustomerList();
        YouzanScrmCustomerListParams youzanScrmCustomerListParams = new YouzanScrmCustomerListParams();
        if (req.getPageDto() == null) {
            youzanScrmCustomerListParams.setPageNo(Integer.valueOf(1));
            youzanScrmCustomerListParams.setPageSize(Integer.valueOf(20));
        } else {
            youzanScrmCustomerListParams.setPageNo(req.getPageDto().getPageNum());
            youzanScrmCustomerListParams.setPageSize(req.getPageDto().getPageSize());
        }
        if (Objects.nonNull(req.getHasMobile())) {
            youzanScrmCustomerListParams.setHasMobile(Boolean.valueOf(req.getHasMobile() == 1));
        }
        youzanScrmCustomerList.setAPIParams((ApiParams)youzanScrmCustomerListParams);
        YouzanScrmCustomerListResult result = null;
        try {
            result = (YouzanScrmCustomerListResult)this.yzClient.invoke((API)youzanScrmCustomerList, (Auth)token, YouzanScrmCustomerListResult.class);
        }
        catch (SDKException e) {
            e.printStackTrace();
        }
        if (Objects.isNull(result) || result.getCode() != 200) {
            log.info("\u6839\u636eshopId:{},platform:{} \u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25", (Object)req.getShopId(), (Object)req.getPlatform());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25");
        }
        YouzanScrmCustomerListResult.YouzanScrmCustomerListResultData data = result.getData();
        Integer total = data.getTotal().intValue();
        Integer pageNo = data.getPageNo();
        req.getPageDto().setCount(total);
        req.getPageDto().setPageNum(pageNo);
        List recordList = data.getRecordList();
        log.info("getYZCustomerList get recordList: {}", (Object)recordList);
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            List hasCustomerInfos;
            ArrayList customerInfos = Lists.newArrayList();
            ArrayList respList = Lists.newArrayList();
            for (YouzanScrmCustomerListResult.YouzanScrmCustomerListResultRecordlist customerListResultRecordlist : recordList) {
                Integer gender = customerListResultRecordlist.getGender().intValue();
                String showName = customerListResultRecordlist.getShowName();
                String mobile = customerListResultRecordlist.getMobile();
                String yzOpenId = customerListResultRecordlist.getYzOpenId();
                ElectricityCustomerInfo customerInfo = new ElectricityCustomerInfo();
                customerInfo.setBizId(relation.getBizId());
                customerInfo.setPlatform(req.getPlatform());
                customerInfo.setShopId(req.getShopId());
                customerInfo.setAppId(relation.getAppId());
                customerInfo.setMobile(mobile);
                customerInfo.setName(showName);
                customerInfo.setGender(gender);
                customerInfo.setPlatformOpenId(yzOpenId);
                customerInfo.setCreateTime(new Date());
                customerInfo.setUpdateTime(new Date());
                customerInfo.setIsDeleted(Integer.valueOf(0));
                customerInfo.setIsSync(Integer.valueOf(0));
                customerInfos.add(customerInfo);
                CustomerDetailResp resp = new CustomerDetailResp();
                resp.setPlatform(req.getPlatform());
                resp.setShopId(req.getShopId());
                resp.setAppId(relation.getAppId());
                resp.setMobile(mobile);
                resp.setName(showName);
                resp.setGender(gender);
                resp.setOpenId(yzOpenId);
                respList.add(resp);
            }
            List hasPlatformOpenId = this.customerInfoMapper.queryAllPlatformOpenId(req.getShopId(), req.getPlatform());
            List newPlatformOpenId = customerInfos.stream().map(ElectricityCustomerInfo::getPlatformOpenId).collect(Collectors.toList());
            hasPlatformOpenId.retainAll(newPlatformOpenId);
            newPlatformOpenId.removeAll(hasPlatformOpenId);
            log.info("getYZCustomerList get hasPlatformOpenId: {}, newPlatformOpenId: {}", (Object)hasPlatformOpenId, newPlatformOpenId);
            List lastCustomerInfos = customerInfos.stream().filter(a -> newPlatformOpenId.contains(a.getPlatformOpenId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lastCustomerInfos)) {
                this.customerInfoMapper.insertCustomerInfoList(lastCustomerInfos);
            }
            if (CollectionUtils.isNotEmpty(hasCustomerInfos = customerInfos.stream().filter(a -> hasPlatformOpenId.contains(a.getPlatformOpenId())).collect(Collectors.toList()))) {
                this.customerInfoMapper.updateCustomerInfoList(hasCustomerInfos);
            }
            return respList;
        }
        return null;
    }

    @Override
    public List<CustomerDetailResp> getCustomerDetailByMobiles(CustomerQueryListReq req) {
        log.info("getCustomerDetailByMobiles get shopId: {}, platform: {}", (Object)req.getShopId(), (Object)req.getPlatform());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(req.getIds()), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ElectricityBizShopRelation relation = this.getAccessToken(req.getShopId(), req.getPlatform());
        Token token = new Token(relation.getAccessToken());
        YouzanScrmCustomerListPhone youzanScrmCustomerListPhone = new YouzanScrmCustomerListPhone();
        YouzanScrmCustomerListPhoneParams youzanScrmCustomerListPhoneParams = new YouzanScrmCustomerListPhoneParams();
        youzanScrmCustomerListPhoneParams.setPhones(req.getIds());
        youzanScrmCustomerListPhone.setAPIParams((ApiParams)youzanScrmCustomerListPhoneParams);
        YouzanScrmCustomerListPhoneResult result = null;
        try {
            result = (YouzanScrmCustomerListPhoneResult)this.yzClient.invoke((API)youzanScrmCustomerListPhone, (Auth)token, YouzanScrmCustomerListPhoneResult.class);
        }
        catch (SDKException e) {
            e.printStackTrace();
        }
        if (Objects.isNull(result) || result.getCode() != 200) {
            log.info("\u6839\u636eshopId:{},platform:{} \u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25", (Object)req.getShopId(), (Object)req.getPlatform());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25");
        }
        List data = result.getData();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            List hasCustomerInfos;
            ArrayList customerInfos = Lists.newArrayList();
            ArrayList respList = Lists.newArrayList();
            for (YouzanScrmCustomerListPhoneResult.YouzanScrmCustomerListPhoneResultData resultData : data) {
                YouzanScrmCustomerListPhoneResult.YouzanScrmCustomerListPhoneResultLabelinfo labelInfo = resultData.getLabelInfo();
                YouzanScrmCustomerListPhoneResult.YouzanScrmCustomerListPhoneResultSocialinfo socialInfo = resultData.getSocialInfo();
                String yzOpenId = resultData.getYzOpenId();
                String remark = labelInfo.getRemark();
                String mobile = socialInfo.getMobile();
                String wxId = socialInfo.getWeixin();
                String wxNickName = socialInfo.getWxNickname();
                ElectricityCustomerInfo customerInfo = new ElectricityCustomerInfo();
                customerInfo.setBizId(relation.getBizId());
                customerInfo.setPlatform(req.getPlatform());
                customerInfo.setShopId(req.getShopId());
                customerInfo.setAppId(relation.getAppId());
                customerInfo.setMobile(mobile);
                customerInfo.setRemark(remark);
                customerInfo.setPlatformOpenId(yzOpenId);
                customerInfo.setWxId(wxId);
                customerInfo.setWxNickname(wxNickName);
                customerInfo.setUpdateTime(new Date());
                customerInfo.setCreateTime(new Date());
                customerInfo.setIsDeleted(Integer.valueOf(0));
                customerInfo.setIsSync(Integer.valueOf(0));
                customerInfos.add(customerInfo);
                CustomerDetailResp resp = new CustomerDetailResp();
                resp.setPlatform(req.getPlatform());
                resp.setShopId(req.getShopId());
                resp.setAppId(relation.getAppId());
                resp.setMobile(mobile);
                resp.setRemark(remark);
                resp.setWxId(wxId);
                resp.setWxNickName(wxNickName);
                resp.setOpenId(yzOpenId);
                respList.add(resp);
            }
            List hasMobiles = this.customerInfoMapper.queryAllMobiles(req.getShopId(), req.getPlatform());
            List newMobiles = customerInfos.stream().map(ElectricityCustomerInfo::getMobile).collect(Collectors.toList());
            hasMobiles.retainAll(newMobiles);
            newMobiles.removeAll(hasMobiles);
            log.info("getYZCustomerList get hasMobiles: {}, newMobile: {}", (Object)hasMobiles, newMobiles);
            List lastCustomerInfos = customerInfos.stream().filter(a -> newMobiles.contains(a.getMobile())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lastCustomerInfos)) {
                this.customerInfoMapper.insertCustomerInfoList(lastCustomerInfos);
            }
            if (CollectionUtils.isNotEmpty(hasCustomerInfos = customerInfos.stream().filter(a -> hasMobiles.contains(a.getMobile())).collect(Collectors.toList()))) {
                this.customerInfoMapper.updateCustomerInfoList(hasCustomerInfos);
            }
            return respList;
        }
        return null;
    }

    @Override
    public List<CustomerDetailResp> getCustomerDetailByYZOpenId(CustomerQueryListReq req) {
        log.info("getCustomerDetailByYZOpenId get shopId: {}, platform: {}", (Object)req.getShopId(), (Object)req.getPlatform());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(req.getIds()), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ElectricityBizShopRelation relation = this.getAccessToken(req.getShopId(), req.getPlatform());
        Token token = new Token(relation.getAccessToken());
        YouzanScrmCustomerListYzopenid youzanScrmCustomerListYzopenid = new YouzanScrmCustomerListYzopenid();
        YouzanScrmCustomerListYzopenidParams youzanScrmCustomerListYzopenidParams = new YouzanScrmCustomerListYzopenidParams();
        youzanScrmCustomerListYzopenidParams.setYzOpenIds(req.getIds());
        youzanScrmCustomerListYzopenid.setAPIParams((ApiParams)youzanScrmCustomerListYzopenidParams);
        YouzanScrmCustomerListYzopenidResult result = null;
        try {
            result = (YouzanScrmCustomerListYzopenidResult)this.yzClient.invoke((API)youzanScrmCustomerListYzopenid, (Auth)token, YouzanScrmCustomerListYzopenidResult.class);
        }
        catch (SDKException e) {
            e.printStackTrace();
        }
        if (Objects.isNull(result) || result.getCode() != 200) {
            log.info("\u6839\u636eshopId:{},platform:{} \u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25", (Object)req.getShopId(), (Object)req.getPlatform());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25");
        }
        List data = result.getData();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            List hasCustomerInfos;
            ArrayList customerInfos = Lists.newArrayList();
            ArrayList respList = Lists.newArrayList();
            for (YouzanScrmCustomerListYzopenidResult.YouzanScrmCustomerListYzopenidResultData resultData : data) {
                YouzanScrmCustomerListYzopenidResult.YouzanScrmCustomerListYzopenidResultLabelinfo labelInfo = resultData.getLabelInfo();
                YouzanScrmCustomerListYzopenidResult.YouzanScrmCustomerListYzopenidResultSocialinfo socialInfo = resultData.getSocialInfo();
                String yzOpenId = resultData.getYzOpenId();
                String remark = labelInfo.getRemark();
                String mobile = socialInfo.getMobile();
                String wxId = socialInfo.getWeixin();
                String wxNickName = socialInfo.getWxNickname();
                ElectricityCustomerInfo customerInfo = new ElectricityCustomerInfo();
                customerInfo.setBizId(relation.getBizId());
                customerInfo.setPlatform(req.getPlatform());
                customerInfo.setShopId(req.getShopId());
                customerInfo.setAppId(relation.getAppId());
                customerInfo.setMobile(mobile);
                customerInfo.setRemark(remark);
                customerInfo.setPlatformOpenId(yzOpenId);
                customerInfo.setWxId(wxId);
                customerInfo.setWxNickname(wxNickName);
                customerInfo.setUpdateTime(new Date());
                customerInfo.setCreateTime(new Date());
                customerInfo.setIsDeleted(Integer.valueOf(0));
                customerInfo.setIsSync(Integer.valueOf(0));
                customerInfos.add(customerInfo);
                CustomerDetailResp resp = new CustomerDetailResp();
                resp.setPlatform(req.getPlatform());
                resp.setShopId(req.getShopId());
                resp.setAppId(relation.getAppId());
                resp.setMobile(mobile);
                resp.setRemark(remark);
                resp.setWxId(wxId);
                resp.setWxNickName(wxNickName);
                resp.setOpenId(yzOpenId);
                respList.add(resp);
            }
            List hasPlatformOpenId = this.customerInfoMapper.queryAllPlatformOpenId(req.getShopId(), req.getPlatform());
            List newPlatformOpenId = customerInfos.stream().map(ElectricityCustomerInfo::getPlatformOpenId).collect(Collectors.toList());
            hasPlatformOpenId.retainAll(newPlatformOpenId);
            newPlatformOpenId.removeAll(hasPlatformOpenId);
            log.info("getYZCustomerList get hasPlatformOpenId: {}, newPlatformOpenId: {}", (Object)hasPlatformOpenId, newPlatformOpenId);
            List lastCustomerInfos = customerInfos.stream().filter(a -> newPlatformOpenId.contains(a.getPlatformOpenId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lastCustomerInfos)) {
                this.customerInfoMapper.insertCustomerInfoList(lastCustomerInfos);
            }
            if (CollectionUtils.isNotEmpty(hasCustomerInfos = customerInfos.stream().filter(a -> hasPlatformOpenId.contains(a.getPlatformOpenId())).collect(Collectors.toList()))) {
                this.customerInfoMapper.updateCustomerInfoList(hasCustomerInfos);
            }
            return respList;
        }
        return null;
    }

    @Override
    public List<CustomerDetailResp> getUserInfo(CustomerUserInfoReq req) {
        log.info("getCustomerDetailByYZOpenId get shopId: {}, platform: {}, req: {}", new Object[]{req.getShopId(), req.getPlatform(), req});
        req.validate();
        ElectricityBizShopRelation relation = this.getAccessToken(req.getShopId(), req.getPlatform());
        Token token = new Token(relation.getAccessToken());
        YouzanUsersInfoQuery youzanUsersInfoQuery = new YouzanUsersInfoQuery();
        YouzanUsersInfoQueryParams youzanUsersInfoQueryParams = new YouzanUsersInfoQueryParams();
        if (StringUtils.isNotBlank((CharSequence)req.getYzOpenId())) {
            youzanUsersInfoQueryParams.setYzOpenId(req.getYzOpenId());
        }
        if (StringUtils.isNotBlank((CharSequence)req.getMobile())) {
            youzanUsersInfoQueryParams.setMobile(req.getMobile());
        }
        if (StringUtils.isNotBlank((CharSequence)req.getWxUnionId())) {
            youzanUsersInfoQueryParams.setWeixinUnionId(req.getWxUnionId());
        }
        if (StringUtils.isNotBlank((CharSequence)req.getWxOpenId())) {
            youzanUsersInfoQueryParams.setOpenIdType(req.getOpenIdType());
            youzanUsersInfoQueryParams.setWeixinOpenId(req.getWxOpenId());
        }
        if (CollectionUtils.isNotEmpty(req.getResultTypeList())) {
            youzanUsersInfoQueryParams.setResultTypeList(req.getResultTypeList());
        }
        youzanUsersInfoQuery.setAPIParams((ApiParams)youzanUsersInfoQueryParams);
        YouzanUsersInfoQueryResult result = null;
        try {
            result = (YouzanUsersInfoQueryResult)this.yzClient.invoke((API)youzanUsersInfoQuery, (Auth)token, YouzanUsersInfoQueryResult.class);
        }
        catch (SDKException e) {
            e.printStackTrace();
        }
        if (Objects.isNull(result) || result.getCode() != 200) {
            log.info("\u6839\u636eshopId:{},platform:{} \u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25", (Object)req.getShopId(), (Object)req.getPlatform());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u53d6\u6709\u8d5e\u63a5\u53e3\u5931\u8d25");
        }
        YouzanUsersInfoQueryResult.YouzanUsersInfoQueryResultData data = result.getData();
        List userList = data.getUserList();
        if (CollectionUtils.isNotEmpty((Collection)userList)) {
            List hasCustomerInfos;
            ArrayList customerInfos = Lists.newArrayList();
            ArrayList respList = Lists.newArrayList();
            for (YouzanUsersInfoQueryResult.YouzanUsersInfoQueryResultUserlist user : userList) {
                YouzanUsersInfoQueryResult.YouzanUsersInfoQueryResultWechatinfo wechatInfo = user.getWechatInfo();
                YouzanUsersInfoQueryResult.YouzanUsersInfoQueryResultPrimitiveinfo primitiveInfo = user.getPrimitiveInfo();
                YouzanUsersInfoQueryResult.YouzanUsersInfoQueryResultMobileinfo mobileInfo = user.getMobileInfo();
                YouzanUsersInfoQueryResult.YouzanUsersInfoQueryResultPlatforminfo platformInfo = user.getPlatformInfo();
                ElectricityCustomerInfo customerInfo = new ElectricityCustomerInfo();
                customerInfo.setBizId(relation.getBizId());
                customerInfo.setPlatform(req.getPlatform());
                customerInfo.setShopId(req.getShopId());
                customerInfo.setAppId(relation.getAppId());
                customerInfo.setUpdateTime(new Date());
                customerInfo.setCreateTime(new Date());
                customerInfo.setIsDeleted(Integer.valueOf(0));
                customerInfo.setIsSync(Integer.valueOf(0));
                CustomerDetailResp resp = new CustomerDetailResp();
                resp.setPlatform(req.getPlatform());
                resp.setShopId(req.getShopId());
                resp.setAppId(relation.getAppId());
                if (Objects.nonNull(wechatInfo)) {
                    customerInfo.setWxUnionId(wechatInfo.getUnionId());
                    resp.setWxUnionId(wechatInfo.getUnionId());
                }
                if (Objects.nonNull(primitiveInfo)) {
                    customerInfo.setGender(primitiveInfo.getGender());
                    customerInfo.setName(primitiveInfo.getNickName());
                    customerInfo.setPlatformOpenId(primitiveInfo.getYzOpenId());
                    String address = "";
                    if (StringUtils.isNotBlank((CharSequence)primitiveInfo.getCountry())) {
                        address = address + primitiveInfo.getCountry();
                    }
                    if (StringUtils.isNotBlank((CharSequence)primitiveInfo.getProvince())) {
                        address = primitiveInfo.getProvince();
                    }
                    if (StringUtils.isNotBlank((CharSequence)primitiveInfo.getCity())) {
                        address = address + primitiveInfo.getCity();
                    }
                    customerInfo.setAddress(address);
                    resp.setGender(primitiveInfo.getGender());
                    resp.setName(primitiveInfo.getNickName());
                    resp.setOpenId(primitiveInfo.getYzOpenId());
                    resp.setAddress(address);
                }
                if (Objects.nonNull(mobileInfo)) {
                    customerInfo.setMobile(mobileInfo.getMobile());
                    resp.setMobile(mobileInfo.getMobile());
                }
                if (Objects.nonNull(platformInfo)) {
                    customerInfo.setWxOpenId(platformInfo.getWeixinOpenId());
                    resp.setWxOpenId(platformInfo.getWeixinOpenId());
                }
                customerInfos.add(customerInfo);
                respList.add(resp);
            }
            List hasPlatformOpenId = this.customerInfoMapper.queryAllPlatformOpenId(req.getShopId(), req.getPlatform());
            List newPlatformOpenId = customerInfos.stream().map(ElectricityCustomerInfo::getPlatformOpenId).collect(Collectors.toList());
            hasPlatformOpenId.retainAll(newPlatformOpenId);
            newPlatformOpenId.removeAll(hasPlatformOpenId);
            log.info("getYZCustomerList get hasPlatformOpenId: {}, newPlatformOpenId: {}", (Object)hasPlatformOpenId, newPlatformOpenId);
            List lastCustomerInfos = customerInfos.stream().filter(a -> newPlatformOpenId.contains(a.getPlatformOpenId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lastCustomerInfos)) {
                this.customerInfoMapper.insertCustomerInfoList(lastCustomerInfos);
            }
            if (CollectionUtils.isNotEmpty(hasCustomerInfos = customerInfos.stream().filter(a -> hasPlatformOpenId.contains(a.getPlatformOpenId())).collect(Collectors.toList()))) {
                this.customerInfoMapper.updateCustomerInfoList(hasCustomerInfos);
            }
            return respList;
        }
        return null;
    }

    @Override
    public void handleCustomerMsg(PlatformMsgDto platformMsgDto) {
        if (PlatformEnum.YOU_ZAN.getValue() == platformMsgDto.getPlatform().intValue()) {
            YzMessageTypeEnum yzMessageTypeEnum = YzMessageTypeEnum.get((String)platformMsgDto.getEventType());
            if (yzMessageTypeEnum == null) {
                return;
            }
            switch (yzMessageTypeEnum) {
                case SCRM_CUSTOMER_EVENT: {
                    this.handleScrmCustoemrEvent(platformMsgDto, yzMessageTypeEnum);
                    break;
                }
                case OPEN_PUSH_SCRM_CUSTOMER_AUTH_MOBILE: {
                    this.handleScrmCustomerAuthMobile(platformMsgDto, yzMessageTypeEnum);
                    break;
                }
                case OPEN_PUSH_SCRM_MEMBER_MOBILE_CHANGE: {
                    this.handleScrmMemberMobileChange(platformMsgDto, yzMessageTypeEnum);
                    break;
                }
                case YZ_CLOUD_CUSTOMERRELADD: {
                    this.handleYzCustomerRealAdd(platformMsgDto, yzMessageTypeEnum);
                    break;
                }
            }
        }
    }

    public void handleScrmCustoemrEvent(PlatformMsgDto platformMsgDto, YzMessageTypeEnum typeEnum) {
        log.info("handleScrmCustoemrEvent platformMsgDto: {}", (Object)platformMsgDto);
        CustomerEventMsg msg = (CustomerEventMsg)JSONObject.parseObject((String)platformMsgDto.getMsg(), CustomerEventMsg.class);
        log.info("handleScrmCustoemrEvent msg: {}", (Object)msg);
        String shopId = String.valueOf(msg.getKdtId());
        ElectricityBizShopRelation shopRelation = this.electricityBizShopRelationMapper.selectByShopIdAndPlatform(shopId, Integer.valueOf(PlatformEnum.YOU_ZAN.getValue()));
        if (Objects.isNull(shopRelation)) {
            log.error("handleAuthChangeEvent\u65f6\u5546\u6237\u5e73\u53f0\u5e97\u94fa\u5bf9\u5e94\u5173\u7cfb\u8fd8\u672a\u5efa\u7acb shopId: {}", (Object)shopId);
            return;
        }
        ElectricityMsgCallbackRecord msgCallbackRecord = platformMsgDto.buildMsgCallbackRecord();
        msgCallbackRecord.setBizId(shopRelation.getBizId());
        msgCallbackRecord.setAppId(shopRelation.getAppId());
        msgCallbackRecord.setCharge(typeEnum.getCharge());
        this.callbackRecordMapper.insertSelective((Object)msgCallbackRecord);
        String msgDecode = this.urlDecode(msg.getMsg());
        log.info("handleScrmCustoemrEvent msgDecode: {}", (Object)msgDecode);
        CustomerMsgEntity msgEntity = null;
        if (StringUtils.isNotBlank((CharSequence)msgDecode)) {
            msgEntity = (CustomerMsgEntity)JSONObject.parseObject((String)msgDecode, CustomerMsgEntity.class);
        }
        if (msgEntity == null) {
            log.info("parseObject msgEntity is null");
            return;
        }
        String yzOpenId = String.valueOf(msg.getYzOpenId());
        ElectricityCustomerInfo customerInfo = this.customerInfoMapper.queryCustomerInfoByPlatformOpenId(shopId, Integer.valueOf(PlatformEnum.YOU_ZAN.getValue()), yzOpenId);
        if (customerInfo == null) {
            customerInfo = new ElectricityCustomerInfo();
            customerInfo.setBizId(shopRelation.getBizId());
            customerInfo.setPlatform(Integer.valueOf(PlatformEnum.YOU_ZAN.getValue()));
            customerInfo.setShopId(shopId);
            customerInfo.setAppId(shopRelation.getAppId());
            customerInfo.setCreateTime(new Date());
            customerInfo.setUpdateTime(new Date());
            customerInfo.setIsDeleted(Integer.valueOf(0));
            customerInfo.setIsSync(Integer.valueOf(0));
            customerInfo.setMobile(msgEntity.getMobile());
            customerInfo.setPlatformOpenId(yzOpenId);
            customerInfo.setName(msgEntity.getName());
            customerInfo.setRemark(msgEntity.getRemark());
            customerInfo.setGender(msgEntity.getGender());
            customerInfo.setWxId(msgEntity.getWeiXin());
            this.customerInfoMapper.insertSelective((Object)customerInfo);
        } else {
            customerInfo.setMobile(msgEntity.getMobile());
            customerInfo.setPlatformOpenId(yzOpenId);
            customerInfo.setName(msgEntity.getName());
            customerInfo.setRemark(msgEntity.getRemark());
            customerInfo.setGender(msgEntity.getGender());
            customerInfo.setWxId(msgEntity.getWeiXin());
            customerInfo.setUpdateTime(new Date());
            this.customerInfoMapper.updateByPrimaryKeySelective((Object)customerInfo);
        }
        CustomerDetailReq orderDetailReq = this.buildCustomerDetail(customerInfo);
        OrderSubmitReq submitReq = platformMsgDto.getSubmitReq();
        if (Objects.isNull(submitReq)) {
            submitReq = new OrderSubmitReq();
        }
        submitReq.setCustomerDetailReq(orderDetailReq);
        submitReq.setBizId(shopRelation.getBizId());
    }

    private CustomerDetailReq buildCustomerDetail(ElectricityCustomerInfo customerInfo) {
        CustomerDetailReq customerDetailReq = CustomerDetailReq.builder().address(customerInfo.getAddress()).avatar(customerInfo.getWxAvatar()).name(customerInfo.getName()).gender(customerInfo.getGender()).remark(customerInfo.getRemark()).mobile(customerInfo.getMobile()).unionId(customerInfo.getWxUnionId()).platformCode(Integer.valueOf(PlatformEnum.YOU_ZAN.getValue())).build();
        return customerDetailReq;
    }

    public void handleScrmCustomerAuthMobile(PlatformMsgDto platformMsgDto, YzMessageTypeEnum typeEnum) {
        log.info("handleScrmCustomerAuthMobile platformMsgDto: {}", (Object)platformMsgDto);
        CustomerAuthMobileMsg msg = (CustomerAuthMobileMsg)JSONObject.parseObject((String)platformMsgDto.getMsg(), CustomerAuthMobileMsg.class);
        log.info("handleScrmCustomerAuthMobile msg: {}", (Object)msg);
        String shopId = String.valueOf(msg.getNodeKdtId());
        ElectricityBizShopRelation shopRelation = this.electricityBizShopRelationMapper.selectByShopIdAndPlatform(shopId, Integer.valueOf(PlatformEnum.YOU_ZAN.getValue()));
        if (Objects.isNull(shopRelation)) {
            log.error("handleAuthChangeEvent\u65f6\u5546\u6237\u5e73\u53f0\u5e97\u94fa\u5bf9\u5e94\u5173\u7cfb\u8fd8\u672a\u5efa\u7acb shopId: {}", (Object)shopId);
            return;
        }
        ElectricityMsgCallbackRecord msgCallbackRecord = platformMsgDto.buildMsgCallbackRecord();
        msgCallbackRecord.setBizId(shopRelation.getBizId());
        msgCallbackRecord.setAppId(shopRelation.getAppId());
        msgCallbackRecord.setCharge(typeEnum.getCharge());
        this.callbackRecordMapper.insertSelective((Object)msgCallbackRecord);
        ElectricityCustomerInfo customerInfo = this.customerInfoMapper.queryCustomerInfoByPlatformOpenId(shopId, Integer.valueOf(PlatformEnum.YOU_ZAN.getValue()), msg.getYzOpenId());
        if (customerInfo == null) {
            customerInfo = new ElectricityCustomerInfo();
            customerInfo.setBizId(shopRelation.getBizId());
            customerInfo.setPlatform(Integer.valueOf(PlatformEnum.YOU_ZAN.getValue()));
            customerInfo.setShopId(shopId);
            customerInfo.setAppId(shopRelation.getAppId());
            customerInfo.setMobile(msg.getMobile());
            customerInfo.setPlatformOpenId(msg.getYzOpenId());
            customerInfo.setCreateTime(new Date());
            customerInfo.setUpdateTime(new Date());
            customerInfo.setIsDeleted(Integer.valueOf(0));
            customerInfo.setIsSync(Integer.valueOf(0));
            this.customerInfoMapper.insertSelective((Object)customerInfo);
        } else {
            customerInfo.setMobile(msg.getMobile());
            customerInfo.setUpdateTime(new Date());
            this.customerInfoMapper.updateByPrimaryKeySelective((Object)customerInfo);
        }
        CustomerDetailReq orderDetailReq = this.buildCustomerDetail(customerInfo);
        OrderSubmitReq submitReq = platformMsgDto.getSubmitReq();
        if (Objects.isNull(submitReq)) {
            submitReq = new OrderSubmitReq();
        }
        submitReq.setCustomerDetailReq(orderDetailReq);
        submitReq.setBizId(shopRelation.getBizId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void handleScrmMemberMobileChange(PlatformMsgDto platformMsgDto, YzMessageTypeEnum typeEnum) {
        log.info("handleScrmMemberMobileChange platformMsgDto: {}", (Object)platformMsgDto);
        CustomerMobileChangeMsg msg = (CustomerMobileChangeMsg)JSONObject.parseObject((String)platformMsgDto.getMsg(), CustomerMobileChangeMsg.class);
        log.info("handleScrmMemberMobileChange msg: {}", (Object)msg);
        String shopId = String.valueOf(msg.getShopId());
        ElectricityBizShopRelation shopRelation = this.electricityBizShopRelationMapper.selectByShopIdAndPlatform(shopId, Integer.valueOf(PlatformEnum.YOU_ZAN.getValue()));
        if (Objects.isNull(shopRelation)) {
            log.error("handleAuthChangeEvent\u65f6\u5546\u6237\u5e73\u53f0\u5e97\u94fa\u5bf9\u5e94\u5173\u7cfb\u8fd8\u672a\u5efa\u7acb shopId: {}", (Object)shopId);
            return;
        }
        ElectricityMsgCallbackRecord msgCallbackRecord = platformMsgDto.buildMsgCallbackRecord();
        msgCallbackRecord.setBizId(shopRelation.getBizId());
        msgCallbackRecord.setAppId(shopRelation.getAppId());
        msgCallbackRecord.setCharge(typeEnum.getCharge());
        this.callbackRecordMapper.insertSelective((Object)msgCallbackRecord);
        ElectricityCustomerInfo customerInfo = this.customerInfoMapper.queryCustomerInfoByMobile(shopId, Integer.valueOf(PlatformEnum.YOU_ZAN.getValue()), msg.getOldMobile());
        if (Objects.isNull(customerInfo)) {
            customerInfo = new ElectricityCustomerInfo();
            customerInfo.setBizId(shopRelation.getBizId());
            customerInfo.setPlatform(Integer.valueOf(PlatformEnum.YOU_ZAN.getValue()));
            customerInfo.setShopId(shopId);
            customerInfo.setAppId(shopRelation.getAppId());
            customerInfo.setMobile(msg.getNewMobile());
            customerInfo.setOldMobile(msg.getOldMobile());
            customerInfo.setPlatformOpenId(msg.getYzOpenId());
            customerInfo.setCreateTime(new Date());
            customerInfo.setUpdateTime(new Date());
            customerInfo.setIsDeleted(Integer.valueOf(0));
            customerInfo.setIsSync(Integer.valueOf(0));
            this.customerInfoMapper.insertSelective((Object)customerInfo);
        } else {
            customerInfo.setMobile(msg.getNewMobile());
            customerInfo.setOldMobile(msg.getOldMobile());
            customerInfo.setUpdateTime(new Date());
            this.customerInfoMapper.updateByPrimaryKeySelective((Object)customerInfo);
        }
        CustomerDetailReq orderDetailReq = this.buildCustomerDetail(customerInfo);
        OrderSubmitReq submitReq = platformMsgDto.getSubmitReq();
        if (Objects.isNull(submitReq)) {
            submitReq = new OrderSubmitReq();
        }
        submitReq.setCustomerDetailReq(orderDetailReq);
        submitReq.setBizId(shopRelation.getBizId());
    }

    public void handleYzCustomerRealAdd(PlatformMsgDto platformMsgDto, YzMessageTypeEnum typeEnum) {
        log.info("handleYzCustomerRealAdd platformMsgDto: {}", (Object)platformMsgDto);
        CustomerRelAddMsg msg = (CustomerRelAddMsg)JSONObject.parseObject((String)platformMsgDto.getMsg(), CustomerRelAddMsg.class);
        log.info("handleYzCustomerRealAdd msg: {}", (Object)msg);
    }

    public String urlDecode(String urlToken) {
        String decoded = null;
        try {
            decoded = URLDecoder.decode(urlToken, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("URLEncode error {}", (Throwable)e);
        }
        return decoded;
    }
}

