/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.dal.entity.UnionIdChanged;
import cn.kinyun.customer.center.dal.entity.UnionIdChangedLog;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dal.mapper.UnionIdChangedLogMapper;
import cn.kinyun.customer.center.dal.mapper.UnionIdChangedMapper;
import cn.kinyun.customer.center.enums.CustomerIdType;
import cn.kinyun.customer.center.service.UnionIdChangedService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionIdChangedServiceImpl
implements UnionIdChangedService {
    private static final Logger log = LoggerFactory.getLogger(UnionIdChangedServiceImpl.class);
    private static final char SPLIT = ',';
    @Autowired
    private UnionIdChangedMapper unionIdChangedMapper;
    @Autowired
    private UnionIdChangedLogMapper unionIdChangedLogMapper;
    @Autowired
    private CustomerMapper customerMapper;
    private final ExecutorService executorService = new ThreadPoolExecutor(4, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), new ThreadFactoryBuilder().setNameFormat("UnionIdChanged-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public void asyncRecord(String oldUnionId, String newUnionId) {
        log.info("async record unionId change, oldUnionId={}, newUnionId={}", (Object)oldUnionId, (Object)newUnionId);
        this.executorService.submit(() -> {
            try {
                this.record(oldUnionId, newUnionId);
            }
            catch (Exception e) {
                log.error("async record unionId change error, oldUnionId={}, newUnionId={}", new Object[]{oldUnionId, newUnionId, e});
            }
        });
    }

    public void record(String oldUnionId, String newUnionId) {
        Map<String, UnionIdChanged> allRelatedMap;
        String toIdTrim;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{oldUnionId, newUnionId})) {
            log.warn("old or new unionId is empty");
            return;
        }
        String fromIdTrim = oldUnionId.trim();
        if (Objects.equals(fromIdTrim, toIdTrim = newUnionId.trim())) {
            log.warn("unionId not changed");
            return;
        }
        log.info("unionId changed, oldUnionId={}, newUnionId={}", (Object)oldUnionId, (Object)newUnionId);
        Date now = new Date();
        UnionIdChangedLog changedLog = this.unionIdChangedLogMapper.selectByFromIdToId(oldUnionId, newUnionId);
        if (changedLog != null) {
            log.info("UnionIdChangedLog is already exists");
            return;
        }
        log.info("save UnionIdChangedLog, fromId={}, toId={}", (Object)oldUnionId, (Object)newUnionId);
        changedLog = new UnionIdChangedLog();
        changedLog.setFromId(oldUnionId);
        changedLog.setToId(newUnionId);
        changedLog.setCreateTime(now);
        changedLog.setUpdateTime(now);
        this.unionIdChangedLogMapper.saveOrUpdate(changedLog);
        ArrayList fromTo = Lists.newArrayList((Object[])new String[]{oldUnionId, newUnionId});
        TreeSet<String> relatedUnionIds = new TreeSet<String>(fromTo);
        List mainRelated = this.unionIdChangedMapper.selectByUnionIds((Collection)fromTo);
        log.info("mainRelated={}", (Object)mainRelated);
        if (CollectionUtils.isNotEmpty((Collection)mainRelated)) {
            for (UnionIdChanged it : mainRelated) {
                if (!StringUtils.isNotBlank((CharSequence)it.getRelatedUnionIds())) continue;
                relatedUnionIds.addAll(Arrays.asList(StringUtils.split((String)it.getRelatedUnionIds(), (char)',')));
            }
        }
        List allRelated = this.unionIdChangedMapper.selectByUnionIds(relatedUnionIds);
        log.info("allRelated={}", (Object)allRelated);
        if (CollectionUtils.isNotEmpty((Collection)allRelated)) {
            allRelatedMap = new HashMap();
            for (UnionIdChanged it : allRelated) {
                allRelatedMap.put(it.getUnionId(), it);
                if (!StringUtils.isNotBlank((CharSequence)it.getRelatedUnionIds())) continue;
                relatedUnionIds.addAll(Arrays.asList(StringUtils.split((String)it.getRelatedUnionIds(), (char)',')));
            }
        } else {
            allRelatedMap = Collections.emptyMap();
        }
        String relatedUnionIdStr = StringUtils.join(relatedUnionIds, (char)',');
        ArrayList<UnionIdChanged> list = new ArrayList<UnionIdChanged>();
        for (String unionId : relatedUnionIds) {
            UnionIdChanged existsRecord = (UnionIdChanged)allRelatedMap.get(unionId);
            if (existsRecord == null) {
                log.info("create UnionIdChanged, unionId={}, relatedUnionIds={}", (Object)unionId, (Object)relatedUnionIdStr);
                UnionIdChanged unionIdChanged = new UnionIdChanged();
                unionIdChanged.setUnionId(unionId);
                unionIdChanged.setRelatedUnionIds(relatedUnionIdStr);
                unionIdChanged.setCreateTime(now);
                unionIdChanged.setUpdateTime(now);
                list.add(unionIdChanged);
                continue;
            }
            if (!Objects.equals(existsRecord.getRelatedUnionIds(), relatedUnionIdStr)) {
                log.info("update UnionIdChanged, unionId={}, relatedUnionIds={}, old={}", new Object[]{unionId, relatedUnionIdStr, existsRecord.getRelatedUnionIds()});
                existsRecord.setRelatedUnionIds(relatedUnionIdStr);
                existsRecord.setUpdateTime(now);
                list.add(existsRecord);
                continue;
            }
            log.info("Not changed, unionId={}", (Object)unionId);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            log.info("batch save UnionIdChanged, list={}", list);
            this.unionIdChangedMapper.batchSaveOrUpdate(list);
        } else {
            log.info("list is empty");
        }
    }

    public List<String> getChangedUnionIds(String unionId) {
        log.info("get getChangedUnionIds, unionId={}", (Object)unionId);
        UnionIdChanged unionIdChanged = this.unionIdChangedMapper.selectByUnionId(unionId);
        if (unionIdChanged == null || StringUtils.isBlank((CharSequence)unionIdChanged.getRelatedUnionIds())) {
            log.info("record not found, unionId={}", (Object)unionId);
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)unionIdChanged.getRelatedUnionIds(), (char)','));
    }

    public Map<String, List<String>> getChangedUnionIdMap(Collection<String> unionIds) {
        log.info("get getChangedUnionIdMap, unionIds={}", unionIds);
        List list = this.unionIdChangedMapper.selectByUnionIds(unionIds);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (UnionIdChanged unionIdChanged : list) {
            if (unionIdChanged == null || !StringUtils.isNotBlank((CharSequence)unionIdChanged.getRelatedUnionIds())) continue;
            result.put(unionIdChanged.getUnionId(), Arrays.asList(StringUtils.split((String)unionIdChanged.getRelatedUnionIds(), (char)',')));
        }
        return result;
    }

    public String getUnionIdByWeworkContactId(Long bizId, String contactId) {
        log.info("getUnionIdByWeworkContactId, bizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)contactId), (Object)"contactId is null");
        return this.getUnionIdByType(bizId, CustomerIdType.WEWORK_CONTACT_ID.getValue(), contactId, null);
    }

    public String getUnionIdByOfficialFans(Long bizId, String appId, String openId) {
        log.info("getUnionIdByOfficialFans, bizId:{}, appId:{}, openId:{}", new Object[]{bizId, appId, openId});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)openId), (Object)"openId is null");
        return this.getUnionIdByType(bizId, CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue(), appId, openId);
    }

    public String getUnionIdByMiniProgram(Long bizId, String appId, String openId) {
        log.info("getUnionIdByMiniProgram, bizId:{}, appId:{}, openId:{}", new Object[]{bizId, appId, openId});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)openId), (Object)"openId is null");
        return this.getUnionIdByType(bizId, CustomerIdType.MINI_PROGRAM_OPENID.getValue(), appId, openId);
    }

    private String getUnionIdByType(Long bizId, int type, String id1, String id2) {
        log.info("get unionId by type, bizId={}, type={}, id1={}, id2={}", new Object[]{bizId, type, id1, id2});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        if (StringUtils.isBlank((CharSequence)id2)) {
            id2 = "";
        }
        try {
            return this.customerMapper.getUnionIdByType(bizId, Integer.valueOf(type), id1, id2);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5ba2\u6237unionId\u5931\u8d25, id1={}", (Object)id1, (Object)e);
            return null;
        }
    }
}

