/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.common.context.ElectricSyncContext;
import cn.kinyun.customer.center.common.context.ElectricSyncContextUtil;
import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.order.AddressReq;
import cn.kinyun.customer.center.dto.req.order.LogisticsReq;
import cn.kinyun.customer.center.dto.req.order.OrderDispatchReq;
import cn.kinyun.customer.center.dto.req.order.OrderRecordReq;
import cn.kinyun.customer.center.dto.req.order.OrderReq;
import cn.kinyun.customer.center.dto.req.order.OrderSubmitReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderRefundInfoReq;
import cn.kinyun.customer.center.enums.CustomerIdType;
import cn.kinyun.customer.center.enums.OrderEventEnum;
import cn.kinyun.customer.center.sal.biz.utils.ToVoidFunction;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.customer.center.service.CcLogisticService;
import cn.kinyun.customer.center.service.OrderCenterService;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service
public class OrderCenterDispatcher
implements OrderCenterService {
    private static final Logger log = LoggerFactory.getLogger(OrderCenterDispatcher.class);
    @Autowired
    private CcCustomerOrderService ccCustomerOrderService;
    @Autowired
    private CcLogisticService ccLogisticService;
    @Autowired
    private CcCustomerDetailService customerDetailService;
    @Autowired
    private CcCustomerNumService customerNumService;
    @Value(value="${scrm.electricity.yz.aesKey}")
    private String aesKey;
    private static Map<Integer, ToVoidFunction<OrderDispatchReq>> functionMap = new ConcurrentHashMap<Integer, ToVoidFunction<OrderDispatchReq>>();
    private Map<Integer, Function<OrderSubmitReq, OrderDispatchReq>> paramFunctionMap = new ConcurrentHashMap<Integer, Function<OrderSubmitReq, OrderDispatchReq>>();

    @PostConstruct
    public void dispatcherInit() {
        Collection values = OrderEventEnum.CACHE.values();
        values.forEach(this::initFunction);
    }

    public void dispatch(OrderDispatchReq orderDispatchReq) {
        if (OrderEventEnum.get((int)orderDispatchReq.getEventType()) == null || orderDispatchReq.getData() == null) {
            return;
        }
        log.info("dispatch, orderDispatchReq={}", (Object)orderDispatchReq);
        ToVoidFunction<OrderDispatchReq> function = functionMap.get(orderDispatchReq.getEventType());
        if (function == null) {
            log.warn("unknown eventType={}", (Object)orderDispatchReq.getEventType());
            return;
        }
        try {
            function.applyAsVoid(orderDispatchReq);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
    }

    public void submit(OrderSubmitReq orderSubmitReq) {
        log.info("submit, orderSubmitReq={}", (Object)JSON.toJSONString((Object)orderSubmitReq));
        if (Objects.isNull(orderSubmitReq)) {
            return;
        }
        this.commonParamPrepare(orderSubmitReq);
        Collection values = OrderEventEnum.CACHE.values();
        for (OrderEventEnum item : values) {
            Function<OrderSubmitReq, OrderDispatchReq> function = this.paramFunctionMap.get(item.getValue());
            if (function == null) {
                log.warn("not yet init paramMap, eventType={}", (Object)item.getValue());
                continue;
            }
            OrderDispatchReq dispatchReqByFunctionMap = function.apply(orderSubmitReq);
            if (Objects.isNull(dispatchReqByFunctionMap)) continue;
            log.info("\u5b9e\u9645\u6267\u884c\u6570\u636e\u540c\u6b65\u4e1a\u52a1\u573a\u666f\uff1a{}", (Object)item.getDesc());
            this.dispatch(dispatchReqByFunctionMap);
        }
        ElectricSyncContextUtil.remove();
    }

    private void commonParamPrepare(OrderSubmitReq submitReq) {
        log.info("commonParamPrepare,submitReq:{}", (Object)submitReq);
        if (Objects.isNull(submitReq.getPlatformCode()) && Objects.isNull(submitReq.getSource())) {
            log.warn("platform code \u548csource \u4e3a\u7a7a");
        }
        ElectricSyncContext electricSyncContext = ElectricSyncContextUtil.get();
        electricSyncContext.setBizId(submitReq.getBizId());
        this.decodeCustomer(submitReq);
        String buyerTel = electricSyncContext.getBuyerTel();
        Long bizId = electricSyncContext.getBizId();
        if (StringUtils.isNotBlank((CharSequence)submitReq.getCustomerNum())) {
            electricSyncContext.setBuyerCustomerNum(submitReq.getCustomerNum());
        } else if (StringUtils.isNotBlank((CharSequence)buyerTel) && Objects.nonNull(bizId)) {
            String customerNum;
            boolean exist = this.customerNumService.mobileIsExist(bizId, buyerTel);
            if (exist) {
                customerNum = submitReq.getLeadsReq() != null && StringUtils.isNotBlank((CharSequence)submitReq.getLeadsReq().getUnionId()) ? this.customerNumService.getCustomerNumByType(bizId, CustomerIdType.MOBILE.getValue(), buyerTel, "", submitReq.getLeadsReq().getUnionId()) : this.customerNumService.getCustomerNumByType(bizId, CustomerIdType.MOBILE.getValue(), buyerTel, "", null);
                log.info("commonParamPrepare,customerNum:{}", (Object)customerNum);
            } else {
                CustomerDetailReq leadsReq = submitReq.getLeadsReq();
                leadsReq.setPlatformCode(submitReq.getPlatformCode());
                customerNum = this.customerDetailService.syncElectricPlatformCustomer(submitReq.getLeadsReq());
                log.info("commonParamPrepare,customerNum:{}", (Object)customerNum);
            }
            electricSyncContext.setBuyerCustomerNum(customerNum);
        }
        log.info("commonParamPrepare,electricContext:{}", (Object)JSON.toJSONString((Object)electricSyncContext));
    }

    private void decodeCustomer(OrderSubmitReq req) {
        if (Objects.isNull(req)) {
            return;
        }
        this.decodeAddressInfo(req.getAddressReq());
        this.decodeLeadsInfo(req.getLeadsReq());
    }

    private void decodeLeadsInfo(CustomerDetailReq req) {
        if (Objects.isNull(req)) {
            return;
        }
        ElectricSyncContext electricSyncContext = ElectricSyncContextUtil.get();
        if (StringUtils.isNotBlank((CharSequence)req.getName())) {
            electricSyncContext.setBuyerName(req.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)req.getMobile())) {
            electricSyncContext.setBuyerTel(req.getMobile());
        }
    }

    private void decodeAddressInfo(AddressReq req) {
        if (Objects.isNull(req)) {
            return;
        }
        ElectricSyncContext electricSyncContext = ElectricSyncContextUtil.get();
        electricSyncContext.setReceiveName(req.getReceiveName());
        electricSyncContext.setReceiveTel(req.getReceiveTel());
        electricSyncContext.setReceiveAddress(req.getDeliveryAddress());
    }

    public void initFunction(OrderEventEnum eventEnum) {
        switch (eventEnum) {
            case CUSTOMER: {
                functionMap.put(OrderEventEnum.CUSTOMER.getValue(), req -> {
                    Object data = req.getData();
                    CustomerDetailReq customerDetailReq = new CustomerDetailReq();
                    BeanUtils.copyProperties((Object)data, (Object)customerDetailReq);
                    ElectricSyncContext electricSyncContext = ElectricSyncContextUtil.get();
                    if (StringUtils.isNotBlank((CharSequence)electricSyncContext.getSource())) {
                        customerDetailReq.setSource(electricSyncContext.getSource());
                    }
                    String customerNum = this.customerDetailService.syncElectricPlatformCustomer(customerDetailReq);
                    electricSyncContext.setBuyerCustomerNum(customerNum);
                });
                this.paramFunctionMap.put(OrderEventEnum.CUSTOMER.getValue(), req -> {
                    if (Objects.isNull(req) || Objects.isNull(req.getCustomerDetailReq())) {
                        return null;
                    }
                    if (req.getCustomerDetailReq().getBizId() == null) {
                        req.getCustomerDetailReq().setBizId(req.getBizId());
                    }
                    return OrderDispatchReq.builder().eventType(Integer.valueOf(OrderEventEnum.CUSTOMER.getValue())).data((Object)req.getCustomerDetailReq()).build();
                });
                break;
            }
            case LEADS: {
                functionMap.put(OrderEventEnum.LEADS.getValue(), req -> {
                    Object data = req.getData();
                    CustomerDetailReq customerDetailReq = new CustomerDetailReq();
                    BeanUtils.copyProperties((Object)data, (Object)customerDetailReq);
                    ElectricSyncContext electricSyncContext = ElectricSyncContextUtil.get();
                    if (StringUtils.isNotBlank((CharSequence)electricSyncContext.getSource())) {
                        customerDetailReq.setSource(electricSyncContext.getSource());
                    }
                    this.customerDetailService.addOrderLeads(customerDetailReq);
                });
                this.paramFunctionMap.put(OrderEventEnum.LEADS.getValue(), req -> {
                    if (Objects.isNull(req) || Objects.isNull(req.getLeadsReq())) {
                        return null;
                    }
                    if (req.getLeadsReq().getBizId() == null) {
                        req.getLeadsReq().setBizId(req.getBizId());
                    }
                    return OrderDispatchReq.builder().eventType(Integer.valueOf(OrderEventEnum.LEADS.getValue())).data((Object)req.getLeadsReq()).build();
                });
                break;
            }
            case REFUND: {
                functionMap.put(OrderEventEnum.REFUND.getValue(), req -> {
                    Object data = req.getData();
                    List orderRefundInfoReqs = JacksonUtil.str2List((String)JacksonUtil.obj2Str((Object)data), SetOrderRefundInfoReq.class);
                    orderRefundInfoReqs.stream().forEach(orderRefundInfoReq -> {
                        ElectricSyncContext electricSyncContext = ElectricSyncContextUtil.get();
                        if (StringUtils.isNotBlank((CharSequence)electricSyncContext.getSource())) {
                            orderRefundInfoReq.setSource(electricSyncContext.getSource());
                        }
                        this.ccCustomerOrderService.refundOrder(orderRefundInfoReq);
                    });
                });
                this.paramFunctionMap.put(OrderEventEnum.REFUND.getValue(), req -> {
                    if (Objects.isNull(req) || CollectionUtils.isEmpty((Collection)req.getOrderRefundInfoReqs())) {
                        return null;
                    }
                    req.getOrderRefundInfoReqs().stream().filter(orderRefundInfoReq -> orderRefundInfoReq.getBizId() == null).forEach(orderRefundInfoReq -> orderRefundInfoReq.setBizId(req.getBizId()));
                    return OrderDispatchReq.builder().eventType(Integer.valueOf(OrderEventEnum.REFUND.getValue())).data((Object)req.getOrderRefundInfoReqs()).build();
                });
                break;
            }
            case PAY: {
                functionMap.put(OrderEventEnum.PAY.getValue(), req -> {
                    Object data = req.getData();
                    List orderRecordReqs = JacksonUtil.str2List((String)JacksonUtil.obj2Str((Object)data), OrderRecordReq.class);
                    orderRecordReqs.stream().forEach(orderRecordReq -> {
                        ElectricSyncContext electricSyncContext = ElectricSyncContextUtil.get();
                        if (StringUtils.isNotBlank((CharSequence)electricSyncContext.getSource())) {
                            orderRecordReq.setSource(electricSyncContext.getSource());
                        }
                        this.ccCustomerOrderService.addOrderPayRecord(orderRecordReq);
                    });
                });
                this.paramFunctionMap.put(OrderEventEnum.PAY.getValue(), req -> {
                    if (Objects.isNull(req) || CollectionUtils.isEmpty((Collection)req.getOrderRecordReqs())) {
                        return null;
                    }
                    req.getOrderRecordReqs().stream().filter(orderRecordReq -> orderRecordReq.getBizId() == null).forEach(orderRecordReq -> orderRecordReq.setBizId(req.getBizId()));
                    return OrderDispatchReq.builder().eventType(Integer.valueOf(OrderEventEnum.PAY.getValue())).data((Object)req.getOrderRecordReqs()).build();
                });
                break;
            }
            case ORDER: {
                functionMap.put(OrderEventEnum.ORDER.getValue(), value -> {
                    Object data = value.getData();
                    List orderReqs = JacksonUtil.str2List((String)JacksonUtil.obj2Str((Object)data), OrderReq.class);
                    if (CollectionUtils.isNotEmpty((Collection)orderReqs)) {
                        orderReqs.forEach(orderReq -> {
                            ElectricSyncContext context = ElectricSyncContextUtil.get();
                            if (StringUtils.isNotBlank((CharSequence)context.getReceiveTel())) {
                                orderReq.setReceiveTel(context.getReceiveTel());
                            }
                            if (StringUtils.isNotBlank((CharSequence)context.getReceiveName())) {
                                orderReq.setReceiveName(context.getReceiveName());
                            }
                            orderReq.setCustomerNum(context.getBuyerCustomerNum());
                            orderReq.setDeliveryAddress(context.getReceiveAddress());
                            if (StringUtils.isNotBlank((CharSequence)context.getSource())) {
                                orderReq.setSource(context.getSource());
                            }
                            this.ccCustomerOrderService.addOrder(orderReq);
                        });
                    }
                });
                this.paramFunctionMap.put(OrderEventEnum.ORDER.getValue(), req -> {
                    log.info("order req:{}", (Object)JSON.toJSONString((Object)req));
                    if (Objects.isNull(req) || CollectionUtils.isEmpty((Collection)req.getOrderReqs())) {
                        return null;
                    }
                    req.getOrderReqs().stream().filter(orderRecordReq -> orderRecordReq.getBizId() == null).forEach(orderReq -> orderReq.setBizId(req.getBizId()));
                    return OrderDispatchReq.builder().eventType(Integer.valueOf(OrderEventEnum.ORDER.getValue())).data((Object)req.getOrderReqs()).build();
                });
                break;
            }
            case LOGISTIC: {
                functionMap.put(OrderEventEnum.LOGISTIC.getValue(), req -> {
                    Object data = req.getData();
                    List logisticsReq = JacksonUtil.str2List((String)JacksonUtil.obj2Str((Object)data), LogisticsReq.class);
                    this.ccLogisticService.addLogistic(logisticsReq);
                });
                this.paramFunctionMap.put(OrderEventEnum.LOGISTIC.getValue(), req -> {
                    if (Objects.isNull(req) || CollectionUtils.isEmpty((Collection)req.getLogisticsReqs())) {
                        return null;
                    }
                    return OrderDispatchReq.builder().eventType(Integer.valueOf(OrderEventEnum.LOGISTIC.getValue())).data((Object)req.getLogisticsReqs()).build();
                });
                break;
            }
        }
    }
}

