/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.crm.common.service.CrmCustomerService;
import cn.kinyun.customer.center.dal.dto.CustomerNumUserIdPair;
import cn.kinyun.customer.center.dal.dto.CustomerNumWeworkUserNumPair;
import cn.kinyun.customer.center.dal.entity.CustomerBinding;
import cn.kinyun.customer.center.dal.entity.CustomerStage;
import cn.kinyun.customer.center.dal.mapper.CustomerBindingMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerStageMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerTagMapper;
import cn.kinyun.customer.center.dto.req.operator.CustomerStageQueryReq;
import cn.kinyun.customer.center.dto.req.operator.CustomerTagQueryReq;
import cn.kinyun.customer.center.dto.req.operator.NewCustomerQueryReq;
import cn.kinyun.customer.center.sal.biz.operator.executor.OperatorTaskService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcOperatorService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.OperatorResult;
import com.kuaike.scrm.common.dto.OperatorResultItemDto;
import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.common.enums.OperatorResultMemberType;
import com.kuaike.scrm.common.service.ScrmUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CcOperatorServiceImpl
implements CcOperatorService {
    private static final Logger log = LoggerFactory.getLogger(CcOperatorServiceImpl.class);
    @Autowired
    private OperatorTaskService operatorTaskService;
    @Autowired
    private CustomerTagMapper customerTagMapper;
    @Resource
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private CustomerBindingMapper customerBindingMapper;

    public String customerTagAsync(CustomerTagQueryReq req) {
        log.info("customerTagAsync with req={}", (Object)req);
        req.validate();
        String requestId = UUID.randomUUID().toString().replace("-", "");
        this.operatorTaskService.executeOperator(req.getBizId(), requestId, () -> {
            Map key2Item = Maps.newHashMap();
            boolean put = true;
            HashMap weworkUserNum2UserIdMap = Maps.newHashMap();
            req.getUserId2WeworkUserNumMap().forEach((k, v) -> weworkUserNum2UserIdMap.put(v, k));
            List userIds = req.getUserId2WeworkUserNumMap().keySet().stream().collect(Collectors.toList());
            List weworkUserNums = req.getUserId2WeworkUserNumMap().values().stream().distinct().collect(Collectors.toList());
            for (List tagGroup : req.getTagGroups()) {
                List customerNumUserIdPairsScrm = this.customerTagMapper.queryByUserIdsTagList(req.getBizId(), Integer.valueOf(1), req.getProductLineId(), userIds, tagGroup);
                List customerNumUserIdPairsOthers = this.customerTagMapper.queryByUserIdsTagList(req.getBizId(), Integer.valueOf(0), req.getProductLineId(), userIds, tagGroup);
                List customerNumWeworkUserNumPairsScrm = this.customerTagMapper.queryByWeworkUserNumsTagList(req.getBizId(), Integer.valueOf(1), req.getProductLineId(), weworkUserNums, tagGroup);
                List customerNumWeworkUserNumPairsOthers = this.customerTagMapper.queryByWeworkUserNumsTagList(req.getBizId(), Integer.valueOf(0), req.getProductLineId(), weworkUserNums, tagGroup);
                HashMap tmp = Maps.newHashMap();
                this.collectCustomerAndMemberByCustomerNumberUserIdPair(customerNumUserIdPairsScrm, tmp);
                this.collectCustomerAndMemberByCustomerNumberUserIdPair(customerNumUserIdPairsOthers, tmp);
                this.collectCustomerAndMemberByCustomerNumberWeworkUserNumPair(weworkUserNum2UserIdMap, customerNumWeworkUserNumPairsScrm, tmp);
                this.collectCustomerAndMemberByCustomerNumberWeworkUserNumPair(weworkUserNum2UserIdMap, customerNumWeworkUserNumPairsOthers, tmp);
                if (MapUtils.isEmpty((Map)tmp)) {
                    key2Item.clear();
                    break;
                }
                if (put) {
                    key2Item.putAll(tmp);
                    put = false;
                    continue;
                }
                key2Item = Maps.difference((Map)key2Item, (Map)tmp).entriesInCommon();
            }
            List list = key2Item.values().stream().collect(Collectors.toList());
            OperatorResult result = new OperatorResult();
            result.setBizId(req.getBizId());
            result.setRequestId(requestId);
            result.setCustomerType(OperatorResultCustomerType.CUSTOMER_NUM.getType());
            result.setMemberType(OperatorResultMemberType.USER_ID.getType());
            result.setList(list);
            return result;
        });
        return requestId;
    }

    private void collectCustomerAndMemberByCustomerNumberUserIdPair(List<CustomerNumUserIdPair> customerNumUserIdPairs, Map<String, OperatorResultItemDto> tmp) {
        customerNumUserIdPairs.stream().forEach(a -> {
            String key = String.format("%s##%d", a.getCustomerNum(), a.getUserId());
            if (!tmp.containsKey(key)) {
                OperatorResultItemDto dto = new OperatorResultItemDto();
                dto.setCustomerId(a.getCustomerNum());
                dto.setMemberId(String.valueOf(a.getUserId()));
                tmp.put(key, dto);
            }
        });
    }

    private void collectCustomerAndMemberByCustomerNumberWeworkUserNumPair(Map<String, Long> weworkUserNum2UserIdMap, List<CustomerNumWeworkUserNumPair> customerNumWeworkUserNumPairs, Map<String, OperatorResultItemDto> tmp) {
        customerNumWeworkUserNumPairs.stream().forEach(a -> {
            Long userId = (Long)weworkUserNum2UserIdMap.get(a.getWeworkUserNum());
            String key = String.format("%s##%d", a.getCustomerNum(), userId);
            if (!tmp.containsKey(key)) {
                OperatorResultItemDto dto = new OperatorResultItemDto();
                dto.setCustomerId(a.getCustomerNum());
                dto.setMemberId(String.valueOf(userId));
                tmp.put(key, dto);
            }
        });
    }

    public String customerStageAsync(CustomerStageQueryReq req) {
        log.info("customerStageAsync,req:{}", (Object)req);
        req.validate();
        String requestId = UUID.randomUUID().toString().replace("-", "");
        this.operatorTaskService.executeOperator(req.getBizId(), requestId, () -> {
            ArrayList<OperatorResultItemDto> list = new ArrayList<OperatorResultItemDto>();
            HashSet userIds = new HashSet();
            HashSet<Object> weworkUserNums = new HashSet<Object>();
            HashMap weworkUserNumUserIdMap = new HashMap();
            Map userIdWeworkUserNumMap = req.getUserIdWeworkUserNumMap();
            for (Map.Entry entry : userIdWeworkUserNumMap.entrySet()) {
                userIds.add(entry.getKey());
                String weworkUserNum = (String)entry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)weworkUserNum)) continue;
                weworkUserNums.add(weworkUserNum);
                weworkUserNumUserIdMap.put(weworkUserNum, entry.getKey());
            }
            HashMap<Long, Set> userIdCustomerNumMap = new HashMap<Long, Set>();
            if (CollectionUtils.isNotEmpty(userIds)) {
                List customerBindings = this.customerBindingMapper.queryBindCustomerNumByUserIds(req.getBizId(), userIds);
                for (Object customerBinding : customerBindings) {
                    Set set = userIdCustomerNumMap.getOrDefault(customerBinding.getUserId(), new HashSet());
                    set.add(customerBinding.getCustomerNum());
                    userIdCustomerNumMap.put(customerBinding.getUserId(), set);
                }
            }
            if (CollectionUtils.isNotEmpty(weworkUserNums)) {
                HashMap<String, String> weworkUserNumCustomerNumMap = new HashMap<String, String>();
                List customerBindings = this.customerBindingMapper.queryBindCustomerNumByWeworkUserNums(req.getBizId(), weworkUserNums);
                for (CustomerBinding customerBinding : customerBindings) {
                    weworkUserNumCustomerNumMap.put(customerBinding.getWeworkUserNum(), customerBinding.getCustomerNum());
                }
                for (Map.Entry entry : weworkUserNumCustomerNumMap.entrySet()) {
                    Long userId = (Long)weworkUserNumUserIdMap.get(entry.getKey());
                    if (userId == null) continue;
                    Set customerNums = userIdCustomerNumMap.getOrDefault(userId, new HashSet());
                    customerNums.add(entry.getValue());
                    userIdCustomerNumMap.put(userId, customerNums);
                }
            }
            HashSet customerNums = new HashSet();
            HashMap customerNumUserIdMap = new HashMap();
            for (Map.Entry entry : userIdCustomerNumMap.entrySet()) {
                customerNums.addAll((Collection)entry.getValue());
                for (String customerNum : (Set)entry.getValue()) {
                    customerNumUserIdMap.put(customerNum, entry.getKey());
                }
            }
            if (CollectionUtils.isNotEmpty(customerNums)) {
                Set stageIds = req.getStageIds();
                Long l = req.getFirstStageId();
                for (String customerNum : customerNums) {
                    Long userId;
                    CustomerStage customerStage = this.customerStageMapper.queryCustomerRecentStage(req.getBizId(), customerNum);
                    if (customerStage == null && stageIds.contains(l)) {
                        Long userId2 = (Long)customerNumUserIdMap.get(customerNum);
                        OperatorResultItemDto dto = new OperatorResultItemDto();
                        dto.setCustomerId(customerNum);
                        dto.setMemberId(userId2.toString());
                        list.add(dto);
                        continue;
                    }
                    if (customerStage == null || !stageIds.contains(customerStage.getStageId())) continue;
                    String weworkUserNum = customerStage.getWeworkUserNum();
                    Long customerStageUserId = customerStage.getUserId();
                    boolean containsByWeworkUserNum = weworkUserNumUserIdMap.containsKey(weworkUserNum);
                    boolean containsByUserId = userIdWeworkUserNumMap.containsKey(customerStageUserId);
                    if (StringUtils.isNotBlank((CharSequence)weworkUserNum) && !containsByWeworkUserNum || customerStageUserId != null && !customerStageUserId.equals(-1L) && !containsByUserId || (userId = (Long)customerNumUserIdMap.get(customerNum)) == null) continue;
                    OperatorResultItemDto dto = new OperatorResultItemDto();
                    dto.setCustomerId(customerNum);
                    dto.setMemberId(userId.toString());
                    list.add(dto);
                }
            }
            OperatorResult result = new OperatorResult();
            result.setBizId(req.getBizId());
            result.setRequestId(requestId);
            result.setCustomerType(OperatorResultCustomerType.CUSTOMER_NUM.getType());
            result.setMemberType(OperatorResultMemberType.USER_ID.getType());
            result.setList(list);
            return result;
        });
        return requestId;
    }

    public String newCustomerAsync(NewCustomerQueryReq req) {
        log.info("new customer async params: {}", (Object)req);
        req.valid();
        String requestId = UUID.randomUUID().toString().replace("-", "");
        this.operatorTaskService.executeOperator(req.getBizId(), requestId, () -> {
            Map userContactMap;
            List<Object> list = new ArrayList();
            if (req.getCustomerType() == 1) {
                userContactMap = this.scrmUserService.queryUserQyNewContact(req.getBizId(), req.getUserIds(), req.getAddFriendStart(), req.getAddFriendEnd());
                list = this.buildByUserContactId(req.getBizId(), userContactMap);
            } else if (req.getCustomerType() == 2) {
                Map userCustomerNumMap = this.crmCustomerService.queryUserNewCustomer(req.getBizId(), req.getProductLineId(), req.getUserIds(), req.getBindStart(), req.getBindEnd());
                list = this.buildByUserCustomerNum(userCustomerNumMap);
            } else if (req.getCustomerType() == 3) {
                userContactMap = this.scrmUserService.queryUserQyNewContact(req.getBizId(), req.getUserIds(), req.getAddFriendStart(), req.getAddFriendEnd());
                list = this.buildByUserContactId(req.getBizId(), userContactMap);
                Map userCustomerNumMap = this.crmCustomerService.queryUserNewCustomer(req.getBizId(), req.getProductLineId(), req.getUserIds(), req.getBindStart(), req.getBindEnd());
                list.addAll(this.buildByUserCustomerNum(userCustomerNumMap));
            }
            ArrayList filterList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(list)) {
                HashSet exists = Sets.newHashSet();
                for (OperatorResultItemDto operatorResultItemDto : list) {
                    String key = operatorResultItemDto.getCustomerId() + operatorResultItemDto.getMemberId();
                    if (!exists.contains(key)) {
                        filterList.add(operatorResultItemDto);
                    }
                    exists.add(key);
                }
            }
            OperatorResult result = new OperatorResult();
            result.setBizId(req.getBizId());
            result.setRequestId(requestId);
            result.setCustomerType(OperatorResultCustomerType.CUSTOMER_NUM.getType());
            result.setMemberType(OperatorResultMemberType.USER_ID.getType());
            result.setList((List)filterList);
            log.info("newCustomerAsync result: {}", (Object)result);
            return result;
        });
        return requestId;
    }

    private List<OperatorResultItemDto> buildByUserContactId(Long bizId, Map<Long, List<String>> userContactMap) {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<Long, List<String>> entry : userContactMap.entrySet()) {
            Long userId = entry.getKey();
            List<String> contactIds = userContactMap.get(userId);
            if (!CollectionUtils.isNotEmpty(contactIds)) continue;
            Map contactCustomerMap = this.ccCustomerNumService.butchGetCustomerNumByContactId(bizId, contactIds);
            ArrayList customerNums = Lists.newArrayList(contactCustomerMap.values());
            for (String customerNum : customerNums) {
                OperatorResultItemDto dto = new OperatorResultItemDto();
                dto.setMemberId(String.valueOf(userId));
                dto.setCustomerId(customerNum);
                result.add(dto);
            }
        }
        return result;
    }

    private List<OperatorResultItemDto> buildByUserCustomerNum(Map<Long, List<String>> userCustomerNumMap) {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<Long, List<String>> entry : userCustomerNumMap.entrySet()) {
            Long userId = entry.getKey();
            List<String> customerNums = userCustomerNumMap.get(userId);
            if (!CollectionUtils.isNotEmpty(customerNums)) continue;
            for (String customerNum : customerNums) {
                OperatorResultItemDto dto = new OperatorResultItemDto();
                dto.setMemberId(String.valueOf(userId));
                dto.setCustomerId(customerNum);
                result.add(dto);
            }
        }
        return result;
    }
}

