/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.entity.OrderDictionary;
import cn.kinyun.customer.center.dal.mapper.CustomerOrderMapper;
import cn.kinyun.customer.center.dal.mapper.OrderDictionaryMapper;
import cn.kinyun.customer.center.dto.req.EntryOrderConfigReq;
import cn.kinyun.customer.center.dto.resp.DynamicFieldDto;
import cn.kinyun.customer.center.dto.resp.EntryOrderConfigresp;
import cn.kinyun.customer.center.enums.OrderSource;
import cn.kinyun.customer.center.service.CcCustomerOrderSettingService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.enums.YnEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CcCustomerOrderSettingServiceImpl
implements CcCustomerOrderSettingService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerOrderSettingServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Resource
    private OrderDictionaryMapper orderDictionaryMapper;
    @Resource
    private CustomerOrderMapper customerOrderMapper;

    @Transactional
    public String orderSetting(EntryOrderConfigReq params) {
        log.info("order setting params: {}", (Object)params);
        List addSource = params.getSources();
        List enumSources = Arrays.stream(OrderSource.values()).map(item -> item.getDesc()).collect(Collectors.toList());
        addSource.removeAll(enumSources);
        params.setSources(addSource);
        params.validate();
        Long bizId = params.getBizId();
        String corpId = params.getCorpId();
        Long userId = params.getUserId();
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).orderByDesc((Object)"create_time");
        OrderDictionary orderDictionary = (OrderDictionary)this.orderDictionaryMapper.selectOne((Wrapper)queryWrapper);
        Date curTime = new Date();
        if (orderDictionary == null) {
            List<DynamicFieldDto> sourceList = this.buildFieldDtos(bizId, params.getSources(), Lists.newArrayList(), "source_");
            Integer extendRequire = params.getExtendFieldRequire();
            List<DynamicFieldDto> extendFields = null;
            if (extendRequire == 1) {
                extendFields = this.buildFieldDtos(bizId, params.getExtendField(), Lists.newArrayList(), "extend_");
            }
            String sources = JacksonUtil.obj2Str(sourceList);
            String extendFieldStr = JacksonUtil.obj2Str(extendFields);
            orderDictionary = OrderDictionary.builder().num(this.idGen.getNum()).bizId(bizId).corpId(corpId).sources(sources).extendFieldRequire(extendRequire).extendField(extendFieldStr).mobileRequire(params.getMobileRequire()).orderTimeRequire(params.getOrderTimeRequire()).nameRequire(params.getNameRequire()).createBy(userId).updateBy(userId).updateTime(curTime).createTime(curTime).build();
            this.orderDictionaryMapper.insert((Object)orderDictionary);
        } else {
            List<Object> sourceList = Lists.newArrayList();
            List<Object> extendFields = Lists.newArrayList();
            try {
                if (StringUtils.isNotBlank((CharSequence)orderDictionary.getSources())) {
                    sourceList = JacksonUtil.str2List((String)orderDictionary.getSources(), DynamicFieldDto.class);
                }
                if (StringUtils.isNotBlank((CharSequence)orderDictionary.getExtendField())) {
                    extendFields = JacksonUtil.str2List((String)orderDictionary.getExtendField(), DynamicFieldDto.class);
                }
            }
            catch (IOException e) {
                log.error("json parse error: ", (Throwable)e);
            }
            sourceList = this.buildFieldDtos(bizId, params.getSources(), sourceList, "source_");
            orderDictionary.setSources(JacksonUtil.obj2Str((Object)sourceList));
            orderDictionary.setExtendFieldRequire(params.getExtendFieldRequire());
            if (params.getExtendFieldRequire() == 1) {
                extendFields = this.buildFieldDtos(bizId, params.getExtendField(), extendFields, "extend_");
                orderDictionary.setExtendField(JacksonUtil.obj2Str((Object)extendFields));
            }
            orderDictionary.setMobileRequire(params.getMobileRequire());
            orderDictionary.setOrderTimeRequire(params.getOrderTimeRequire());
            orderDictionary.setNameRequire(params.getNameRequire());
            this.orderDictionaryMapper.updateById((Object)orderDictionary);
        }
        return orderDictionary.getNum();
    }

    private List<DynamicFieldDto> buildFieldDtos(Long bizId, List<String> list, List<DynamicFieldDto> existList, String preStr) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(existList)) {
            existList = Lists.newArrayList();
        }
        Map existMap = existList.stream().collect(Collectors.toMap(DynamicFieldDto::getName, Function.identity()));
        for (String source : list) {
            if (existMap.containsKey(source)) {
                DynamicFieldDto exist = (DynamicFieldDto)existMap.get(source);
                exist.setIsDeleted(Integer.valueOf(0));
                result.add(exist);
            } else {
                String key = preStr + this.idGen.getNum();
                DynamicFieldDto dto = new DynamicFieldDto();
                dto.setKey(key);
                dto.setName(source);
                dto.setIsDeleted(Integer.valueOf(0));
                result.add(dto);
            }
            existMap.remove(source);
        }
        if (!existMap.isEmpty()) {
            for (DynamicFieldDto dto : existMap.values()) {
                int use;
                if (preStr.equals("source_") && dto.getIsDeleted() == 0 && (use = this.customerOrderMapper.querySourceUse(bizId, dto.getKey())) > 0) {
                    throw new IllegalArgumentException("\u6765\u6e90: " + dto.getName() + " \u5df2\u7ecf\u4f7f\u7528\u8fc7\u4e0d\u80fd\u5220\u9664");
                }
                dto.setIsDeleted(Integer.valueOf(1));
                result.add(dto);
            }
        }
        return result;
    }

    @Transactional
    public EntryOrderConfigresp getOrderSetting(Long bizId, String corpId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"corpId\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).orderByDesc((Object)"create_time");
        OrderDictionary orderDictionary = (OrderDictionary)this.orderDictionaryMapper.selectOne((Wrapper)queryWrapper);
        log.info("getOrderSetting: bizId:{},corpId:{}", (Object)bizId, (Object)corpId);
        Date curTime = new Date();
        if (orderDictionary == null) {
            orderDictionary = OrderDictionary.builder().num(this.idGen.getNum()).bizId(bizId).corpId(corpId).extendFieldRequire(Integer.valueOf(0)).mobileRequire(Integer.valueOf(0)).orderTimeRequire(Integer.valueOf(0)).nameRequire(Integer.valueOf(0)).createBy(Long.valueOf(-1L)).updateBy(Long.valueOf(-1L)).updateTime(curTime).createTime(curTime).build();
            this.orderDictionaryMapper.insert((Object)orderDictionary);
        }
        EntryOrderConfigresp result = new EntryOrderConfigresp();
        List source = null;
        List extendFileds = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)orderDictionary.getSources())) {
                source = JacksonUtil.str2List((String)orderDictionary.getSources(), DynamicFieldDto.class);
                source = source.stream().filter(it -> it.getIsDeleted() == 0).collect(Collectors.toList());
                source.addAll(this.sourceToDynamicField());
            }
            if (orderDictionary.getExtendFieldRequire() == 1 && StringUtils.isNotBlank((CharSequence)orderDictionary.getExtendField())) {
                extendFileds = JacksonUtil.str2List((String)orderDictionary.getExtendField(), DynamicFieldDto.class);
                extendFileds = extendFileds.stream().filter(it -> it.getIsDeleted() == 0).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            log.error("json parse error: ", (Throwable)e);
        }
        result.setSources(source);
        result.setExtendFieldRequire(orderDictionary.getExtendFieldRequire());
        result.setExtendField(extendFileds);
        result.setMobileRequire(orderDictionary.getMobileRequire());
        result.setOrderTimeRequire(orderDictionary.getOrderTimeRequire());
        result.setNameRequire(orderDictionary.getNameRequire());
        return result;
    }

    private List<DynamicFieldDto> sourceToDynamicField() {
        return Arrays.stream(OrderSource.values()).map(item -> {
            DynamicFieldDto dynamicFieldDto = new DynamicFieldDto();
            dynamicFieldDto.setName(item.getDesc());
            dynamicFieldDto.setKey(item.getValue());
            dynamicFieldDto.setIsDefault(YnEnum.YES.getValue());
            dynamicFieldDto.setIsDeleted(YnEnum.NO.getValue());
            return dynamicFieldDto;
        }).collect(Collectors.toList());
    }
}

