/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.crm.common.service.CrmCustomerService;
import cn.kinyun.crm.common.service.dto.req.CustomerAreaReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsStatisticsResp;
import cn.kinyun.customer.center.dal.dto.OrderAmount;
import cn.kinyun.customer.center.dal.dto.QueryOrderDto;
import cn.kinyun.customer.center.dal.entity.OrderSkuList;
import cn.kinyun.customer.center.dal.mapper.CustomerOrderMapper;
import cn.kinyun.customer.center.dal.mapper.OrderSkuListMapper;
import cn.kinyun.customer.center.dal.util.BizTableContext;
import cn.kinyun.customer.center.dal.util.DateUtil;
import cn.kinyun.customer.center.dto.req.CcCustomerAreaReq;
import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.req.order.AmountStatisticsResp;
import cn.kinyun.customer.center.dto.req.order.BigScreenOrderReq;
import cn.kinyun.customer.center.dto.req.order.OrderAmountResp;
import cn.kinyun.customer.center.dto.resp.CcCustomerStatisticsResp;
import cn.kinyun.customer.center.dto.resp.OrderSkuResp;
import cn.kinyun.customer.center.dto.resp.OrderTotalResp;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.customer.center.service.CcOrderStatisticsService;
import cn.kinyun.customer.utils.MathUtils;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service
public class OrderStatisticsServiceImpl
implements CcOrderStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(OrderStatisticsServiceImpl.class);
    @Resource
    private CustomerOrderMapper customerOrderMapper;
    @Resource
    private OrderSkuListMapper orderSkuListMapper;
    @Autowired
    private CcCustomerOrderService customerOrderService;
    @Autowired
    private CrmCustomerService customerService;

    public List<OrderSkuResp> orderList(BigScreenOrderReq bigScreenReq) {
        List<Object> result;
        bigScreenReq.validate();
        BizTableContext.putBizId((Long)bigScreenReq.getBizId());
        QueryOrderDto queryOrderDto = this.convertBigScreenReqToQueryOrderDto(bigScreenReq);
        queryOrderDto.setPaidAmountStart(Long.valueOf(1L));
        List customerOrders = this.customerOrderMapper.queryOrderList(queryOrderDto);
        if (CollectionUtils.isNotEmpty((Collection)customerOrders)) {
            List orderNums = customerOrders.stream().map(item -> item.getOrderNo()).filter(Objects::nonNull).collect(Collectors.toList());
            List orderSkuLists = this.orderSkuListMapper.querySkuListByOrderNos(bigScreenReq.getBizId(), orderNums);
            Map<String, List<OrderSkuList>> groupByOrderNos = orderSkuLists.stream().collect(Collectors.groupingBy(OrderSkuList::getOrderNo));
            result = customerOrders.stream().map(item -> {
                OrderSkuResp orderSkuResp = new OrderSkuResp();
                orderSkuResp.setOrderNo(item.getOrderNo());
                orderSkuResp.setSkuAmount(item.getPaidAmount());
                orderSkuResp.setBizId(item.getBizId());
                orderSkuResp.setPaidTime(item.getOrderTime());
                List osl = (List)groupByOrderNos.get(item.getOrderNo());
                if (CollectionUtils.isNotEmpty((Collection)osl)) {
                    String skuUrl = osl.stream().map(OrderSkuList::getSkuImgUrl).filter(StringUtils::isNotBlank).findFirst().orElse("");
                    String skuNames = osl.stream().map(OrderSkuList::getSkuName).filter(StringUtils::isNotBlank).collect(Collectors.joining("/"));
                    orderSkuResp.setSkuImgUrl(skuUrl);
                    orderSkuResp.setSkuName(skuNames);
                }
                return orderSkuResp;
            }).collect(Collectors.toList());
        } else {
            result = Lists.newArrayList();
        }
        log.info("\u67e5\u8be2\u8ba2\u5355\u6570\u91cf\uff1a{}", (Object)CollectionUtils.size((Object)result));
        BizTableContext.clear();
        return result;
    }

    public AmountStatisticsResp amountStatistics(BigScreenOrderReq bigScreenReq) {
        bigScreenReq.validate();
        AmountStatisticsResp amountStatisticsResp = new AmountStatisticsResp();
        bigScreenReq.setPaidAmountStart(Long.valueOf(1L));
        log.info("\u7edf\u8ba1\u8ba2\u5355\u6570\u636e\uff1aparam:{}", (Object)JSON.toJSONString((Object)bigScreenReq));
        QueryOrderListReq queryOrderListReq = bigScreenReq.convertToOrderListReq();
        QueryOrderDto queryOrderDto = this.convertBigScreenReqToQueryOrderDto(bigScreenReq);
        OrderTotalResp totalResp = this.customerOrderService.orderTotal(queryOrderListReq);
        if (Objects.isNull(totalResp)) {
            return amountStatisticsResp;
        }
        amountStatisticsResp.setTotalOrderAmount(totalResp.getPaidTotal());
        amountStatisticsResp.setTotalOrderCount(Long.valueOf(totalResp.getOrderTotal().longValue()));
        List betweenDays = DateUtil.betweenDays((Date)queryOrderDto.getOrderTimeStart(), (Date)queryOrderDto.getOrderTimeEnd());
        List orderAmounts = this.customerOrderMapper.queryOrderAmountByOrderDate(queryOrderDto);
        Map groupByDateTime = orderAmounts.stream().filter(Objects::nonNull).collect(Collectors.toMap(OrderAmount::getDateTime, Function.identity()));
        ArrayList orderAmountsList = Lists.newArrayList();
        for (String betweenDay : betweenDays) {
            OrderAmount orderAmount = (OrderAmount)groupByDateTime.get(betweenDay);
            if (Objects.isNull(orderAmount)) {
                orderAmount = new OrderAmount();
                orderAmount.setDateTime(betweenDay);
                orderAmount.setOrderAmount(Long.valueOf(0L));
            }
            orderAmountsList.add(orderAmount);
        }
        List orderAmountResps = orderAmountsList.stream().sorted(Comparator.comparing(OrderAmount::getDateTime)).map(this::entityConvertToResp).collect(Collectors.toList());
        amountStatisticsResp.setOrderAmountList(orderAmountResps);
        log.info("\u7edf\u8ba1\u8ba2\u5355\u6570\u636e\uff1aresult:{}", (Object)JSON.toJSONString((Object)amountStatisticsResp));
        return amountStatisticsResp;
    }

    public List<CcCustomerStatisticsResp> orderMapStatistics(CcCustomerAreaReq req) {
        req.validateParam();
        QueryOrderDto queryOrderDto = this.convertByCcCustomerAreaReq(req);
        List allCustomerNums = this.customerOrderMapper.queryPaidCustomerNum(queryOrderDto);
        if (CollectionUtils.isEmpty((Collection)allCustomerNums)) {
            return Lists.newArrayList();
        }
        List partition = Lists.partition((List)allCustomerNums, (int)500);
        HashMap provinceLeadsCount = Maps.newHashMap();
        HashMap provinceWechatCount = Maps.newHashMap();
        HashMap provinceNames = Maps.newHashMap();
        for (List customerNums : partition) {
            CustomerAreaReq leadsAreaReq = new CustomerAreaReq();
            leadsAreaReq.setBizId(req.getBizId());
            leadsAreaReq.setCustomerNums(customerNums);
            leadsAreaReq.setStartTime(req.getStartTime());
            leadsAreaReq.setEndTime(req.getEndTime());
            List leadsAreaStatistics = null;
            try {
                log.info("\u8c03\u7528crm \u67e5\u8be2\u7ebf\u7d22\u5206\u5e03 param:{}", (Object)JSON.toJSONString((Object)leadsAreaReq));
                leadsAreaStatistics = this.customerService.getLeadsAreaStatistics(leadsAreaReq);
            }
            catch (Exception e) {
                log.error("\u8c03\u7528crm \u67e5\u8be2\u7ebf\u7d22\u5206\u5e03\u62a5\u9519:{}", (Object)e.getMessage());
            }
            if (CollectionUtils.isEmpty(leadsAreaStatistics)) continue;
            for (CrmLeadsStatisticsResp leadsAreaStatistic : leadsAreaStatistics) {
                Long beforeLeadsCount = provinceLeadsCount.getOrDefault(leadsAreaStatistic.getAreaCode(), 0L);
                provinceLeadsCount.put(leadsAreaStatistic.getAreaCode(), beforeLeadsCount + leadsAreaStatistic.getCustomerCount());
                Long beforeAddWechatCount = provinceWechatCount.getOrDefault(leadsAreaStatistic.getAreaCode(), 0L);
                provinceWechatCount.put(leadsAreaStatistic.getAreaCode(), beforeAddWechatCount + leadsAreaStatistic.getAddWechatCount());
                String provinceName = (String)provinceNames.get(leadsAreaStatistic.getAreaCode());
                if (!StringUtils.isBlank((CharSequence)provinceName)) continue;
                provinceNames.put(leadsAreaStatistic.getAreaCode(), leadsAreaStatistic.getAreaName());
            }
        }
        Long totalCount = provinceLeadsCount.values().stream().mapToLong(Long::longValue).sum();
        return provinceLeadsCount.keySet().stream().map(provinceId -> {
            CcCustomerStatisticsResp resp = new CcCustomerStatisticsResp();
            resp.setAreaCode(provinceId);
            resp.setBizId(req.getBizId());
            resp.setAreaName((String)provinceNames.get(provinceId));
            Long provinceCounts = provinceLeadsCount.getOrDefault(provinceId, 0L);
            resp.setCustomerCount(provinceCounts);
            BigDecimal percentageP = MathUtils.getPercentageP((Long)resp.getCustomerCount(), (Long)totalCount);
            String totalRate = percentageP + "%";
            resp.setTotalRate(totalRate);
            resp.setAddWechatCount((Long)provinceWechatCount.get(provinceId));
            String addWechatRate = MathUtils.getPercentageP((Long)provinceWechatCount.getOrDefault(provinceId, 0L), (Long)provinceCounts) + "%";
            resp.setAddWechatRate(addWechatRate);
            return resp;
        }).collect(Collectors.toList());
    }

    private QueryOrderDto convertBigScreenReqToQueryOrderDto(BigScreenOrderReq bigScreenReq) {
        QueryOrderDto queryOrderDto = new QueryOrderDto();
        queryOrderDto.setBizId(bigScreenReq.getBizId());
        queryOrderDto.setUserIds(bigScreenReq.getUserIdLongs());
        queryOrderDto.setOrderTimeStart(bigScreenReq.getStartTime());
        queryOrderDto.setOrderTimeEnd(bigScreenReq.getEndTime());
        queryOrderDto.setPageDto(bigScreenReq.getPageDto());
        queryOrderDto.setPaidAmountStart(bigScreenReq.getPaidAmountStart());
        return queryOrderDto;
    }

    private OrderAmountResp entityConvertToResp(OrderAmount orderAmount) {
        OrderAmountResp resp = new OrderAmountResp();
        resp.setOrderAmount(orderAmount.getOrderAmount());
        resp.setDateTime(orderAmount.getDateTime());
        return resp;
    }

    private QueryOrderDto convertByCcCustomerAreaReq(CcCustomerAreaReq areaReq) {
        QueryOrderDto queryOrderDto = new QueryOrderDto();
        queryOrderDto.setCustomerNums((Collection)areaReq.getCustomerNums());
        queryOrderDto.setOrderTimeEnd(areaReq.getEndTime());
        queryOrderDto.setOrderTimeStart(areaReq.getStartTime());
        queryOrderDto.setBizId(areaReq.getBizId());
        return queryOrderDto;
    }
}

