/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.dal.entity.Customer;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.enums.CustomerIdType;
import cn.kinyun.customer.center.sal.biz.service.CcCustomerServiceImpl;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CcCustomerService
implements CcCustomerServiceImpl {
    @Autowired
    private CustomerMapper customerMapper;

    @Override
    public List<String> getUserMobileByNum(Long bizId, String userNum) {
        if (StringUtils.isBlank((CharSequence)userNum)) {
            return Lists.newArrayList();
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"biz id is null");
        Customer customer = (Customer)this.customerMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)userNum));
        if (Objects.isNull(customer)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isBlank((CharSequence)customer.getMainNum())) {
            return customer.getIdType().equals(CustomerIdType.MOBILE.getValue()) ? Lists.newArrayList((Object[])new String[]{customer.getId1()}) : Lists.newArrayList();
        }
        return Optional.ofNullable(this.customerMapper.selectMobilesByMainNum(bizId, customer.getMainNum())).orElse(Lists.newArrayList());
    }
}

