/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.dto.QueryRefundOrderDto;
import cn.kinyun.customer.center.dal.entity.CustomerOrder;
import cn.kinyun.customer.center.dal.entity.CustomerRefundOrder;
import cn.kinyun.customer.center.dal.entity.OrderDictionary;
import cn.kinyun.customer.center.dal.entity.OrderSkuList;
import cn.kinyun.customer.center.dal.entity.RefundApprovalRecord;
import cn.kinyun.customer.center.dal.entity.RefundTransferRecord;
import cn.kinyun.customer.center.dal.mapper.CustomerDetailMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerOrderMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerRefundOrderMapper;
import cn.kinyun.customer.center.dal.mapper.OrderDictionaryMapper;
import cn.kinyun.customer.center.dal.mapper.OrderSkuListMapper;
import cn.kinyun.customer.center.dal.mapper.RefundApprovalRecordMapper;
import cn.kinyun.customer.center.dal.mapper.RefundTransferRecordMapper;
import cn.kinyun.customer.center.dal.util.BizTableContext;
import cn.kinyun.customer.center.dto.ApprovalMsgDto;
import cn.kinyun.customer.center.dto.req.ApprovalReq;
import cn.kinyun.customer.center.dto.req.QueryRefundOrderListReq;
import cn.kinyun.customer.center.dto.req.order.RefundOrderReq;
import cn.kinyun.customer.center.dto.resp.DynamicFieldDto;
import cn.kinyun.customer.center.dto.resp.PageRefundOrderListResp;
import cn.kinyun.customer.center.dto.resp.RefundOrderInfo;
import cn.kinyun.customer.center.dto.resp.RefundOrderListResp;
import cn.kinyun.customer.center.dto.resp.RefundOrderResp;
import cn.kinyun.customer.center.dto.resp.RefundOrderTotalResp;
import cn.kinyun.customer.center.enums.ApprovalStatus;
import cn.kinyun.customer.center.enums.OrderSource;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.enums.RefundTypeEnum;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerRefundOrderService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CcCustomerRefundOrderServiceImpl
implements CcCustomerRefundOrderService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerRefundOrderServiceImpl.class);
    @Autowired
    private CustomerRefundOrderMapper customerRefundOrderMapper;
    @Autowired
    private RefundTransferRecordMapper refundTransferRecordMapper;
    @Autowired
    private CustomerOrderMapper customerOrderMapper;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private OrderSkuListMapper orderSkuListMapper;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private CustomerDetailMapper customerDetailMapper;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private OrderDictionaryMapper orderDictionaryMapper;
    @Autowired
    private RefundApprovalRecordMapper refundApprovalRecordMapper;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Value(value="${kafka.topic.approval_msg:}")
    private String approvalMsgTopic;

    @Transactional
    public String refundOrder(RefundOrderReq req) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        req.validate();
        Long bizId = req.getBizId();
        Long userId = req.getUserId();
        CustomerOrder order = this.customerOrderMapper.getByOrderNo(bizId, req.getOrderNo());
        if (order == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u9000\u6b3e\u7684\u8ba2\u5355");
        }
        String corpId = this.scrmBizService.getById(bizId).getCorpId();
        CustomerRefundOrder refundOrder = this.saveRefundOrder(bizId, corpId, userId, req);
        if (req.getRefundType().intValue() == RefundTypeEnum.TRANSFER.getValue()) {
            this.saveRefundTransferRecord(bizId, refundOrder.getNum(), userId, req);
        }
        this.saveApprovalRecord(bizId, req.getApprovalType(), req.getApprovalUsers(), refundOrder.getOrderNo(), refundOrder.getNum());
        for (Long approvalUserId : req.getApprovalUsers()) {
            this.sendApprovalMsg(refundOrder, approvalUserId, false);
        }
        return refundOrder.getNum();
    }

    public void updateRefundOrder(RefundOrderReq req) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long bizId = req.getBizId();
        Long userId = req.getUserId();
        log.info("update refund order bizId: {}, userId: {}, req: {}", new Object[]{bizId, userId, req});
        req.validate();
        if (StringUtils.isBlank((CharSequence)req.getRefundOrderNum())) {
            throw new IllegalArgumentException("\u9000\u5355\u552f\u4e00\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerRefundOrder refundOrder = (CustomerRefundOrder)this.customerRefundOrderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"num", (Object)req.getRefundOrderNum()));
        if (refundOrder == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u9000\u6b3e\u5355");
        }
        Date curTime = new Date();
        refundOrder.setRefundAmount(req.getRefundAmount());
        refundOrder.setOrderAmount(req.getOrderAmount());
        refundOrder.setOtherAmount(req.getOtherAmount());
        refundOrder.setStatus(Integer.valueOf(RefundStatusEnum.WAIT_REFUND.getValue()));
        if (req.getApprovalType() == 0) {
            refundOrder.setApprovalStatus(Integer.valueOf(ApprovalStatus.APPROVAL_SUCCESS.getValue()));
        } else {
            refundOrder.setApprovalStatus(Integer.valueOf(ApprovalStatus.APPROVAL_DOING.getValue()));
        }
        refundOrder.setRefundType(req.getRefundType());
        refundOrder.setRemark(req.getRemark());
        refundOrder.setReason(req.getReason());
        refundOrder.setAttachments(JacksonUtil.obj2Str((Object)req.getAttachments()));
        refundOrder.setRefundSkus(JacksonUtil.obj2Str((Object)req.getRefundSkus()));
        refundOrder.setUpdateTime(curTime);
        refundOrder.setUpdateBy(userId);
        this.customerRefundOrderMapper.updateById((Object)refundOrder);
        if (req.getRefundType().intValue() == RefundTypeEnum.TRANSFER.getValue()) {
            this.saveRefundTransferRecord(bizId, refundOrder.getNum(), userId, req);
        }
        this.saveApprovalRecord(bizId, req.getApprovalType(), req.getApprovalUsers(), refundOrder.getOrderNo(), refundOrder.getNum());
        if (req.getApprovalType() == 1) {
            for (Long approvalUserId : req.getApprovalUsers()) {
                this.sendApprovalMsg(refundOrder, approvalUserId, false);
            }
        }
    }

    @Transactional
    public void approvalAgain(RefundOrderReq req) {
        Long bizId = req.getBizId();
        if (StringUtils.isBlank((CharSequence)req.getRefundOrderNum())) {
            throw new IllegalArgumentException("\u9000\u6b3e\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_Id", (Object)bizId)).eq((Object)"num", (Object)req.getRefundOrderNum());
        CustomerRefundOrder refundOrder = (CustomerRefundOrder)this.customerRefundOrderMapper.selectOne((Wrapper)queryWrapper);
        if (refundOrder == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u9000\u6b3e\u5355");
        }
        if (refundOrder.getApprovalStatus().intValue() == ApprovalStatus.APPROVAL_DOING.getValue()) {
            throw new IllegalArgumentException("\u9000\u6b3e\u5355\u6b63\u5728\u5ba1\u6279\u4e2d\u4e0d\u80fd\u91cd\u65b0\u53d1\u8d77\u5ba1\u6279");
        }
        if (refundOrder.getApprovalStatus().intValue() == ApprovalStatus.APPROVAL_SUCCESS.getValue()) {
            throw new IllegalArgumentException("\u9000\u6b3e\u5355\u5ba1\u6279\u5df2\u7ecf\u901a\u8fc7\u4e0d\u80fd\u91cd\u65b0\u53d1\u8d77\u5ba1\u6279");
        }
        refundOrder.setApprovalStatus(Integer.valueOf(ApprovalStatus.APPROVAL_DOING.getValue()));
        refundOrder.setApprovalRemark("");
        this.customerRefundOrderMapper.updateById((Object)refundOrder);
        this.saveApprovalRecord(bizId, req.getApprovalType(), req.getApprovalUsers(), refundOrder.getOrderNo(), refundOrder.getNum());
    }

    private void saveApprovalRecord(Long bizId, Integer approvalType, List<Long> approvalUsers, String orderNo, String refundOrderNum) {
        log.info("save approval record approvalType: {}, approvalUsers: {}, refundOrderNum: {}", new Object[]{approvalType, approvalUsers, refundOrderNum});
        if (approvalType == 0) {
            return;
        }
        if (approvalType == 1) {
            ArrayList insertRecords = Lists.newArrayList();
            Date curTime = new Date();
            for (Long userId : approvalUsers) {
                RefundApprovalRecord approvalRecord = new RefundApprovalRecord();
                approvalRecord.setBizId(bizId);
                approvalRecord.setOrderNo(orderNo);
                approvalRecord.setRefundNum(refundOrderNum);
                approvalRecord.setUserId(userId);
                String weworkUserNum = this.scrmUserService.getWeworkUserNumByUserId(userId);
                approvalRecord.setWeworkUserNum(weworkUserNum);
                approvalRecord.setApprovalStatus(Integer.valueOf(ApprovalStatus.APPROVAL_DOING.getValue()));
                approvalRecord.setCreateTime(curTime);
                approvalRecord.setUpdateTime(curTime);
                approvalRecord.setUpdateBy(userId);
                approvalRecord.setCreateBy(userId);
                insertRecords.add(approvalRecord);
            }
            if (CollectionUtils.isNotEmpty((Collection)insertRecords)) {
                this.refundApprovalRecordMapper.batchInsert((Collection)insertRecords);
            }
        }
    }

    public String queryRefundByOrderNo(Long bizId, String orderNo) {
        log.info("bizId: {}, orderNo: {}", (Object)bizId, (Object)orderNo);
        if (bizId == null || StringUtils.isBlank((CharSequence)orderNo)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.customerRefundOrderMapper.queryRunningRefundByOrderNo(bizId, orderNo);
    }

    public List<RefundOrderResp> queryRefundOrder(Long bizId, String orderNo, String refundOrderNum) {
        log.info("bizId: {}, orderNo: {}", (Object)bizId, (Object)orderNo);
        if (bizId == null || StringUtils.isBlank((CharSequence)orderNo)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List refundOrders = this.customerRefundOrderMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"order_no", (Object)orderNo)).eq(StringUtils.isNotBlank((CharSequence)refundOrderNum), (Object)"num", (Object)refundOrderNum));
        ArrayList result = Lists.newArrayList();
        for (CustomerRefundOrder refundOrder : refundOrders) {
            RefundOrderResp orderResp = new RefundOrderResp();
            orderResp.setOrderNo(refundOrder.getOrderNo());
            orderResp.setRefundType(refundOrder.getRefundType());
            orderResp.setRefundNo(refundOrder.getRefundNo());
            orderResp.setStatus(refundOrder.getStatus());
            orderResp.setApprovalStatus(refundOrder.getApprovalStatus());
            result.add(orderResp);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateRefundOrderSpStatus(Long bizId, Long approvalUser, String refundOrderNum, Integer spStatus, String remark) {
        log.info("approvalUser: {}, refundOrderNum: {}, spStatus: {}", new Object[]{approvalUser, refundOrderNum, spStatus});
        if (StringUtils.isBlank((CharSequence)refundOrderNum) || spStatus == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ApprovalStatus.get((int)spStatus) == null) {
            throw new IllegalArgumentException("\u5ba1\u6279\u72b6\u6001\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        CustomerRefundOrder refundOrder = (CustomerRefundOrder)this.customerRefundOrderMapper.selectOne((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)refundOrderNum));
        if (refundOrder == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u9000\u6b3e\u5355");
        }
        if (refundOrder.getStatus().intValue() == RefundStatusEnum.REFUNDED.getValue()) {
            throw new IllegalArgumentException("\u9000\u6b3e\u5355\u5df2\u7ecf\u9000\u6b3e\uff0c\u4e0d\u9700\u8981\u518d\u6b21\u5ba1\u6279");
        }
        if (refundOrder.getApprovalStatus().intValue() == ApprovalStatus.APPROVAL_SUCCESS.getValue()) {
            throw new IllegalArgumentException("\u5ba1\u6279\u901a\u8fc7\u4e86\uff0c\u4e0d\u80fd\u518d\u66f4\u65b0\u5ba1\u6279\u72b6\u6001");
        }
        refundOrder.setApprovalStatus(spStatus);
        refundOrder.setApprovalRemark(remark);
        this.customerRefundOrderMapper.updateById((Object)refundOrder);
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"refund_num", (Object)refundOrderNum)).eq((Object)"user_id", (Object)approvalUser)).orderByDesc((Object)"id");
        List refundApprovalRecords = this.refundApprovalRecordMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)refundApprovalRecords)) {
            RefundApprovalRecord approvalRecord = (RefundApprovalRecord)refundApprovalRecords.get(0);
            approvalRecord.setApprovalStatus(spStatus);
            approvalRecord.setUpdateTime(new Date());
            this.refundApprovalRecordMapper.updateById((Object)approvalRecord);
        }
        if (spStatus.intValue() == ApprovalStatus.APPROVAL_SUCCESS.getValue()) {
            this.sendApprovalMsg(refundOrder, approvalUser, false);
        }
    }

    private RefundTransferRecord getTransferConfig(String refundOrderNum) {
        List transferRecords = this.refundTransferRecordMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"refund_num", (Object)refundOrderNum)).orderByDesc((Object)"id"));
        log.info("transferRecords: {}, refundOrderNum: {}", (Object)transferRecords, (Object)refundOrderNum);
        if (CollectionUtils.isNotEmpty((Collection)transferRecords)) {
            return (RefundTransferRecord)transferRecords.get(0);
        }
        return null;
    }

    private void sendApprovalMsg(CustomerRefundOrder refundOrder, Long approvalUser, boolean updateTransferAccount) {
        ApprovalMsgDto msgDto = new ApprovalMsgDto();
        String refundOrderNum = refundOrder.getNum();
        msgDto.setBizId(refundOrder.getBizId());
        msgDto.setRefundNum(refundOrderNum);
        msgDto.setRefundOrderNo(refundOrder.getRefundNo());
        msgDto.setOrderNo(refundOrder.getOrderNo());
        msgDto.setRefundAmount(refundOrder.getRefundAmount());
        msgDto.setRefundType(refundOrder.getRefundType());
        if (msgDto.getRefundType().intValue() == RefundTypeEnum.TRANSFER.getValue()) {
            RefundTransferRecord transferConfig = this.getTransferConfig(refundOrderNum);
            if (transferConfig == null) {
                throw new IllegalArgumentException("\u627e\u4e0d\u5230\u8f6c\u8d26\u7684\u4fe1\u606f");
            }
            msgDto.setUpdateTransferAccount(Boolean.valueOf(updateTransferAccount));
            msgDto.setAccountName(transferConfig.getAccountName());
            msgDto.setAccount(transferConfig.getAccount());
        }
        msgDto.setApprovalUserId(approvalUser);
        msgDto.setRefundReason(refundOrder.getReason());
        msgDto.setApprovalStatus(refundOrder.getApprovalStatus());
        msgDto.setOpUserId(refundOrder.getCreateBy());
        msgDto.setMsgTimestamp(Long.valueOf(System.currentTimeMillis()));
        log.info("approval pass msgDto: {}", (Object)msgDto);
        this.kafkaTemplate.send(this.approvalMsgTopic, (Object)("inner:" + msgDto.getRefundNum()), (Object)JacksonUtil.obj2Str((Object)msgDto));
    }

    private void updateOrderRefundAmount(Long bizId, String orderNo, Integer refundStatus) {
        QueryRefundOrderDto query = new QueryRefundOrderDto();
        query.setBizId(bizId);
        query.setOrderNo(orderNo);
        query.setRefundStatus(refundStatus);
        Long refundTotal = this.customerRefundOrderMapper.queryOrderRefundAmount(query);
        CustomerOrder order = new CustomerOrder();
        order.setBizId(bizId);
        order.setOrderNo(orderNo);
        order.setRefundAmount(refundTotal);
        order.setUpdateTime(new Date());
        this.customerOrderMapper.update((Object)order, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"order_no", (Object)orderNo));
    }

    public RefundOrderInfo getRefundInfoByRefundNum(Long bizId, String refundNum) {
        log.info("get refund number by bizId: {}, refunNum: {}", (Object)bizId, (Object)refundNum);
        if (StringUtils.isBlank((CharSequence)refundNum)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerRefundOrder refundOrder = (CustomerRefundOrder)this.customerRefundOrderMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)refundNum));
        if (refundOrder != null) {
            CustomerOrder order = this.customerOrderMapper.getByOrderNo(bizId, refundOrder.getOrderNo());
            RefundOrderInfo refundOrderInfo = new RefundOrderInfo();
            refundOrderInfo.setRefundNo(refundOrder.getRefundNo());
            refundOrderInfo.setRefundType(refundOrder.getRefundType());
            refundOrderInfo.setOrderNo(refundOrder.getOrderNo());
            refundOrderInfo.setRefundAmount(refundOrder.getRefundAmount());
            refundOrderInfo.setRefundTime(refundOrder.getRefundTime());
            refundOrderInfo.setName(order.getCustomerName());
            refundOrderInfo.setUserId(order.getUserId());
            Map mobileMap = this.ccCustomerNumService.getMobileByCustomerNums(bizId, (Collection)Lists.newArrayList((Object[])new String[]{order.getCustomerNum()}));
            if (MapUtils.isNotEmpty((Map)mobileMap)) {
                refundOrderInfo.setMobile((String)mobileMap.get(order.getCustomerNum()));
            }
            return refundOrderInfo;
        }
        return null;
    }

    public void transfer(RefundOrderReq req) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("transfer bizId: {}, userId: {}, req: {}", new Object[]{req.getBizId(), req.getUserId(), req});
        if (StringUtils.isBlank((CharSequence)req.getRefundOrderNum())) {
            throw new IllegalArgumentException("\u9000\u5355\u552f\u4e00\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerRefundOrder refundOrder = (CustomerRefundOrder)this.customerRefundOrderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"num", (Object)req.getRefundOrderNum()));
        if (refundOrder == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u9000\u6b3e\u5355");
        }
        if (refundOrder.getRefundType().intValue() != RefundTypeEnum.TRANSFER.getValue()) {
            throw new IllegalArgumentException("\u9000\u6b3e\u5355\u4e0d\u662f\u8f6c\u8d26\u7c7b\u578b");
        }
        if (refundOrder.getStatus().intValue() != RefundStatusEnum.FAIL.getValue()) {
            throw new IllegalArgumentException("\u9000\u6b3e\u5355\u8f6c\u8d26\u72b6\u6001\u4e0d\u662f\u5931\u8d25\u4e0d\u9700\u8981\u4fee\u6539\u8f6c\u8d26\u8d26\u53f7");
        }
        this.saveRefundTransferRecord(req.getBizId(), refundOrder.getNum(), req.getUserId(), req);
        this.sendApprovalMsg(refundOrder, null, true);
    }

    private void saveRefundTransferRecord(Long bizId, String refundOrderNum, Long userId, RefundOrderReq req) {
        List transferRecords = this.refundTransferRecordMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"refund_num", (Object)refundOrderNum)).orderByDesc((Object)"id"));
        Date curTime = new Date();
        RefundTransferRecord transferRecord = null;
        log.info("transferRecords: {}, refundOrderNum: {}", (Object)transferRecords, (Object)refundOrderNum);
        if (CollectionUtils.isEmpty((Collection)transferRecords)) {
            transferRecord = new RefundTransferRecord();
            transferRecord.setBizId(bizId);
            transferRecord.setOrderNo(req.getOrderNo());
            transferRecord.setRefundNum(refundOrderNum);
            transferRecord.setAccountName(req.getAccountName());
            transferRecord.setAccount(req.getAccount());
            transferRecord.setBank(req.getBank());
            transferRecord.setTransferNo(req.getTransferNo());
            transferRecord.setAttachments(JacksonUtil.obj2Str((Object)req.getTransferAttachments()));
            transferRecord.setCreateBy(userId);
            transferRecord.setUpdateBy(userId);
            transferRecord.setCreateTime(curTime);
            transferRecord.setUpdateTime(curTime);
            transferRecord.setTransferType(req.getTransferType());
            this.refundTransferRecordMapper.insert((Object)transferRecord);
        } else {
            transferRecord = (RefundTransferRecord)transferRecords.get(0);
            transferRecord.setAccountName(req.getAccountName());
            transferRecord.setAccount(req.getAccount());
            transferRecord.setBank(req.getBank());
            transferRecord.setTransferNo(req.getTransferNo());
            transferRecord.setAttachments(JacksonUtil.obj2Str((Object)req.getTransferAttachments()));
            transferRecord.setUpdateBy(userId);
            transferRecord.setUpdateTime(curTime);
            transferRecord.setTransferType(req.getTransferType());
            this.refundTransferRecordMapper.updateById((Object)transferRecord);
        }
    }

    private CustomerRefundOrder saveRefundOrder(Long bizId, String corpId, Long userId, RefundOrderReq req) {
        CustomerRefundOrder refundOrder = new CustomerRefundOrder();
        refundOrder.setBizId(bizId);
        refundOrder.setNum(this.idGen.getNum());
        refundOrder.setCorpId(corpId);
        refundOrder.setOrderNo(req.getOrderNo());
        refundOrder.setRefundNo(req.getRefundNo());
        if (StringUtils.isBlank((CharSequence)refundOrder.getRefundNo())) {
            refundOrder.setRefundNo(refundOrder.getNum());
        }
        refundOrder.setRefundAmount(req.getRefundAmount());
        refundOrder.setOrderAmount(req.getOrderAmount());
        refundOrder.setOtherAmount(req.getOtherAmount());
        refundOrder.setStatus(Integer.valueOf(RefundStatusEnum.WAIT_REFUND.getValue()));
        if (req.getApprovalType() == 0) {
            refundOrder.setApprovalStatus(Integer.valueOf(ApprovalStatus.APPROVAL_SUCCESS.getValue()));
        } else {
            refundOrder.setApprovalStatus(Integer.valueOf(ApprovalStatus.APPROVAL_DOING.getValue()));
        }
        refundOrder.setRefundType(req.getRefundType());
        refundOrder.setRefundSerialNo(req.getRefundSerialNo());
        refundOrder.setRemark(req.getRemark());
        refundOrder.setReason(req.getReason());
        refundOrder.setAttachments(JacksonUtil.obj2Str((Object)req.getAttachments()));
        refundOrder.setRefundSkus(JacksonUtil.obj2Str((Object)req.getRefundSkus()));
        Date curTime = new Date();
        refundOrder.setCreateTime(curTime);
        refundOrder.setUpdateTime(curTime);
        refundOrder.setCreateBy(userId);
        refundOrder.setUpdateBy(userId);
        this.customerRefundOrderMapper.insert((Object)refundOrder);
        return refundOrder;
    }

    public PageRefundOrderListResp refundOrderList(QueryRefundOrderListReq params) {
        QueryWrapper queryWrapper;
        log.info("refund order list params: {}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getPageDto() != null ? 1 : 0) != 0, (Object)"\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Long bizId = params.getBizId();
        BizTableContext.putBizId((Long)bizId);
        QueryRefundOrderDto queryParams = (QueryRefundOrderDto)BeanUtil.convert((Object)params, QueryRefundOrderDto.class, (String[])new String[0]);
        if (queryParams.getRefundStatus() != null) {
            queryParams.setInnerStatusList(RefundStatusEnum.getQueryStatus((int)queryParams.getRefundStatus()));
        }
        PageDto pageDto = params.getPageDto();
        int total = this.customerRefundOrderMapper.queryOrderCount(queryParams);
        pageDto.setCount(Integer.valueOf(total));
        List customerRefundOrders = this.customerRefundOrderMapper.queryOrderList(queryParams);
        if (CollectionUtils.isEmpty((Collection)customerRefundOrders)) {
            PageRefundOrderListResp resp = new PageRefundOrderListResp();
            resp.setList((List)Lists.newArrayList());
            resp.setPageDto(pageDto);
            return resp;
        }
        List orderNoList = customerRefundOrders.stream().map(it -> it.getOrderNo()).collect(Collectors.toList());
        List refundNumList = customerRefundOrders.stream().map(it -> it.getNum()).collect(Collectors.toList());
        log.info("refundNumList: {}", refundNumList);
        Map<Object, Object> orderNoSkuNameMap = Maps.newHashMap();
        Map<Object, Object> orderNoOrderMap = Maps.newHashMap();
        Set<Object> customerNums = Sets.newHashSet();
        List orderList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(orderNoList)) {
            queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).in((Object)"order_no", orderNoList);
            List skuList = this.orderSkuListMapper.selectList((Wrapper)queryWrapper);
            orderNoSkuNameMap = skuList.stream().collect(Collectors.groupingBy(OrderSkuList::getOrderNo, Collectors.mapping(OrderSkuList::getSkuName, Collectors.toList())));
            QueryWrapper queryWrapper1 = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"is_deleted", (Object)0)).in((Object)"order_no", orderNoList);
            orderList = this.customerOrderMapper.selectList((Wrapper)queryWrapper1);
            customerNums = orderList.stream().map(customerOrder -> customerOrder.getCustomerNum()).collect(Collectors.toSet());
            orderNoOrderMap = orderList.stream().collect(Collectors.toMap(CustomerOrder::getOrderNo, Function.identity(), (key1, key2) -> key2));
        }
        queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).in((Object)"refund_num", refundNumList);
        List refundTransferRecords = this.refundTransferRecordMapper.selectList((Wrapper)queryWrapper);
        Map refundNoTransferRecordMap = refundTransferRecords.stream().collect(Collectors.toMap(RefundTransferRecord::getRefundNum, Function.identity()));
        Map customerNumMobileMap = this.customerMapper.selectMobileByNums(bizId, (Collection)customerNums);
        Map customerNameMap = this.customerDetailMapper.queryCustomerNameMap(bizId, (Collection)customerNums);
        Map<String, String> sourceMap = this.getSource(bizId);
        Set userIdSet = customerRefundOrders.stream().map(it -> it.getCreateBy()).collect(Collectors.toSet());
        for (CustomerOrder customerOrder2 : orderList) {
            if (customerOrder2.getUserId() != null) {
                userIdSet.add(customerOrder2.getUserId());
            }
            userIdSet.add(customerOrder2.getCreateBy());
        }
        List approvalRecords = this.refundApprovalRecordMapper.queryApprovalList(bizId, refundNumList);
        HashMap approvalUserMap = Maps.newHashMap();
        for (RefundApprovalRecord approvalRecord : approvalRecords) {
            if (approvalUserMap.containsKey(approvalRecord.getRefundNum())) continue;
            approvalUserMap.put(approvalRecord.getRefundNum(), approvalRecord.getUserId());
        }
        userIdSet.addAll(approvalUserMap.values());
        log.info("approvalUserMap: {}", (Object)approvalUserMap);
        Map userNameMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(userIdSet)) {
            userNameMap = this.scrmUserService.getNameByIds(userIdSet);
        }
        ArrayList list = Lists.newArrayList();
        for (CustomerRefundOrder customerRefundOrder : customerRefundOrders) {
            RefundStatusEnum outStatus;
            RefundOrderListResp order = new RefundOrderListResp();
            list.add(order);
            CustomerOrder customerOrder3 = orderNoOrderMap.getOrDefault(customerRefundOrder.getOrderNo(), new CustomerOrder());
            order.setId(customerRefundOrder.getNum());
            order.setNum(customerRefundOrder.getNum());
            order.setOrderNo(customerRefundOrder.getOrderNo());
            order.setRefundNo(customerRefundOrder.getRefundNo());
            order.setRefundSerialNo(customerRefundOrder.getRefundSerialNo());
            if (StringUtils.isNotBlank((CharSequence)customerRefundOrder.getRefundSerialNo())) {
                order.setRefundSerialNos(Splitter.on((String)",").splitToList((CharSequence)customerRefundOrder.getRefundSerialNo()));
            }
            order.setOrderTime(customerOrder3.getOrderTime());
            order.setSource(customerOrder3.getSource());
            order.setSourceDesc(sourceMap.get(customerOrder3.getSource()));
            order.setSkuNames((List)orderNoSkuNameMap.get(customerOrder3.getOrderNo()));
            if (CollectionUtils.isEmpty((Collection)order.getSkuNames())) {
                order.setSkuNames((List)Lists.newArrayList((Object[])new String[]{customerOrder3.getSkuName()}));
            }
            order.setRefundAmount(customerRefundOrder.getRefundAmount());
            order.setPaidAmount(Long.valueOf(customerOrder3.getPaidAmount() == null ? 0L : customerOrder3.getPaidAmount()));
            order.setOrderPrice(customerOrder3.getOrderAmount());
            order.setRefundStatus(customerRefundOrder.getStatus());
            if (customerRefundOrder.getStatus() != null && RefundStatusEnum.get((int)customerRefundOrder.getStatus()) != null && (outStatus = RefundStatusEnum.statusEnumMap((int)customerRefundOrder.getStatus())) != null) {
                order.setRefundStatus(Integer.valueOf(outStatus.getValue()));
                order.setRefundStatusDesc(outStatus.getDesc());
            }
            order.setRefundType(customerRefundOrder.getRefundType());
            order.setAuditStatus(customerRefundOrder.getApprovalStatus());
            if (customerRefundOrder.getApprovalStatus() != null && RefundStatusEnum.get((int)customerRefundOrder.getApprovalStatus()) != null) {
                order.setAuditStatusDesc(ApprovalStatus.get((int)customerRefundOrder.getApprovalStatus()).getDesc());
            }
            order.setAuditRemark(customerRefundOrder.getApprovalRemark());
            order.setRefundTime(customerRefundOrder.getRefundTime());
            order.setCustomerMobile((String)customerNumMobileMap.get(customerOrder3.getCustomerNum()));
            order.setCustomerName((String)customerNameMap.get(customerOrder3.getCustomerNum()));
            order.setCreateUser((String)userNameMap.get(customerRefundOrder.getCreateBy()));
            order.setUserName((String)userNameMap.get(customerOrder3.getUserId()));
            order.setCreateTime(customerRefundOrder.getCreateTime());
            order.setCreateBy(customerRefundOrder.getCreateBy());
            order.setRemark(customerRefundOrder.getRemark());
            if (customerRefundOrder.getRefundType() != null && RefundTypeEnum.get((int)customerRefundOrder.getRefundType()) != null) {
                order.setRefundTypeDesc(RefundTypeEnum.get((int)customerRefundOrder.getRefundType()).getDesc());
            } else {
                order.setRefundTypeDesc(customerRefundOrder.getRefundWay());
            }
            order.setReason(customerRefundOrder.getReason());
            if (StringUtils.isNotBlank((CharSequence)customerRefundOrder.getAttachments())) {
                try {
                    order.setAttachments(JacksonUtil.str2List((String)customerRefundOrder.getAttachments(), String.class));
                }
                catch (IOException e) {
                    log.error("setAttachments error", (Throwable)e);
                }
            }
            order.setOrderAmount(customerRefundOrder.getOrderAmount());
            order.setOtherAmount(customerRefundOrder.getOtherAmount());
            order.setRefundFailReason(customerRefundOrder.getRefundFailReason());
            RefundTransferRecord transferRecord = (RefundTransferRecord)refundNoTransferRecordMap.get(customerRefundOrder.getNum());
            if (transferRecord != null && StringUtils.isNotBlank((CharSequence)transferRecord.getAttachments())) {
                try {
                    order.setTransferAttachments(JacksonUtil.str2List((String)transferRecord.getAttachments(), String.class));
                }
                catch (IOException e) {
                    log.error("setTransferAttachments error", (Throwable)e);
                }
                order.setAccountName(transferRecord.getAccountName());
                order.setBank(transferRecord.getBank());
                order.setTransferNo(transferRecord.getTransferNo());
                order.setAccount(transferRecord.getAccount());
            }
            order.setApprovalApply((String)userNameMap.get(customerRefundOrder.getCreateBy()));
            order.setApplyTime(customerRefundOrder.getCreateTime());
            Long approvalUser = (Long)approvalUserMap.get(customerRefundOrder.getNum());
            if (approvalUser == null) continue;
            order.setApprovalUser((String)userNameMap.get(approvalUser));
        }
        PageRefundOrderListResp resp = new PageRefundOrderListResp();
        resp.setList((List)list);
        resp.setPageDto(pageDto);
        BizTableContext.clear();
        return resp;
    }

    public RefundOrderTotalResp refundOrderTotal(QueryRefundOrderListReq params) {
        RefundOrderTotalResp resp = new RefundOrderTotalResp();
        log.info("refundOrderTotal params: {}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Long bizId = params.getBizId();
        BizTableContext.putBizId((Long)bizId);
        QueryRefundOrderDto queryParams = (QueryRefundOrderDto)BeanUtil.convert((Object)params, QueryRefundOrderDto.class, (String[])new String[0]);
        int total = this.customerRefundOrderMapper.queryOrderCount(queryParams);
        Long refundTotal = this.customerRefundOrderMapper.queryOrderRefundAmount(queryParams);
        resp.setOrderTotal(Integer.valueOf(total));
        resp.setRefundTotal(Long.valueOf(refundTotal == null ? 0L : refundTotal));
        Long approvalSuccessTotal = this.customerRefundOrderMapper.queryOrderApprovalSuccessAmount(queryParams);
        Long refundSuccessTotal = this.customerRefundOrderMapper.queryOrderRefundSuccessAmount(queryParams);
        resp.setApprovalSuccessTotal(Long.valueOf(approvalSuccessTotal == null ? 0L : approvalSuccessTotal));
        resp.setRefundSuccessTotal(Long.valueOf(refundSuccessTotal == null ? 0L : refundSuccessTotal));
        BizTableContext.clear();
        return resp;
    }

    public List<RefundOrderListResp> getNeedApprovalRefundOrder(ApprovalReq req) {
        log.info("getNeedApprovalRefundOrder req: {}", (Object)req);
        if (StringUtils.isBlank((CharSequence)req.getWeworkUserNum()) || StringUtils.isBlank((CharSequence)req.getRefundOrderNum())) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String refundOrderNum = req.getRefundOrderNum();
        QueryWrapper refundOrderQuery = (QueryWrapper)new QueryWrapper().eq((Object)"num", (Object)refundOrderNum);
        CustomerRefundOrder refundOrder = (CustomerRefundOrder)this.customerRefundOrderMapper.selectOne((Wrapper)refundOrderQuery);
        if (refundOrder == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u9000\u6b3e\u7533\u8bf7\u5355");
        }
        Long bizId = refundOrder.getBizId();
        UserSimpleInfo userInfo = this.scrmUserService.getUserInfoByWeworkUserNum(bizId, req.getWeworkUserNum());
        if (userInfo == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u5ba1\u6279\u4eba");
        }
        List refundNums = this.refundApprovalRecordMapper.queryWaitApprovalList(refundOrder.getBizId(), userInfo.getId());
        if (CollectionUtils.isEmpty((Collection)refundNums)) {
            return Lists.newArrayList();
        }
        refundOrderQuery = (QueryWrapper)new QueryWrapper().in((Object)"num", (Collection)refundNums);
        List refundOrders = this.customerRefundOrderMapper.selectList((Wrapper)refundOrderQuery);
        if (CollectionUtils.isEmpty((Collection)refundOrders)) {
            return Lists.newArrayList();
        }
        List orderNoList = refundOrders.stream().map(it -> it.getOrderNo()).collect(Collectors.toList());
        Map<Object, Object> orderNoSkuNameMap = Maps.newHashMap();
        Map<Object, Object> orderNoOrderMap = Maps.newHashMap();
        Set<Object> customerNums = Sets.newHashSet();
        List orderList = null;
        if (CollectionUtils.isNotEmpty(orderNoList)) {
            QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).in((Object)"order_no", orderNoList);
            List skuList = this.orderSkuListMapper.selectList((Wrapper)queryWrapper);
            orderNoSkuNameMap = skuList.stream().collect(Collectors.groupingBy(OrderSkuList::getOrderNo, Collectors.mapping(OrderSkuList::getSkuName, Collectors.toList())));
            QueryWrapper queryWrapper1 = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"is_deleted", (Object)0)).in((Object)"order_no", orderNoList);
            orderList = this.customerOrderMapper.selectList((Wrapper)queryWrapper1);
            customerNums = orderList.stream().map(customerOrder -> customerOrder.getCustomerNum()).collect(Collectors.toSet());
            orderNoOrderMap = orderList.stream().collect(Collectors.toMap(CustomerOrder::getOrderNo, Function.identity(), (key1, key2) -> key2));
        }
        Map<String, String> sourceMap = this.getSource(bizId);
        BizTableContext.putBizId((Long)bizId);
        Map customerNumMobileMap = this.customerMapper.selectMobileByNums(bizId, (Collection)customerNums);
        Map customerNameMap = this.customerDetailMapper.queryCustomerNameMap(bizId, (Collection)customerNums);
        BizTableContext.clear();
        Set createUserIds = refundOrders.stream().map(it -> it.getCreateBy()).collect(Collectors.toSet());
        Map userNameMap = this.scrmUserService.getNameByIds(createUserIds);
        ArrayList result = Lists.newArrayList();
        for (CustomerRefundOrder customerRefundOrder : refundOrders) {
            RefundOrderListResp order = new RefundOrderListResp();
            result.add(order);
            CustomerOrder customerOrder2 = orderNoOrderMap.getOrDefault(customerRefundOrder.getOrderNo(), new CustomerOrder());
            order.setId(customerRefundOrder.getNum());
            order.setNum(customerRefundOrder.getNum());
            order.setOrderNo(customerRefundOrder.getOrderNo());
            order.setOrderTime(customerOrder2.getOrderTime());
            order.setSource(customerOrder2.getSource());
            order.setSourceDesc(sourceMap.get(customerOrder2.getSource()));
            order.setSkuNames((List)orderNoSkuNameMap.get(customerOrder2.getOrderNo()));
            if (CollectionUtils.isEmpty((Collection)order.getSkuNames())) {
                order.setSkuNames((List)Lists.newArrayList((Object[])new String[]{customerOrder2.getSkuName()}));
            }
            order.setRefundAmount(customerRefundOrder.getRefundAmount());
            order.setPaidAmount(Long.valueOf(customerOrder2.getPaidAmount() == null ? 0L : customerOrder2.getPaidAmount()));
            order.setRemark(customerRefundOrder.getRemark());
            order.setReason(customerRefundOrder.getReason());
            if (StringUtils.isNotBlank((CharSequence)customerRefundOrder.getAttachments())) {
                try {
                    order.setAttachments(JacksonUtil.str2List((String)customerRefundOrder.getAttachments(), String.class));
                }
                catch (IOException e) {
                    log.error("setAttachments error", (Throwable)e);
                }
            }
            if (customerRefundOrder.getRefundType() != null && RefundTypeEnum.get((int)customerRefundOrder.getRefundType()) != null) {
                order.setRefundTypeDesc(RefundTypeEnum.get((int)customerRefundOrder.getRefundType()).getDesc());
            } else {
                order.setRefundTypeDesc(customerRefundOrder.getRefundWay());
            }
            order.setAuditStatus(customerRefundOrder.getApprovalStatus());
            if (customerRefundOrder.getApprovalStatus() != null && RefundStatusEnum.get((int)customerRefundOrder.getApprovalStatus()) != null) {
                order.setAuditStatusDesc(ApprovalStatus.get((int)customerRefundOrder.getApprovalStatus()).getDesc());
            }
            order.setCustomerMobile((String)customerNumMobileMap.get(customerOrder2.getCustomerNum()));
            order.setCustomerName((String)customerNameMap.get(customerOrder2.getCustomerNum()));
            order.setApprovalApply((String)userNameMap.get(customerRefundOrder.getCreateBy()));
            order.setApplyTime(customerRefundOrder.getCreateTime());
        }
        return result;
    }

    private Map<String, String> getSource(Long bizId) {
        OrderDictionary orderDictionary = (OrderDictionary)this.orderDictionaryMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).orderByDesc((Object)"create_time"));
        Map<Object, Object> sourceMap = Maps.newHashMap();
        if (orderDictionary != null && StringUtils.isNotBlank((CharSequence)orderDictionary.getSources())) {
            try {
                List fieldDtos = JacksonUtil.str2List((String)orderDictionary.getSources(), DynamicFieldDto.class);
                sourceMap = fieldDtos.stream().collect(Collectors.toMap(DynamicFieldDto::getKey, DynamicFieldDto::getName));
            }
            catch (IOException e) {
                log.error("error: ", (Throwable)e);
            }
        }
        for (OrderSource orderSource : OrderSource.values()) {
            sourceMap.put(orderSource.getValue(), orderSource.getDesc());
        }
        sourceMap.put("scrm", "\u5c0f\u5546\u5e97\u8ba2\u5355");
        return sourceMap;
    }

    public void setRefundRecord(RefundOrderReq req) {
        Preconditions.checkArgument((req.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getRefundNo()), (Object)"\u9000\u6b3e\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        CustomerRefundOrder refundOrder = this.customerRefundOrderMapper.queryByRefundNo(req.getBizId(), req.getRefundNo());
        if (req.getRefundFailReason() != null) {
            refundOrder.setRefundFailReason(req.getRefundFailReason());
            this.customerRefundOrderMapper.updateById((Object)refundOrder);
        }
    }
}

