/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.crm.common.service.CrmCustomerService;
import cn.kinyun.crm.common.service.dto.req.CrmCustomerIsAssociateReq;
import cn.kinyun.crm.common.service.dto.resp.CrmCustomerInfoResp;
import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.dto.AppIdOpenIdPair;
import cn.kinyun.customer.center.dal.entity.Customer;
import cn.kinyun.customer.center.dal.entity.CustomerDetail;
import cn.kinyun.customer.center.dal.mapper.CustomerDetailMapper;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dto.UnionIdUpdateMsgDto;
import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.CustomerNumReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.dto.resp.CustomerMobileNumResp;
import cn.kinyun.customer.center.dto.resp.CustomerNumResp;
import cn.kinyun.customer.center.enums.CustomerIdType;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.UnionIdChangedService;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmContactService;
import com.kuaike.scrm.common.service.dto.resp.AppletResp;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.service.dto.resp.OfficialResp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;

@Service
public class CcCustomerNumServiceImpl
implements CcCustomerNumService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerNumServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private CustomerDetailMapper customerDetailMapper;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CcCustomerEventService ccCustomerEventService;
    @Autowired
    private ScrmContactService scrmContactService;
    @Resource
    private CrmCustomerService crmCustomerService;
    @Autowired
    private UnionIdChangedService unionIdChangedService;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Value(value="${kafka.topic.netschool.unionIdUpdate:}")
    private String updateUnionIdTopic;

    public CustomerDetailResp getCustomerDetailByType(Long bizId, String contactId) {
        Customer customerByType = null;
        try {
            customerByType = this.getCustomerByType(bizId, CustomerIdType.WEWORK_CONTACT_ID.getValue(), contactId, null, null);
        }
        catch (Exception e) {
            try {
                customerByType = this.getCustomerByType(bizId, CustomerIdType.WEWORK_CONTACT_ID.getValue(), contactId, null, null);
                log.info("getCustomerByType contactId:{}", (Object)contactId, (Object)e);
            }
            catch (Exception exception) {
                log.info("getCustomerByType contactId \u7b2c\u4e8c\u6b21:{}", (Object)contactId, (Object)e);
            }
        }
        if (Objects.isNull(customerByType)) {
            log.warn("\u901a\u8fc7contactId:{},bizId:{} \u672a\u627e\u5230\u5bf9\u5e94\u7528\u6237\u4fe1\u606f", (Object)contactId, (Object)bizId);
            return null;
        }
        String mobile = null;
        if (Objects.isNull(customerByType.getMainNum())) {
            log.warn("\u7528\u6237\uff1a{},contactId:{},bizId:{} \u6ca1\u6709main num ,\u65e0\u6cd5\u83b7\u53d6\u624b\u673a\u53f7\uff1a", new Object[]{customerByType.getNum(), contactId, bizId});
        } else {
            List mobiles = this.customerMapper.selectMobilesByMainNum(bizId, customerByType.getMainNum());
            if (CollectionUtils.isNotEmpty((Collection)mobiles)) {
                mobile = (String)mobiles.get(0);
            }
        }
        CustomerDetail customerDetail = this.customerDetailMapper.queryCustomerDetail(bizId, customerByType.getNum());
        return this.buildCustomerDetailResp(customerByType, customerDetail, mobile);
    }

    private CustomerDetailResp buildCustomerDetailResp(Customer customer, CustomerDetail customerDetail, String mobile) {
        CustomerDetailResp detailResp = new CustomerDetailResp();
        BeanUtils.copyProperties((Object)customer, (Object)detailResp);
        BeanUtils.copyProperties((Object)customerDetail, (Object)detailResp);
        detailResp.setMobile1(mobile);
        return detailResp;
    }

    public Customer getCustomerByType(Long bizId, int type, String id1, String id2, String unionId) {
        log.info("get customer by type, bizId={}, type={}, id1={}, id2={}, unionId={}", new Object[]{bizId, type, id1, id2, unionId});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id1), (Object)"id1 is blank");
        if (StringUtils.isBlank((CharSequence)id2)) {
            id2 = "";
        }
        if (StringUtils.isBlank((CharSequence)unionId)) {
            unionId = null;
        }
        String moduleType = "";
        if (type == CustomerIdType.WEWORK_CONTACT_ID.getValue()) {
            moduleType = ModuleType.WEWORK_AUTH.getCode();
        } else if (type == CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue()) {
            moduleType = ModuleType.OFFICIAL_ACCOUNT_AUTH.getCode();
        } else if (type == CustomerIdType.MINI_PROGRAM_OPENID.getValue()) {
            moduleType = ModuleType.MINI_PROGRAM_AUTH.getCode();
        } else if (type == CustomerIdType.MOBILE.getValue()) {
            moduleType = ModuleType.ELECTRICITY_ORDER.getCode();
        }
        Customer record = this.customerMapper.getByType(bizId, Integer.valueOf(type), id1, id2);
        if (record == null) {
            record = this.buildCustomer(bizId, type, id1, id2, unionId);
            String mainNum = null;
            String id = null;
            Integer idType = null;
            List list = null;
            if (StringUtils.isNotBlank((CharSequence)unionId) && CollectionUtils.isNotEmpty((Collection)(list = this.customerMapper.selectByUnionId(bizId, unionId, null)))) {
                for (Customer it : list) {
                    if (!StringUtils.isNotBlank((CharSequence)it.getMainNum())) continue;
                    mainNum = it.getMainNum();
                    id = it.getId1();
                    idType = it.getIdType();
                    break;
                }
                if (mainNum != null) {
                    record.setMainNum(mainNum);
                } else {
                    list.sort(Customer::compareTo);
                    mainNum = ((Customer)list.get(0)).getNum();
                    id = ((Customer)list.get(0)).getId1();
                    idType = ((Customer)list.get(0)).getIdType();
                    record.setMainNum(mainNum);
                }
            }
            this.customerMapper.insert((Object)record);
            if (mainNum != null && unionId != null) {
                CustomerEventReq req = new CustomerEventReq();
                req.setBizId(bizId);
                req.setCustomerNum(record.getNum());
                req.setEventType(EventType.BIND_RELATIONS.getCode());
                EventData eventData = new EventData();
                EventModule eventModule = new EventModule();
                eventModule.setType(moduleType);
                if (moduleType.equals(ModuleType.OFFICIAL_ACCOUNT_AUTH.getCode())) {
                    OfficialResp official = this.scrmContactService.official(id1);
                    eventModule.setName(official.getNickName());
                    eventModule.setNum(id1);
                } else if (moduleType.equals(ModuleType.MINI_PROGRAM_AUTH.getCode())) {
                    AppletResp appletResp = this.scrmContactService.miniProgram(id1);
                    eventModule.setName(appletResp.getStoreName());
                    eventModule.setNum(id1);
                }
                eventData.setModule(eventModule);
                eventData.setId1(id1);
                eventData.setId1Type(Integer.valueOf(type));
                eventData.setId2(id);
                eventData.setId2Type(idType);
                req.setEventData(eventData);
                req.setEventTime(new Date());
                log.info("add bindRelation from insert unionId moduleType:{}", (Object)moduleType);
                this.ccCustomerEventService.addBindRelation(req);
                Wrapper updateWrapper = (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"union_id", (Object)unionId);
                this.customerMapper.update((Object)Customer.builder().mainNum(mainNum).updateTime(new Date()).build(), updateWrapper);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    return record;
                }
                String mobile = this.customerMapper.selectMobileByMainNum(bizId, mainNum);
                if (StringUtils.isBlank((CharSequence)mobile)) {
                    return record;
                }
                Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.MOBILE.getValue()), mobile, "");
                if (customer == null) {
                    return record;
                }
                Set types = list.stream().map(Customer::getIdType).collect(Collectors.toSet());
                types.add(type);
                if (types.contains(CustomerIdType.WEWORK_CONTACT_ID.getValue())) {
                    this.touchSyncIsAssociate(bizId, customer.getNum(), CustomerIdType.WEWORK_CONTACT_ID.getValue());
                }
                if (types.contains(CustomerIdType.MINI_PROGRAM_OPENID.getValue())) {
                    this.touchSyncIsAssociate(bizId, customer.getNum(), CustomerIdType.MINI_PROGRAM_OPENID.getValue());
                }
                if (types.contains(CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue())) {
                    this.touchSyncIsAssociate(bizId, customer.getNum(), CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue());
                }
            }
            CustomerDetail detail = new CustomerDetail();
            detail.setNum(this.idGen.getNum());
            detail.setCustomerNum(record.getNum());
            detail.setBizId(record.getBizId());
            detail.setCorpId(record.getCorpId());
            detail.setCreateTime(new Date());
            detail.setUpdateTime(new Date());
            detail.setCreateBy(Long.valueOf(-1L));
            detail.setUpdateBy(Long.valueOf(-1L));
            this.customerDetailMapper.insert((Object)detail);
        } else if (StringUtils.isNotBlank((CharSequence)unionId) && !unionId.equals(record.getUnionId())) {
            this.unionIdChangedService.asyncRecord(record.getUnionId(), unionId);
            record.setUnionId(unionId);
            String mainNum = null;
            String id = null;
            Integer idType = null;
            List list = null;
            if (StringUtils.isBlank((CharSequence)record.getMainNum()) && CollectionUtils.isNotEmpty((Collection)(list = this.customerMapper.selectByUnionId(bizId, unionId, null)))) {
                for (Customer it : list) {
                    if (!StringUtils.isNotBlank((CharSequence)it.getMainNum())) continue;
                    mainNum = it.getMainNum();
                    id = it.getId1();
                    idType = it.getIdType();
                    break;
                }
                if (mainNum != null) {
                    record.setMainNum(mainNum);
                } else {
                    list.sort(Customer::compareTo);
                    mainNum = ((Customer)list.get(0)).getNum();
                    id = ((Customer)list.get(0)).getId1();
                    idType = ((Customer)list.get(0)).getIdType();
                    record.setMainNum(mainNum);
                }
            }
            this.customerMapper.updateById((Object)record);
            if (mainNum != null && unionId != null) {
                CustomerEventReq req = new CustomerEventReq();
                req.setBizId(bizId);
                req.setCustomerNum(record.getNum());
                req.setEventType(EventType.BIND_RELATIONS.getCode());
                EventData eventData = new EventData();
                EventModule eventModule = new EventModule();
                eventModule.setType(moduleType);
                if (moduleType.equals(ModuleType.OFFICIAL_ACCOUNT_AUTH.getCode())) {
                    OfficialResp official = this.scrmContactService.official(id1);
                    eventModule.setName(official.getNickName());
                    eventModule.setNum(id1);
                } else if (moduleType.equals(ModuleType.MINI_PROGRAM_AUTH.getCode())) {
                    AppletResp appletResp = this.scrmContactService.miniProgram(id1);
                    eventModule.setName(appletResp.getStoreName());
                    eventModule.setNum(id1);
                }
                eventData.setModule(eventModule);
                eventData.setId1(id1);
                eventData.setId1Type(Integer.valueOf(type));
                eventData.setId2(id);
                eventData.setId2Type(idType);
                req.setEventData(eventData);
                req.setEventTime(new Date());
                log.info("add bindRelation from update unionId moduleType:{} ", (Object)moduleType);
                this.ccCustomerEventService.addBindRelation(req);
                Wrapper updateWrapper = (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"union_id", (Object)unionId);
                this.customerMapper.update((Object)Customer.builder().mainNum(mainNum).updateTime(new Date()).build(), updateWrapper);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    return record;
                }
                String mobile = this.customerMapper.selectMobileByMainNum(bizId, mainNum);
                if (StringUtils.isBlank((CharSequence)mobile)) {
                    return record;
                }
                Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.MOBILE.getValue()), mobile, "");
                if (customer == null) {
                    return record;
                }
                Set types = list.stream().map(Customer::getIdType).collect(Collectors.toSet());
                types.add(type);
                if (types.contains(CustomerIdType.WEWORK_CONTACT_ID.getValue())) {
                    this.touchSyncIsAssociate(bizId, customer.getNum(), CustomerIdType.WEWORK_CONTACT_ID.getValue());
                }
                if (types.contains(CustomerIdType.MINI_PROGRAM_OPENID.getValue())) {
                    this.touchSyncIsAssociate(bizId, customer.getNum(), CustomerIdType.MINI_PROGRAM_OPENID.getValue());
                }
                if (types.contains(CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue())) {
                    this.touchSyncIsAssociate(bizId, customer.getNum(), CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue());
                }
            }
        }
        return record;
    }

    public String getCustomerNumByType(Long bizId, int type, String id1, String id2, String unionId) {
        log.info("get customer num by type, bizId={}, type={}, id1={}, id2={}, unionId={}", new Object[]{bizId, type, id1, id2, unionId});
        Customer record = null;
        try {
            try {
                record = this.getCustomerByType(bizId, type, id1, id2, unionId);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a\u91cd\u8bd5\u4e00\u6b21\uff0cid1:{}", (Object)id1, (Object)e);
                record = this.getCustomerByType(bizId, type, id1, id2, unionId);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1aid1:{}", (Object)id1, (Object)e);
        }
        return Objects.nonNull(record) ? record.getNum() : null;
    }

    public Map<String, String> batchGetCustomerNumByMobile(Long bizId, Collection<String> mobiles) {
        log.info("batchGetCustomerNumByMobile, bizId:{}, mobiles:{}", (Object)bizId, mobiles);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(mobiles), (Object)"mobiles is null");
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
        if (bizSimpleDto == null) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        String corpId = bizSimpleDto.getCorpId();
        Map existMap = this.customerMapper.selectCustomerNumByMobiles(bizId, mobiles);
        HashMap map = Maps.newHashMap();
        map.putAll(existMap);
        ArrayList addList = Lists.newArrayListWithCapacity((int)mobiles.size());
        Date now = new Date();
        for (String mobile : mobiles) {
            if (StringUtils.isBlank((CharSequence)mobile) || map.containsKey(mobile)) {
                log.warn("ignore duplicate mobile:{}", (Object)mobile);
                continue;
            }
            String customerNum = this.idGen.getNum();
            map.put(mobile, customerNum);
            Customer customer = new Customer();
            customer.setBizId(bizId);
            customer.setCorpId(corpId);
            customer.setNum(customerNum);
            customer.setIdType(Integer.valueOf(CustomerIdType.MOBILE.getValue()));
            customer.setId1(mobile);
            customer.setId2("");
            customer.setUnionId(null);
            customer.setCreateBy(Long.valueOf(-1L));
            customer.setUpdateBy(Long.valueOf(-1L));
            customer.setCreateTime(now);
            customer.setUpdateTime(now);
            addList.add(customer);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            log.info("\u6279\u91cf\u4fdd\u5b58customerNum:{}", (Object)addList.size());
            this.customerMapper.batchInsert((Collection)addList);
        }
        return map;
    }

    public Map<String, String> batchGetContactCustomerNumByMobile(Long bizId, Collection<String> mobiles) {
        log.info("getCustomerNumByMobile, bizId:{}, mobile:{}", (Object)bizId, (Object)JSON.toJSONString(mobiles));
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"biz is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(mobiles), (Object)"mobile is null");
        Map contactMobiles = null;
        try {
            contactMobiles = this.customerMapper.batchGetContactCustomerNumByMobile(bizId, mobiles);
        }
        catch (Exception e) {
            log.error("batchGetContactCustomerNumByMobile:{}", (Object)contactMobiles, (Object)e);
        }
        return contactMobiles;
    }

    public Map<String, List<String>> batchGetContactIdByMobile(Long bizId, Collection<String> mobiles) {
        log.info("getCustomerNumByMobile, bizId:{}, mobile:{}", (Object)bizId, (Object)JSON.toJSONString(mobiles));
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"biz is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(mobiles), (Object)"mobile is null");
        Map contactMobiles = null;
        try {
            contactMobiles = this.customerMapper.batchGetContactIdByMobile(bizId, mobiles);
        }
        catch (Exception e) {
            log.error("batchGetContactCustomerNumByMobile:{}", (Object)contactMobiles, (Object)e);
        }
        return contactMobiles;
    }

    public String getCustomerNumByMobile(Long bizId, String mobile) {
        log.info("getCustomerNumByMobile, bizId:{}, mobile:{}", (Object)bizId, (Object)mobile);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)mobile), (Object)"mobile is null");
        return this.getCustomerNumByType(bizId, CustomerIdType.MOBILE.getValue(), mobile, null, null);
    }

    public String getContactCustomerNumByMobile(Long bizId, String mobile) {
        log.info("getContactCustomerNumByMobile, bizId:{}, mobile:{}", (Object)bizId, (Object)mobile);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)mobile), (Object)"mobile is null");
        Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.MOBILE.getValue()), mobile, null);
        log.info("getContactCustomerNumByMobile, bizId:{}, record:{}", (Object)bizId, (Object)customer);
        if (customer == null) {
            return "";
        }
        String weworkContactId = this.getWeworkContactId(bizId, customer.getNum());
        log.info("getContactCustomerNumByMobile, bizId:{}, weworkContactId:{}", (Object)bizId, (Object)weworkContactId);
        if (StringUtils.isBlank((CharSequence)weworkContactId)) {
            return "";
        }
        String customerNumByWeworkContactId = this.getCustomerNumByWeworkContactId(bizId, weworkContactId, null);
        log.info("getContactCustomerNumByMobile, bizId:{}, customerNumByWeworkContactId:{}", (Object)bizId, (Object)customerNumByWeworkContactId);
        return customerNumByWeworkContactId;
    }

    public String getCustomerNumByWeworkContactId(Long bizId, String contactId, String unionId) {
        log.info("getCustomerNumByWeworkContactId, bizId:{}, contactId:{}, unionId:{}", new Object[]{bizId, contactId, unionId});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)contactId), (Object)"contactId is null");
        return this.getCustomerNumByType(bizId, CustomerIdType.WEWORK_CONTACT_ID.getValue(), contactId, null, unionId);
    }

    public String getCustomerNumByOfficialFans(Long bizId, String appId, String openId, String unionId) {
        log.info("getCustomerNumByOfficialFans, bizId:{}, appId:{}, openId:{}, unionId:{}", new Object[]{bizId, appId, openId, unionId});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)openId), (Object)"openId is null");
        return this.getCustomerNumByType(bizId, CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue(), appId, openId, unionId);
    }

    public String getCustomerNumByMiniProgram(Long bizId, String appId, String openId, String unionId) {
        log.info("getCustomerNumByMiniProgram, bizId:{}, appId:{}, openId:{}, unionId:{}", new Object[]{bizId, appId, openId, unionId});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)openId), (Object)"openId is null");
        return this.getCustomerNumByType(bizId, CustomerIdType.MINI_PROGRAM_OPENID.getValue(), appId, openId, unionId);
    }

    public String getCustomerNumByH5Cookie(Long bizId, String cookie) {
        log.info("getCustomerNumByH5Cookie, bizId:{}, cookie:{}", (Object)bizId, (Object)cookie);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)cookie), (Object)"cookie is null");
        return this.getCustomerNumByType(bizId, CustomerIdType.H5_COOKIE.getValue(), cookie, null, null);
    }

    public String getCustomerNumByWeworkOpenId(Long bizId, String openId) {
        log.info("getCustomerNumByWeworkOpenId, bizId:{}, cookie:{}", (Object)bizId, (Object)openId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)openId), (Object)"openId is null");
        return this.getCustomerNumByType(bizId, CustomerIdType.WEWORK_CONTACT_OPEN_ID.getValue(), openId, null, null);
    }

    public String getWeworkContactId(Long bizId, String customerNum) {
        log.info("getWeworkContactId, bizId:{}, customerNum: {}", (Object)bizId, (Object)customerNum);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum is null");
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((customer != null ? 1 : 0) != 0, (Object)"Invalid customer num");
        if (customer.getIdType() == 0) {
            return customer.getId1();
        }
        String contactId = "";
        String mainNum = customer.getMainNum();
        if (StringUtils.isNotBlank((CharSequence)mainNum)) {
            List contactIds = this.customerMapper.selectContactIdByMainNum(bizId, mainNum);
            if (contactIds.size() > 1) {
                log.info("getWeworkContactId get rather than one contactIds: {}, by mainNum: {}", (Object)contactIds, (Object)customer.getMainNum());
            }
            if (CollectionUtils.isNotEmpty((Collection)contactIds)) {
                contactId = (String)contactIds.get(0);
            }
        }
        return contactId;
    }

    public Map<String, String> getWeworkContactId(Long bizId, Collection<String> customerNums) {
        log.info("getWeworkContactId, bizId:{}, customerNums: {}", (Object)bizId, customerNums);
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(customerNums)) {
            return result;
        }
        List customers = this.customerMapper.getByNums(bizId, customerNums);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)customers), (Object)"Invalid customer num");
        for (Customer customer : customers) {
            if (customer.getIdType().intValue() == CustomerIdType.WEWORK_CONTACT_ID.getValue()) {
                result.put(customer.getNum(), customer.getId1());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)customer.getMainNum())) {
                String contactId = "";
                List contactIds = this.customerMapper.selectContactIdByMainNum(bizId, customer.getMainNum());
                if (contactIds.size() > 1) {
                    log.info("getWeworkContactId get rather than one contactIds: {}, by mainNum: {}", (Object)contactIds, (Object)customer.getMainNum());
                }
                if (CollectionUtils.isNotEmpty((Collection)contactIds)) {
                    contactId = (String)contactIds.get(0);
                }
                result.put(customer.getNum(), contactId);
                if (StringUtils.isNotBlank((CharSequence)contactId)) continue;
            }
            log.info("getWeworkContactId has no contactId, bizId:{}, customerNum: {}", (Object)bizId, (Object)customer.getNum());
            result.put(customer.getNum(), "");
        }
        return result;
    }

    public Map<String, String> getOfficialAppId(Long bizId, Collection<String> customerNums) {
        log.info("getOfficialAppId, bizId:{}, customerNums: {}", (Object)bizId, customerNums);
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(customerNums)) {
            return result;
        }
        List customers = this.customerMapper.getByNums(bizId, customerNums);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)customers), (Object)"Invalid customer num");
        for (Customer customer : customers) {
            List officialAppId;
            if (customer.getIdType().intValue() == CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue()) {
                result.put(customer.getNum(), customer.getId1());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)customer.getMainNum()) && CollectionUtils.isNotEmpty((Collection)(officialAppId = this.customerMapper.selectId1ByMainNum(bizId, customer.getMainNum(), Integer.valueOf(CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue()))))) {
                result.put(customer.getNum(), officialAppId.get(0));
                continue;
            }
            log.info("getOfficialAppId has no officialAppId, bizId:{}, customerNum: {}", (Object)bizId, (Object)customer.getNum());
            result.put(customer.getNum(), "");
        }
        return result;
    }

    public Map<String, String> getMiniAppId(Long bizId, Collection<String> customerNums) {
        log.info("getMiniAppId, bizId:{}, customerNums: {}", (Object)bizId, customerNums);
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(customerNums)) {
            return result;
        }
        List customers = this.customerMapper.getByNums(bizId, customerNums);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)customers), (Object)"Invalid customer num");
        for (Customer customer : customers) {
            List miniAppId;
            if (customer.getIdType().intValue() == CustomerIdType.MINI_PROGRAM_OPENID.getValue()) {
                result.put(customer.getNum(), customer.getId1());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)customer.getMainNum()) && CollectionUtils.isNotEmpty((Collection)(miniAppId = this.customerMapper.selectId1ByMainNum(bizId, customer.getMainNum(), Integer.valueOf(CustomerIdType.MINI_PROGRAM_OPENID.getValue()))))) {
                result.put(customer.getNum(), miniAppId.get(0));
                continue;
            }
            log.info("getMiniAppId has no miniAppId, bizId:{}, customerNum: {}", (Object)bizId, (Object)customer.getNum());
            result.put(customer.getNum(), "");
        }
        return result;
    }

    public List<String> getMiniAppId(Long bizId, String customerNum) {
        log.info("getMiniAppId, bizId:{}, customerNum: {}", (Object)bizId, (Object)customerNum);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum is null");
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((customer != null ? 1 : 0) != 0, (Object)"Invalid customer num");
        if (customer.getIdType().intValue() == CustomerIdType.MINI_PROGRAM_OPENID.getValue()) {
            return Lists.newArrayList((Object[])new String[]{customer.getId1()});
        }
        List miniAppId = Lists.newArrayList();
        String mainNum = customer.getMainNum();
        if (StringUtils.isNotBlank((CharSequence)mainNum)) {
            miniAppId = this.customerMapper.selectId1ByMainNum(bizId, mainNum, Integer.valueOf(CustomerIdType.MINI_PROGRAM_OPENID.getValue()));
        }
        return miniAppId;
    }

    public List<String> getOfficialAppId(Long bizId, String customerNum) {
        log.info("getOfficialAppId, bizId:{}, customerNum: {}", (Object)bizId, (Object)customerNum);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum is null");
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((customer != null ? 1 : 0) != 0, (Object)"Invalid customer num");
        if (customer.getIdType().intValue() == CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue()) {
            return Lists.newArrayList((Object[])new String[]{customer.getId1()});
        }
        List officialAppId = Lists.newArrayList();
        String mainNum = customer.getMainNum();
        if (StringUtils.isNotBlank((CharSequence)mainNum)) {
            officialAppId = this.customerMapper.selectId1ByMainNum(bizId, mainNum, Integer.valueOf(CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue()));
        }
        return officialAppId;
    }

    public List<String> getUnionIds(Long bizId, String customerNum) {
        log.info("getUnionId, bizId:{}, customerNum: {}", (Object)bizId, (Object)customerNum);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)customerNum), (Object)"customerNum is null");
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((customer != null ? 1 : 0) != 0, (Object)"Invalid customer num");
        String mainNum = customer.getMainNum();
        if (StringUtils.isBlank((CharSequence)mainNum)) {
            if (StringUtils.isNotBlank((CharSequence)customer.getUnionId())) {
                return Lists.newArrayList((Object[])new String[]{customer.getUnionId()});
            }
            return Collections.emptyList();
        }
        List unionIds = this.customerMapper.selectUnionIdsByMainNum(bizId, mainNum);
        log.info("getUnionIds, bizId:{}, mainNum: {}, unionIds: {}", new Object[]{bizId, mainNum, unionIds});
        return unionIds;
    }

    public Map<String, List<String>> getUnionIds(Long bizId, Collection<String> customerNums) {
        log.info("getUnionIds, bizId:{}, customerNums: {}", (Object)bizId, customerNums);
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(customerNums)) {
            return result;
        }
        List customers = this.customerMapper.getByNums(bizId, customerNums);
        log.info("getUnionIds, bizId:{}, customers: {}", (Object)bizId, (Object)customers);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)customers), (Object)"Invalid customer num");
        for (Customer customer : customers) {
            List unionIds;
            if (StringUtils.isBlank((CharSequence)customer.getMainNum())) {
                if (!StringUtils.isNotBlank((CharSequence)customer.getUnionId())) continue;
                unionIds = Lists.newArrayList((Object[])new String[]{customer.getUnionId()});
            } else {
                unionIds = this.customerMapper.selectUnionIdsByMainNum(bizId, customer.getMainNum());
            }
            log.info("getUnionIds, bizId:{}, unionIds: {}", (Object)bizId, (Object)unionIds);
            result.put(customer.getNum(), unionIds);
        }
        return result;
    }

    public List<String> getMobileByUnionId(Long bizId, String unionId, Integer idType) {
        log.info("getMobileByUnionId, bizId:{}, customerNum: {}, idType: {}", new Object[]{bizId, unionId, idType});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)unionId), (Object)"unionId is null");
        List list = this.customerMapper.selectByUnionId(bizId, unionId, idType);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        Customer customer = (Customer)list.get(0);
        String mainNum = customer.getMainNum();
        if (StringUtils.isBlank((CharSequence)mainNum)) {
            return Collections.emptyList();
        }
        return this.customerMapper.selectMobilesByMainNum(bizId, mainNum);
    }

    public List<String> getCustomerNumsByType(Long bizId, int type, String id1, String id2, String unionId) {
        Customer customer;
        log.info("get customer nums by type, bizId={}, type={}, id1={}, id2={}, unionId={}", new Object[]{bizId, type, id1, id2, unionId});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id1), (Object)"id1 is blank");
        if (StringUtils.isBlank((CharSequence)id2)) {
            id2 = "";
        }
        if (StringUtils.isBlank((CharSequence)unionId)) {
            unionId = null;
        }
        if ((customer = this.getCustomerByType(bizId, type, id1, id2, unionId)) != null) {
            if (StringUtils.isNotBlank((CharSequence)customer.getMainNum())) {
                return this.customerMapper.selectNumByMainNum(bizId, customer.getMainNum());
            }
            return Collections.singletonList(customer.getNum());
        }
        return Collections.emptyList();
    }

    public List<String> getCustomerNumsByMobile(Long bizId, String mobile) {
        return this.getCustomerNumsByType(bizId, CustomerIdType.MOBILE.getValue(), mobile, null, null);
    }

    public List<String> getCustomerNumsByWeworkContactId(Long bizId, String contactId, String unionId) {
        return this.getCustomerNumsByType(bizId, CustomerIdType.WEWORK_CONTACT_ID.getValue(), contactId, null, unionId);
    }

    public Map<String, String> butchGetCustomerNumByContactId(Long bizId, Collection<String> contactId) {
        if (CollectionUtils.isEmpty(contactId)) {
            return Maps.newHashMap();
        }
        return this.customerMapper.selectCustomerNumByContactIds(bizId, contactId);
    }

    public List<String> getCustomerNumsByOfficialFans(Long bizId, String appId, String openId, String unionId) {
        return this.getCustomerNumsByType(bizId, CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue(), appId, openId, unionId);
    }

    public List<String> getCustomerNumsByMiniProgram(Long bizId, String appId, String openId, String unionId) {
        return this.getCustomerNumsByType(bizId, CustomerIdType.MINI_PROGRAM_OPENID.getValue(), appId, openId, unionId);
    }

    public List<String> getCustomerNumsByH5Cookie(Long bizId, String cookie) {
        return this.getCustomerNumsByType(bizId, CustomerIdType.H5_COOKIE.getValue(), cookie, null, null);
    }

    public List<String> getCustomerNumsByWeworkOpenId(Long bizId, String openId) {
        return this.getCustomerNumsByType(bizId, CustomerIdType.WEWORK_CONTACT_OPEN_ID.getValue(), openId, null, null);
    }

    public boolean bindWeworkContactAndMobile(Long bizId, String contactId, String mobile, String moduleType) {
        log.info("bindWeworkContactAndMobile, bizId={}, contactId={}, mobile={}", new Object[]{bizId, contactId, mobile});
        Customer record1 = this.getCustomerByType(bizId, CustomerIdType.WEWORK_CONTACT_ID.getValue(), contactId, "", "");
        Customer record2 = this.getCustomerByType(bizId, CustomerIdType.MOBILE.getValue(), mobile, "", "");
        if (record1 == null || record2 == null) {
            return false;
        }
        this.setMainNum(record1, record2);
        if (StringUtils.isNotBlank((CharSequence)record1.getNum()) && StringUtils.isNotBlank((CharSequence)record1.getMainNum()) && !Objects.equals(record1.getNum(), record1.getMainNum())) {
            this.customerMapper.updateMainNum(bizId, record1.getMainNum(), record1.getNum());
            this.mergeCustomerDetail(bizId, record1.getMainNum(), record1.getNum());
        }
        if (StringUtils.isNotBlank((CharSequence)moduleType)) {
            CustomerEventReq req = new CustomerEventReq();
            req.setBizId(bizId);
            req.setCustomerNum(record1.getMainNum());
            req.setEventType(EventType.BIND_RELATIONS.getCode());
            EventData eventData = new EventData();
            EventModule eventModule = new EventModule();
            eventModule.setType(moduleType);
            eventData.setModule(eventModule);
            eventData.setId1(record1.getId1());
            eventData.setId1Type(Integer.valueOf(CustomerIdType.WEWORK_CONTACT_ID.getValue()));
            eventData.setId2(record2.getId1());
            eventData.setId2Type(Integer.valueOf(CustomerIdType.MOBILE.getValue()));
            req.setEventData(eventData);
            req.setEventTime(new Date());
            this.ccCustomerEventService.addBindRelation(req);
        }
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.WEWORK_CONTACT_ID.getValue());
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.MINI_PROGRAM_OPENID.getValue());
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue());
        return true;
    }

    public void touchSyncIsAssociate(Long bizId, String customerNum, Integer type) {
        Integer isAssociate;
        Object id1;
        log.info("touchSyncIsAssociate, bizId={}, customerNum={}, type={}", new Object[]{bizId, customerNum, type});
        if (StringUtils.isBlank((CharSequence)customerNum) || type == null) {
            return;
        }
        List<String> contactId = null;
        if (type.intValue() == CustomerIdType.WEWORK_CONTACT_ID.getValue()) {
            id1 = this.getWeworkContactId(bizId, customerNum);
            isAssociate = StringUtils.isBlank((CharSequence)id1) ? 0 : 1;
            contactId = id1;
        } else {
            isAssociate = type.intValue() == CustomerIdType.MINI_PROGRAM_OPENID.getValue() ? Integer.valueOf(CollectionUtils.isEmpty(id1 = this.getMiniAppId(bizId, customerNum)) ? 0 : 1) : Integer.valueOf(CollectionUtils.isEmpty(id1 = this.getOfficialAppId(bizId, customerNum)) ? 0 : 1);
        }
        CrmCustomerIsAssociateReq crmCustomerIsAssociateReq = new CrmCustomerIsAssociateReq();
        crmCustomerIsAssociateReq.setBizId(bizId);
        crmCustomerIsAssociateReq.setContactId(contactId);
        crmCustomerIsAssociateReq.setCustomerNum(customerNum);
        crmCustomerIsAssociateReq.setIsAssociate(isAssociate);
        if (type.intValue() == CustomerIdType.WEWORK_CONTACT_ID.getValue()) {
            this.crmCustomerService.syncIsAssociateWework(crmCustomerIsAssociateReq);
        } else if (type.intValue() == CustomerIdType.MINI_PROGRAM_OPENID.getValue()) {
            this.crmCustomerService.syncIsAssociateMini(crmCustomerIsAssociateReq);
        } else {
            this.crmCustomerService.syncIsAssociateOfficial(crmCustomerIsAssociateReq);
        }
        List<String> unionIds = this.getUnionIds(bizId, customerNum);
        if (CollectionUtils.isEmpty(unionIds)) {
            log.info("unionIds is empty");
            return;
        }
        Set<String> mobiles = this.getMobilesByCustomerNum(bizId, customerNum);
        if (CollectionUtils.isEmpty(mobiles) && mobiles.size() != 1) {
            log.info("mobiles is empty");
            return;
        }
        String mobile = (String)Lists.newArrayList(mobiles).get(0);
        CrmCustomerInfoResp infoResp = this.crmCustomerService.getByMobile(bizId, mobile);
        if (infoResp == null) {
            log.info("inforesp is null, mobile: {}", (Object)mobile);
            return;
        }
        String userId = infoResp.getNetSchoolUserId();
        try {
            UnionIdUpdateMsgDto msgDto = new UnionIdUpdateMsgDto();
            msgDto.setBizId(bizId);
            msgDto.setCustomerNum(customerNum);
            msgDto.setUserId(userId);
            msgDto.setUnionId(unionIds.get(0));
            this.kafkaTemplate.send(this.updateUnionIdTopic, (Object)customerNum, (Object)JacksonUtil.obj2Str((Object)msgDto));
        }
        catch (Exception e) {
            log.error("send update unionId msg error: ", (Throwable)e);
        }
    }

    private void mergeCustomerDetail(Long bizId, String oldNum, String newNum) {
        CustomerDetail oldDetail = (CustomerDetail)this.customerDetailMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"customer_num", (Object)oldNum));
        if (oldDetail == null) {
            log.warn("customer_detail not found, bizId={}, customer_num={}", (Object)bizId, (Object)oldNum);
            return;
        }
        CustomerDetail newDetail = (CustomerDetail)this.customerDetailMapper.selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).eq((Object)"customer_num", (Object)newNum));
        if (newDetail == null) {
            newDetail = new CustomerDetail();
            BeanUtils.copyProperties((Object)oldDetail, (Object)newDetail, (String[])new String[]{"id", "num", "cutomerNum", "createBy", "createTime", "updateBy", "updateTime"});
            newDetail.setNum(this.idGen.getNum());
            newDetail.setCustomerNum(newNum);
            newDetail.setCreateBy(Long.valueOf(-1L));
            newDetail.setCreateTime(new Date());
            newDetail.setUpdateBy(Long.valueOf(-1L));
            newDetail.setUpdateTime(new Date());
            this.customerDetailMapper.insert((Object)newDetail);
        }
    }

    public boolean bindMiniProgramAndMobile(Long bizId, String appId, String openId, String mobile) {
        Customer record1 = this.getCustomerByType(bizId, CustomerIdType.MINI_PROGRAM_OPENID.getValue(), appId, openId, "");
        Customer record2 = this.getCustomerByType(bizId, CustomerIdType.MOBILE.getValue(), mobile, "", "");
        if (record2 == null || record1 == null) {
            return false;
        }
        this.setMainNum(record1, record2);
        if (StringUtils.isNotBlank((CharSequence)record1.getNum()) && StringUtils.isNotBlank((CharSequence)record1.getMainNum()) && !Objects.equals(record1.getNum(), record1.getMainNum())) {
            this.customerMapper.updateMainNum(bizId, record1.getMainNum(), record1.getNum());
            this.mergeCustomerDetails(record1, record2, record1.getNum());
        }
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.WEWORK_CONTACT_ID.getValue());
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.MINI_PROGRAM_OPENID.getValue());
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue());
        return true;
    }

    public boolean bindOfficialAccountAndMobile(Long bizId, String appId, String openId, String mobile, String unionId) {
        log.info("bindOfficialAccountAndMobile bizId:{} appId:{} openId:{} mobile:{}", new Object[]{bizId, appId, openId, mobile});
        Customer record1 = this.getCustomerByType(bizId, CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue(), appId, openId, unionId);
        Customer record2 = this.getCustomerByType(bizId, CustomerIdType.MOBILE.getValue(), mobile, "", "");
        if (record2 == null || record1 == null) {
            return false;
        }
        this.setMainNum(record1, record2);
        if (StringUtils.isNotBlank((CharSequence)record1.getNum()) && StringUtils.isNotBlank((CharSequence)record1.getMainNum()) && !Objects.equals(record1.getNum(), record1.getMainNum())) {
            log.info("bindOfficialAccountAndMobile,updateMainNum,bizId:{},r1 mainNum,r1 num:{}", new Object[]{bizId, record1.getMainNum(), record1.getNum()});
            this.customerMapper.updateMainNum(bizId, record1.getMainNum(), record1.getNum());
            this.mergeCustomerDetails(record1, record2, record1.getNum());
        }
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.WEWORK_CONTACT_ID.getValue());
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.MINI_PROGRAM_OPENID.getValue());
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue());
        return true;
    }

    public boolean bindAppletAccountAndMobile(Long bizId, String appId, String openId, String mobile, String unionId) {
        log.info("bindAppletAccountAndMobile,bizId:{},appId:{},openId:{},mobile:{},unionId:{}", new Object[]{bizId, appId, openId, mobile, unionId});
        Customer record1 = this.getCustomerByType(bizId, CustomerIdType.MINI_PROGRAM_OPENID.getValue(), appId, openId, unionId);
        Customer record2 = this.getCustomerByType(bizId, CustomerIdType.MOBILE.getValue(), mobile, "", "");
        if (record2 == null || record1 == null) {
            return false;
        }
        this.setMainNum(record1, record2);
        if (StringUtils.isNotBlank((CharSequence)record1.getNum()) && StringUtils.isNotBlank((CharSequence)record1.getMainNum()) && !Objects.equals(record1.getNum(), record1.getMainNum())) {
            log.info("bindAppletAccountAndMobile,updateMainNum,bizId:{},r1 mainNum,r1 num:{}", new Object[]{bizId, record1.getMainNum(), record1.getNum()});
            this.customerMapper.updateMainNum(bizId, record1.getMainNum(), record1.getNum());
            this.mergeCustomerDetails(record1, record2, record1.getNum());
        }
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.WEWORK_CONTACT_ID.getValue());
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.MINI_PROGRAM_OPENID.getValue());
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue());
        return true;
    }

    private boolean mainNumIsWechatSubject(Long bizId, String mainNum) {
        log.info("mainNumIsWechatSubject,bizId:{},mainNum:{}", (Object)bizId, (Object)mainNum);
        if (StringUtils.isBlank((CharSequence)mainNum)) {
            return false;
        }
        Customer customer = this.customerMapper.getByNum(bizId, mainNum);
        log.info("mainNumIsWechatSubject,bizId:{},mainNum:{},customer:{}", new Object[]{bizId, mainNum, customer});
        return CustomerIdType.WEWORK_CONTACT_ID.getValue() == customer.getIdType().intValue() || CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue() == customer.getIdType().intValue();
    }

    private void setMainNum(Customer high, Customer low) {
        log.info("set main num:{}, {}", (Object)high.getNum(), (Object)low.getNum());
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{high.getMainNum(), low.getMainNum()})) {
            high.setMainNum(high.getNum());
            high.setUpdateTime(new Date());
            low.setMainNum(high.getNum());
            low.setUpdateTime(new Date());
            this.customerMapper.updateById((Object)high);
            this.customerMapper.updateById((Object)low);
            this.mergeCustomerDetails(high, low, high.getNum());
            return;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{high.getMainNum(), low.getMainNum()})) {
            if (high.getMainNum().equals(low.getMainNum())) {
                return;
            }
            this.customerMapper.updateMainNum(low.getBizId(), low.getMainNum(), high.getMainNum());
            low.setMainNum(high.getMainNum());
        }
        if (StringUtils.isNotBlank((CharSequence)high.getMainNum())) {
            low.setMainNum(high.getMainNum());
            low.setUpdateTime(new Date());
            this.customerMapper.updateById((Object)low);
        } else {
            high.setMainNum(low.getMainNum());
            high.setUpdateTime(new Date());
            this.customerMapper.updateById((Object)high);
        }
        this.mergeCustomerDetails(high, low, high.getMainNum());
    }

    private void mergeCustomerDetails(Customer high, Customer low, String mainNum) {
        log.info("mergeCustomerDetails,high:{},low:{},mainNum:{}", new Object[]{high, low, mainNum});
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().select(new SFunction[]{Customer::getNum}).eq(Customer::getBizId, (Object)high.getBizId())).in(Customer::getMainNum, Arrays.asList(high.getMainNum(), low.getMainNum(), high.getNum(), low.getNum()));
        List customers = this.customerMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)customers)) {
            log.info("mergeCustomerDetails,customers isEmpty");
            return;
        }
        Set customerNums = customers.stream().map(Customer::getNum).collect(Collectors.toSet());
        List customerDetails = this.customerDetailMapper.queryByCustomerNums(high.getBizId(), customerNums);
        if (CollectionUtils.isEmpty((Collection)customerDetails)) {
            log.info("mergeCustomerDetails,customerDetails isEmpty");
            return;
        }
        log.info("mergeCustomerDetails,customerNums:{}", customerNums);
        CustomerDetail newDetail = new CustomerDetail();
        newDetail.setCustomerNum(mainNum);
        newDetail.setNum(this.idGen.getNum());
        newDetail.setBizId(high.getBizId());
        newDetail.setCorpId(high.getCorpId());
        newDetail.setCreateBy(Long.valueOf(-1L));
        newDetail.setCreateTime(new Date());
        newDetail.setUpdateBy(Long.valueOf(-1L));
        newDetail.setUpdateTime(new Date());
        String avatar = null;
        Integer gender = -1;
        String remark = null;
        String source = null;
        String regin = null;
        String channelId = null;
        Integer type = null;
        String name = "-";
        String area = null;
        Long promoterId = null;
        for (CustomerDetail customerDetail : customerDetails) {
            if (StringUtils.isBlank(avatar) && StringUtils.isNotBlank((CharSequence)customerDetail.getAvatar())) {
                avatar = customerDetail.getAvatar();
            }
            if (gender.equals(-1) && customerDetail.getGender() != null) {
                gender = customerDetail.getGender();
            }
            if (StringUtils.isBlank(remark) && StringUtils.isNotBlank((CharSequence)customerDetail.getRemark())) {
                remark = customerDetail.getRemark();
            }
            if (StringUtils.isBlank(source) && StringUtils.isNotBlank((CharSequence)customerDetail.getSource())) {
                source = customerDetail.getSource();
            }
            if (StringUtils.isBlank(regin) && StringUtils.isNotBlank((CharSequence)customerDetail.getRegion())) {
                regin = customerDetail.getRegion();
            }
            if (StringUtils.isBlank(channelId) && StringUtils.isNotBlank((CharSequence)customerDetail.getChannelId())) {
                channelId = customerDetail.getChannelId();
            }
            if (type == null) {
                type = customerDetail.getType();
            }
            if ("-".equals(name) && StringUtils.isNotBlank((CharSequence)customerDetail.getName())) {
                name = customerDetail.getName();
            }
            if (StringUtils.isBlank(area) && StringUtils.isNotBlank((CharSequence)customerDetail.getArea())) {
                area = customerDetail.getArea();
            }
            if (promoterId != null || customerDetail.getPromoterId() == null) continue;
            promoterId = customerDetail.getPromoterId();
        }
        if (gender.equals(-1)) {
            gender = 0;
        }
        newDetail.setAvatar(avatar);
        newDetail.setGender(gender);
        newDetail.setRemark(remark);
        newDetail.setSource(source);
        newDetail.setRegion(regin);
        newDetail.setChannelId(channelId);
        newDetail.setType(type);
        newDetail.setName(name);
        newDetail.setArea(area);
        newDetail.setPromoterId(promoterId);
        log.info("mergeCustomerDetails,newDetail:{}", (Object)newDetail);
        this.customerDetailMapper.batchInsert(Collections.singletonList(newDetail));
    }

    private String selectMainNum(String lowMainNum, String highMainNum) {
        log.info("selectMainNum,lowMainNum:{},highMainNum:{}", (Object)lowMainNum, (Object)highMainNum);
        return null;
    }

    public boolean bindAccountAndMobile(Long bizId, String account, String mobile) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301");
    }

    public boolean bindContactIdAndOpenId(Long bizId, String contactId, String openId, String moduleType) {
        Customer record1 = this.getCustomerByType(bizId, CustomerIdType.WEWORK_CONTACT_ID.getValue(), contactId, "", "");
        Customer record2 = this.getCustomerByType(bizId, CustomerIdType.WEWORK_CONTACT_OPEN_ID.getValue(), openId, "", "");
        if (record1 == null || record2 == null) {
            return false;
        }
        this.setMainNum(record1, record2);
        CustomerEventReq req = new CustomerEventReq();
        req.setBizId(bizId);
        req.setCustomerNum(record1.getMainNum());
        req.setEventType(EventType.BIND_RELATIONS.getCode());
        EventData eventData = new EventData();
        EventModule eventModule = new EventModule();
        eventModule.setType(moduleType);
        eventData.setModule(eventModule);
        eventData.setId1(record1.getId1());
        eventData.setId1Type(Integer.valueOf(CustomerIdType.WEWORK_CONTACT_ID.getValue()));
        eventData.setId2(record2.getId1());
        eventData.setId2Type(Integer.valueOf(CustomerIdType.WEWORK_CONTACT_OPEN_ID.getValue()));
        req.setEventData(eventData);
        req.setEventTime(new Date());
        this.ccCustomerEventService.addBindRelation(req);
        return true;
    }

    public boolean bindMobile1AndMobile2(Long bizId, String mobile1, String mobile2, String moduleType) {
        log.info("bind mobile {} and {}", (Object)mobile1, (Object)mobile2);
        Customer record1 = this.getCustomerByType(bizId, CustomerIdType.MOBILE.getValue(), mobile1, "", "");
        Customer record2 = this.getCustomerByType(bizId, CustomerIdType.MOBILE.getValue(), mobile2, "", "");
        if (record1 == null || record2 == null) {
            return false;
        }
        this.setMainNum(record1, record2);
        CustomerEventReq req = new CustomerEventReq();
        req.setBizId(bizId);
        req.setCustomerNum(record1.getMainNum());
        req.setEventType(EventType.BIND_RELATIONS.getCode());
        EventData eventData = new EventData();
        EventModule eventModule = new EventModule();
        eventModule.setType(moduleType);
        eventData.setModule(eventModule);
        eventData.setId1(record1.getId1());
        eventData.setId1Type(Integer.valueOf(CustomerIdType.MOBILE.getValue()));
        eventData.setId2(record2.getId1());
        eventData.setId2Type(Integer.valueOf(CustomerIdType.MOBILE.getValue()));
        req.setEventData(eventData);
        req.setEventTime(new Date());
        this.ccCustomerEventService.addBindRelation(req);
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.WEWORK_CONTACT_ID.getValue());
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.MINI_PROGRAM_OPENID.getValue());
        this.touchSyncIsAssociate(bizId, record2.getNum(), CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue());
        return true;
    }

    public boolean mobileIsExist(Long bizId, String mobile) {
        log.info("mobileIsExist bizId:{},mobile:{}", (Object)bizId, (Object)mobile);
        if (!ObjectUtils.allNotNull((Object[])new Object[]{bizId, mobile})) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long count = this.customerMapper.selectCount((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"id1", (Object)mobile)).eq((Object)"id_type", (Object)CustomerIdType.MOBILE.getValue()));
        return count > 0L;
    }

    public List<String> getCustomerNums(Long bizId, String customerNum) {
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        if (Objects.isNull(customer)) {
            log.error("\u6ca1\u6709\u627e\u5230\u5ba2\u6237\u4fe1\u606f\uff1a param:{}", (Object)customer);
            return Lists.newArrayList();
        }
        String mainNum = customer.getMainNum();
        if (StringUtils.isBlank((CharSequence)mainNum)) {
            return Collections.singletonList(customerNum);
        }
        return this.customerMapper.selectNumByMainNum(bizId, mainNum);
    }

    public String getMainNum(Long bizId, String customerNum) {
        log.info("getMainNum bizId:{},customerNum:{}", (Object)bizId, (Object)customerNum);
        Customer customer = (Customer)this.customerMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)customerNum));
        if (Objects.isNull(customer)) {
            return "";
        }
        return customer.getMainNum();
    }

    public List<String> getLeadsCustomerNum(Long bizId, String customerNum) {
        Customer customer = (Customer)this.customerMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"num", (Object)customerNum));
        if (Objects.isNull(customer)) {
            return Lists.newArrayList();
        }
        String mainNum = customer.getMainNum();
        if (StringUtils.isEmpty((CharSequence)mainNum)) {
            return Lists.newArrayList();
        }
        List customerList = this.customerMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).eq((Object)"main_num", (Object)mainNum)).eq((Object)"id_type", (Object)CustomerIdType.MOBILE.getValue()));
        return customerList.stream().map(Customer::getNum).collect(Collectors.toList());
    }

    public Map<String, List<String>> getLeadsCustomerNumByMainNums(Long bizId, Collection<String> mainNums) {
        if (CollectionUtils.isEmpty(mainNums)) {
            return Maps.newHashMap();
        }
        return this.customerMapper.selectLeadsCustomerNumByMainNums(bizId, mainNums);
    }

    public String getMobileByContactId(Long bizId, String contactId) {
        log.info("getMobileByContactId, bizId:{}, customerNum: {}", (Object)bizId, (Object)contactId);
        if (bizId == null || contactId == null) {
            log.error("getMobileByContactId: \u8f93\u5165\u53c2\u6570\u6709\u8bef, bizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
            return "";
        }
        Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.WEWORK_CONTACT_ID.getValue()), contactId, "");
        if (customer == null) {
            log.info("getMobileByContactId: bizId:{}, \u6839\u636e{}\u65e0\u6cd5\u67e5\u8be2\u5230\u8bb0\u5f55,", (Object)bizId, (Object)contactId);
            return "";
        }
        String mainNum = customer.getMainNum();
        if (StringUtils.isBlank((CharSequence)mainNum)) {
            log.error("getMobileByContactId: mainNum\u4e3a\u7a7a\uff0cbizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
            return "";
        }
        List mobileList = this.customerMapper.selectMobilesByMainNum(bizId, mainNum);
        if (CollectionUtils.isEmpty((Collection)mobileList)) {
            log.info("getMobileByContactId: mobileList\u4e3a\u7a7a\uff0cbizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
            return "";
        }
        return (String)mobileList.get(0);
    }

    public List<String> getMobilesByContactId(Long bizId, String contactId) {
        log.info("getMobilesByContactId, bizId:{}, customerNum: {}", (Object)bizId, (Object)contactId);
        if (bizId == null || contactId == null) {
            log.error("getMobilesByContactId: \u8f93\u5165\u53c2\u6570\u6709\u8bef, bizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
            return Lists.newArrayList();
        }
        Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.WEWORK_CONTACT_ID.getValue()), contactId, "");
        if (customer == null) {
            log.info("getMobilesByContactId: bizId:{}, \u6839\u636e{}\u65e0\u6cd5\u67e5\u8be2\u5230\u8bb0\u5f55,", (Object)bizId, (Object)contactId);
            return Lists.newArrayList();
        }
        String mainNum = customer.getMainNum();
        if (StringUtils.isBlank((CharSequence)mainNum)) {
            log.error("getMobilesByContactId: mainNum\u4e3a\u7a7a\uff0cbizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
            return Lists.newArrayList();
        }
        return this.customerMapper.selectMobilesByMainNum(bizId, mainNum);
    }

    public Map<String, String> getMobileByCustomerNums(Long bizId, Collection<String> customerNums) {
        if (CollectionUtils.isEmpty(customerNums)) {
            return Maps.newHashMap();
        }
        Map customerNumMobileMap = this.customerMapper.selectMobileByNums(bizId, customerNums);
        List customerList = this.customerMapper.selectMobileByMainNums(bizId, customerNums);
        for (Customer customer : customerList) {
            if (customerNumMobileMap.containsKey(customer.getMainNum())) continue;
            customerNumMobileMap.put(customer.getMainNum(), customer.getId1());
        }
        return customerNumMobileMap;
    }

    private Customer buildCustomer(Long bizId, Integer idType, String id1, String id2, String unionId) {
        BizSimpleDto bizSimpleDto = null;
        try {
            bizSimpleDto = this.scrmBizService.getById(bizId);
        }
        catch (Exception e) {
            log.error("do scrmBizService getById Error: param:{}", (Object)bizId, (Object)e);
        }
        if (bizSimpleDto == null) {
            throw new IllegalArgumentException("bizId\u4e0d\u6b63\u786e");
        }
        return Customer.builder().num(this.idGen.getNum()).bizId(bizId).corpId(bizSimpleDto.getCorpId()).idType(idType).id1(id1).id2(id2).unionId(unionId).createBy(Long.valueOf(-1L)).createTime(new Date()).updateBy(Long.valueOf(-1L)).updateTime(new Date()).build();
    }

    public boolean appIdAndOpenIdIsExistByMiniProgram(Long bizId, String appId, String openId, String unionId) {
        log.info("check appIdAndOpenIdIsExist, bizId={}, appId={}, openId={}, unionId={}", new Object[]{bizId, appId, openId, unionId});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((appId != null ? 1 : 0) != 0, (Object)"appId is null");
        Preconditions.checkArgument((openId != null ? 1 : 0) != 0, (Object)"openId is null");
        int type = CustomerIdType.MINI_PROGRAM_OPENID.getValue();
        QueryWrapper customerQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)customerQueryWrapper.lambda().eq(Customer::getBizId, (Object)bizId)).eq(Customer::getIdType, (Object)type)).eq(Customer::getId1, (Object)appId)).eq(Customer::getId2, (Object)openId)).eq(StringUtils.isNotBlank((CharSequence)unionId), Customer::getUnionId, (Object)unionId);
        Long count = this.customerMapper.selectCount((Wrapper)customerQueryWrapper);
        return count > 0L;
    }

    public List<CustomerNumResp> onlyQueryByOpenId(Long bizId, List<CustomerNumReq> param) {
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"bizId \u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty(param)) {
            log.error("\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        List pairs = param.stream().map(item -> {
            AppIdOpenIdPair pair = new AppIdOpenIdPair();
            if (StringUtils.isBlank((CharSequence)item.getOpenId()) || StringUtils.isBlank((CharSequence)item.getAppId())) {
                log.info("\u53bb\u9664openId \u4e3a\u7a7a\u7684\u6570\u636e:openId:{};appId:{}", (Object)item.getOpenId(), (Object)item.getAppId());
                return pair;
            }
            pair.setOpenId(item.getOpenId());
            pair.setAppId(item.getAppId());
            return pair;
        }).collect(Collectors.toList());
        List customerInfos = this.customerMapper.butchSelectContactId(bizId, Integer.valueOf(CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue()), pairs);
        if (CollectionUtils.isEmpty((Collection)customerInfos)) {
            return Lists.newArrayList();
        }
        return customerInfos.stream().map(item -> {
            CustomerNumResp resp = new CustomerNumResp();
            resp.setOpenId(item.getOpenId());
            resp.setAppId(item.getAppId());
            resp.setContactId(item.getContactId());
            resp.setCustomerNum(item.getCustomerNum());
            resp.setUnionId(item.getUnionId());
            return resp;
        }).collect(Collectors.toList());
    }

    public List<CustomerNumResp> onlyQueryByContactId(Long bizId, List<CustomerNumReq> param) {
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"bizId \u4e0d\u80fd\u4e3a\u7a7a");
        List pairs = param.stream().map(item -> {
            AppIdOpenIdPair pair = new AppIdOpenIdPair();
            if (StringUtils.isBlank((CharSequence)item.getContactId())) {
                log.info("\u53bb\u9664openId \u4e3a\u7a7a\u7684\u6570\u636e:openId:{};appId:{}", (Object)item.getOpenId(), (Object)item.getAppId());
                return pair;
            }
            pair.setContactId(item.getContactId());
            return pair;
        }).collect(Collectors.toList());
        List customerInfos = this.customerMapper.butchSelectOpenId(bizId, Integer.valueOf(CustomerIdType.WEWORK_CONTACT_ID.getValue()), pairs);
        return customerInfos.stream().map(item -> {
            CustomerNumResp resp = new CustomerNumResp();
            resp.setOpenId(item.getOpenId());
            resp.setAppId(item.getAppId());
            resp.setContactId(item.getContactId());
            resp.setCustomerNum(item.getCustomerNum());
            resp.setUnionId(item.getUnionId());
            return resp;
        }).collect(Collectors.toList());
    }

    public boolean mobileBindOfficialAccount(Long bizId, String mobile) {
        log.info("mobileBindOfficialAccount,bizId:{},mobile:{}", (Object)bizId, (Object)mobile);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)mobile), (Object)"mobile is null");
        Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.MOBILE.getValue()), mobile, null);
        if (customer == null) {
            return false;
        }
        QueryWrapper customerQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)customerQueryWrapper.lambda().eq(Customer::getBizId, (Object)bizId)).eq(Customer::getMainNum, (Object)customer.getMainNum())).eq(Customer::getIdType, (Object)CustomerIdType.OFFICIAL_ACCOUNT_OPENID.getValue());
        Long count = this.customerMapper.selectCount((Wrapper)customerQueryWrapper);
        log.info("mobileBindOfficialAccount,bizId:{},mobile:{},count:{}", new Object[]{bizId, mobile, count});
        return count > 0L;
    }

    public boolean mobileBindAppletAccount(Long bizId, String mobile) {
        log.info("mobileBindAppletAccount,bizId:{},mobile:{}", (Object)bizId, (Object)mobile);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)mobile), (Object)"mobile is null");
        Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.MOBILE.getValue()), mobile, null);
        if (customer == null) {
            return false;
        }
        QueryWrapper customerQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)customerQueryWrapper.lambda().eq(Customer::getBizId, (Object)bizId)).eq(Customer::getMainNum, (Object)customer.getMainNum())).eq(Customer::getIdType, (Object)CustomerIdType.MINI_PROGRAM_OPENID.getValue());
        Long count = this.customerMapper.selectCount((Wrapper)customerQueryWrapper);
        log.info("mobileBindAppletAccount,bizId:{},mobile:{},count:{}", new Object[]{bizId, mobile, count});
        return count > 0L;
    }

    public void updateCustomerMobile(Long bizId, String customerNum, String mobile1, String mobile2) {
        List<String> mobile2RelNums;
        List<String> mobile1RelNums;
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        Preconditions.checkArgument((customer != null ? 1 : 0) != 0, (Object)"Invalid customer num");
        log.info("bizId: {}, customerNum: {}, mobile1: {}, mobile2: {}", new Object[]{bizId, customerNum, mobile1, mobile2});
        log.info("mainCustomer: {}", (Object)customer);
        String customerNum1 = this.getCustomerNumByMobile(bizId, mobile1);
        String contactId = this.getWeworkContactId(bizId, customerNum1);
        if (StringUtils.isNotBlank((CharSequence)mobile2) && StringUtils.isBlank((CharSequence)contactId)) {
            String customerNum2 = this.getCustomerNumByMobile(bizId, mobile2);
            contactId = this.getWeworkContactId(bizId, customerNum2);
        }
        log.info("bind contactId: {}", (Object)contactId);
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            Customer contactCustomer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.WEWORK_CONTACT_ID.getValue()), contactId, null);
            log.info("contactCustomer: {}", (Object)contactCustomer);
            if (contactCustomer != null) {
                contactCustomer.setMainNum("");
                contactCustomer.setUpdateTime(new Date());
                this.customerMapper.updateById((Object)contactCustomer);
            }
        }
        if (CollectionUtils.isNotEmpty(mobile1RelNums = this.getCustomerNumsByMobile(bizId, mobile1))) {
            this.customerMapper.unbind(bizId, mobile1RelNums);
        }
        if (StringUtils.isNotBlank((CharSequence)mobile2) && CollectionUtils.isNotEmpty(mobile2RelNums = this.getCustomerNumsByMobile(bizId, mobile2))) {
            this.customerMapper.unbind(bizId, mobile2RelNums);
        }
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            Customer updateCustomer = this.customerMapper.getByNum(bizId, customerNum);
            Customer contactCustomer = this.getCustomerByType(bizId, CustomerIdType.WEWORK_CONTACT_ID.getValue(), contactId, "", null);
            this.setMainNum(contactCustomer, updateCustomer);
        }
        if (StringUtils.isNotBlank((CharSequence)mobile2)) {
            Customer record1 = this.getCustomerByType(bizId, CustomerIdType.MOBILE.getValue(), mobile1, "", "");
            Customer record2 = this.getCustomerByType(bizId, CustomerIdType.MOBILE.getValue(), mobile2, "", "");
            if (record2 != null) {
                this.setMainNum(record1, record2);
            }
        }
    }

    public void unbind(Long bizId, String customerNum) {
        List<String> customerNums = this.getCustomerNums(bizId, customerNum);
        this.customerMapper.unbind(bizId, customerNums);
    }

    public List<CustomerMobileNumResp> getMobileNumByContactId(Long bizId, String contactId) {
        log.info("getMobileNumByContactId, bizId:{}, customerNum: {}", (Object)bizId, (Object)contactId);
        if (bizId == null || contactId == null) {
            log.error("getMobileNumByContactId: \u8f93\u5165\u53c2\u6570\u6709\u8bef, bizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
            return Lists.newArrayList();
        }
        Customer customer = this.customerMapper.getByType(bizId, Integer.valueOf(CustomerIdType.WEWORK_CONTACT_ID.getValue()), contactId, "");
        if (customer == null) {
            log.info("getMobileNumByContactId: bizId:{}, \u6839\u636e{}\u65e0\u6cd5\u67e5\u8be2\u5230\u8bb0\u5f55,", (Object)bizId, (Object)contactId);
            return Lists.newArrayList();
        }
        String mainNum = customer.getMainNum();
        if (StringUtils.isBlank((CharSequence)mainNum)) {
            log.error("getMobileNumByContactId: mainNum\u4e3a\u7a7a\uff0cbizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
            return Lists.newArrayList();
        }
        List customerList = this.customerMapper.selectCustomersByMainNum(bizId, mainNum);
        if (CollectionUtils.isEmpty((Collection)customerList)) {
            log.info("getMobileNumByContactId: mainNum\u4e3a\u7a7a\uff0cbizId:{}, contactId:{}", (Object)bizId, (Object)contactId);
            return Lists.newArrayList();
        }
        ArrayList respList = Lists.newArrayList();
        customerList.forEach(e -> {
            CustomerMobileNumResp resp = new CustomerMobileNumResp();
            resp.setMobile(e.getId1());
            resp.setNum(e.getNum());
            respList.add(resp);
        });
        return respList;
    }

    public Map<String, String> getMainNumByCustomerNum(Long bizId, Collection<String> customerNums) {
        if (CollectionUtils.isEmpty(customerNums)) {
            return Maps.newHashMap();
        }
        List customers = this.customerMapper.getByNums(bizId, customerNums);
        HashMap result = Maps.newHashMap();
        for (Customer customer : customers) {
            if (customer.getMainNum() != null) {
                result.put(customer.getNum(), customer.getMainNum());
                continue;
            }
            result.put(customer.getNum(), customer.getNum());
        }
        return result;
    }

    public Map<String, List<String>> getCustomerNumsByMainNums(Long bizId, Collection<String> mainNums) {
        if (CollectionUtils.isEmpty(mainNums)) {
            return Maps.newHashMap();
        }
        return this.customerMapper.getCustomerNumsByMainNums(bizId, mainNums);
    }

    public Set<String> getMobilesByCustomerNum(Long bizId, String customerNum) {
        log.info("getMobilesByCustomerNum,bizId:{},customerNum:{}", (Object)bizId, (Object)customerNum);
        if (bizId == null || bizId <= 0L) {
            log.info("\u5546\u6237id\u4e0d\u5408\u6cd5");
            return Collections.emptySet();
        }
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            log.info("customerNum is blank");
            return Collections.emptySet();
        }
        Customer customer = this.customerMapper.getByNum(bizId, customerNum);
        if (customer == null) {
            log.info("\u6839\u636ebizId:{},customerNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        if (customer.getIdType().intValue() == CustomerIdType.MOBILE.getValue()) {
            if (StringUtils.isNotBlank((CharSequence)customer.getId1())) {
                result.add(customer.getId1());
            }
            if (StringUtils.isNotBlank((CharSequence)customer.getId2())) {
                result.add(customer.getId2());
            }
        }
        if (StringUtils.isBlank((CharSequence)customer.getMainNum())) {
            log.info("customer id:{}\u5bf9\u5e94\u7684mainNum\u672a\u7a7a", (Object)customer.getMainNum());
            return result;
        }
        List mobiles = this.customerMapper.selectMobilesByMainNum(bizId, customer.getMainNum());
        if (CollectionUtils.isNotEmpty((Collection)mobiles)) {
            result.addAll(mobiles);
        }
        return result;
    }

    public Set<String> getCustomerNumsUnderMainNums(Long bizId, Collection<String> customerNums) {
        List numsByMainNums;
        log.info("getCustomerNumsUnderMainNums, bizId:{}, customerNums: {}", (Object)bizId, customerNums);
        if (bizId == null || CollectionUtils.isEmpty(customerNums)) {
            log.error("getCustomerNumsUnderMainNums: \u8f93\u5165\u53c2\u6570\u6709\u8bef, bizId:{}, customerNums:{}", (Object)bizId, customerNums);
            return Sets.newHashSet();
        }
        HashSet resultSet = Sets.newHashSet();
        resultSet.addAll(customerNums);
        Map customerNumMap = this.customerMapper.selectMainNumsByNums(customerNums);
        Set mainNumSet = customerNumMap.values().stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(mainNumSet) && CollectionUtils.isNotEmpty((Collection)(numsByMainNums = this.customerMapper.selectCustomerNumsByMainNums(bizId, mainNumSet)))) {
            resultSet.addAll(numsByMainNums);
        }
        return resultSet;
    }
}

