/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.service.impl;

import cn.kinyun.customer.center.common.utils.IdGen;
import cn.kinyun.customer.center.dal.mapper.CustomerMapper;
import cn.kinyun.customer.center.dal.util.DateUtil;
import cn.kinyun.customer.center.dto.req.CustomerAllocAggReq;
import cn.kinyun.customer.center.dto.req.IdAndNameDto;
import cn.kinyun.customer.center.dto.req.follow.FollowQueryParams;
import cn.kinyun.customer.center.dto.req.follow.FollowRecordMsg;
import cn.kinyun.customer.center.dto.req.follow.FollowReq;
import cn.kinyun.customer.center.dto.resp.CustomerAllocAggResp;
import cn.kinyun.customer.center.dto.resp.FollowListResp;
import cn.kinyun.customer.center.dto.resp.FollowResp;
import cn.kinyun.customer.center.enums.CustomerFollowType;
import cn.kinyun.customer.center.service.CcCustomerFollowRecordService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.enums.FollowRecordMsgType;
import com.kuaike.scrm.common.service.ScrmUserService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.Header;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;

@Service
public class CcCustomerFollowRecordServiceImpl
implements CcCustomerFollowRecordService {
    private static final Logger log = LoggerFactory.getLogger(CcCustomerFollowRecordServiceImpl.class);
    @Value(value="${scrm.elasticsearch.customerFollowRecordIndex}")
    private String index;
    @Value(value="${kafka.topic.follow_record}")
    private String topic;
    @Autowired
    private IdGen idGen;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    @Qualifier(value="esStoreThreadPool")
    private ExecutorService executorService;
    @Autowired
    private CcCustomerNumService customerNumService;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private CustomerMapper customerMapper;

    public void add(FollowReq params) {
        log.info("add follow record:{}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getCustomerNum()), (Object)"customerNum is null");
        Preconditions.checkArgument((params.getFollowType() != null ? 1 : 0) != 0, (Object)"followType is null");
        Preconditions.checkArgument((params.getFollowTime() != null ? 1 : 0) != 0, (Object)"followTime is null");
        Preconditions.checkArgument((params.getJsonContent() != null ? 1 : 0) != 0, (Object)"jsonContent is null");
        this.write(params);
        this.followRecordToKafka(Lists.newArrayList((Object[])new FollowReq[]{params}));
    }

    public void addBatch(Long bizId, String source, List<FollowReq> list) {
        log.info("add follow list, bizId:{}, list:{}", (Object)bizId, list);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(list), (Object)"list is empty");
        for (FollowReq it : list) {
            it.setBizId(bizId);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)it.getCustomerNum()), (Object)"customerNum is null");
            Preconditions.checkArgument((it.getFollowType() != null ? 1 : 0) != 0, (Object)"followType is null");
            Preconditions.checkArgument((it.getFollowTime() != null ? 1 : 0) != 0, (Object)"followTime is null");
            Preconditions.checkArgument((it.getJsonContent() != null ? 1 : 0) != 0, (Object)"jsonContent is null");
        }
        this.asyncBatchWrite(list);
        this.followRecordToKafka(list);
    }

    public void followRecordToKafka(List<FollowReq> followReqList) {
        if (CollectionUtils.isEmpty(followReqList)) {
            log.info("followRecordToKafka: followReqList\u4e3a\u7a7a");
            return;
        }
        FollowReq firstReq = followReqList.get(0);
        if (CustomerFollowType.USER_FOLLOW.getValue() == firstReq.getFollowType().intValue() || CustomerFollowType.MOD_FOLLOW.getValue() == firstReq.getFollowType().intValue()) {
            log.info("followRecordToKafka: \u53d1\u9001\u5230kafka\u6d88\u606f\uff0cfollowReqList:{}", followReqList);
            FollowRecordMsg msg = new FollowRecordMsg();
            msg.setBizId(firstReq.getBizId());
            msg.setFollowReqList(followReqList);
            msg.setFollowRecordMsgType(Integer.valueOf(FollowRecordMsgType.ACTIVE_FOLLOW.getValue()));
            try {
                this.kafkaTemplate.send(this.topic, (Object)JacksonUtil.obj2Str((Object)msg));
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u6d88\u606f\u5230\u8ddf\u8fdb\u8bb0\u5f55topic:{}, \u5931\u8d25,", (Object)this.topic, (Object)e);
            }
        } else {
            log.info("followRecordToKafka: \u7c7b\u578b\u4e0d\u662f\u3010\u4e3b\u52a8\u8ddf\u8fdb\u3011\u6216\u3010\u7f16\u8f91\u8ddf\u8fdb\u4fe1\u606f\u3011");
        }
    }

    public FollowListResp list(FollowQueryParams params) {
        log.info("list, params:{}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Long bizId = params.getBizId();
        String customerNum = params.getCustomerNum();
        Integer asc = params.getAsc();
        boolean excludeByCustomerNum = params.getExcludeByCustomerNum() != null && params.getExcludeByCustomerNum() != false;
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((excludeByCustomerNum || customerNum != null ? 1 : 0) != 0, (Object)"customerNum is null");
        if (CollectionUtils.isEmpty((Collection)params.getFollowTypes())) {
            return new FollowListResp(Collections.emptyList(), new PageDto());
        }
        List customerNums = Collections.emptyList();
        if (!excludeByCustomerNum) {
            customerNums = this.customerNumService.getCustomerNums(bizId, customerNum);
            log.info("list, customerNums:{}", (Object)customerNums);
        }
        ArrayList list = Lists.newArrayList();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)params.getBizId())).must((QueryBuilder)QueryBuilders.termsQuery((String)"followType", (Collection)params.getFollowTypes()));
        if (!excludeByCustomerNum) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"customerNum.keyword", (Collection)customerNums));
        }
        if (StringUtils.isNotBlank((CharSequence)params.getProductLineId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"productLineId", (Object)params.getProductLineId()));
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{params.getStartTime(), params.getEndTime()})) {
            Date startTime = params.getStartTime();
            Long startTimestamp = DateUtil.getStartTime((Date)startTime);
            Date endTime = params.getEndTime();
            Long endTimestamp = DateUtil.getEndTime((Date)endTime);
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"followTime").from((Object)startTimestamp).to((Object)endTimestamp));
        }
        if (CollectionUtils.isNotEmpty((Collection)params.getOpList())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"jsonContent.leadTransfer.op", (Collection)params.getOpList()));
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("followTime", asc != null && asc == 1 ? SortOrder.ASC : SortOrder.DESC);
        if (params.getPageDto() != null) {
            searchSourceBuilder.from((params.getPageDto().getPageNum() - 1) * params.getPageDto().getPageSize());
            searchSourceBuilder.size(params.getPageDto().getPageSize().intValue());
        } else {
            searchSourceBuilder.size(10000);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + params.getBizId()});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("Failed query follow from Elastic Search.", (Throwable)e);
            return new FollowListResp(Collections.emptyList(), new PageDto());
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            return new FollowListResp(Collections.emptyList(), new PageDto());
        }
        for (SearchHit searchHit : searchHits) {
            try {
                String doc = searchHit.getSourceAsString();
                FollowResp msg = (FollowResp)JacksonUtil.str2Obj((String)doc, FollowResp.class);
                list.add(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(Math.toIntExact(hits.getTotalHits())));
            params.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
        }
        return new FollowListResp((List)list, params.getPageDto());
    }

    public Map<String, List<FollowResp>> listBatch(FollowQueryParams params) {
        log.info("listBatch, params:{}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Long bizId = params.getBizId();
        List customerNums = params.getCustomerNums();
        Integer asc = params.getAsc();
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        if (CollectionUtils.isEmpty((Collection)customerNums)) {
            log.info("listBatch: customerNums is null");
            return Maps.newHashMap();
        }
        if (CollectionUtils.isEmpty((Collection)params.getFollowTypes())) {
            return Maps.newHashMap();
        }
        HashSet allCustomerNums = Sets.newHashSet();
        allCustomerNums.addAll(customerNums);
        HashMap customerNumRelationMap = Maps.newHashMap();
        Map customerNumMap = this.customerMapper.selectMainNumsByNums((Collection)customerNums);
        Set mainNumSet = customerNumMap.values().stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Map mainNumMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(mainNumSet)) {
            mainNumMap = this.customerMapper.selectNumsByMainNums(bizId, mainNumSet);
        }
        for (String customerNum : customerNums) {
            String mainNum = (String)customerNumMap.get(customerNum);
            if (StringUtils.isBlank((CharSequence)mainNum)) {
                customerNumRelationMap.put(customerNum, customerNum);
                continue;
            }
            List numsByMainNum = (List)mainNumMap.get(mainNum);
            if (!CollectionUtils.isNotEmpty((Collection)numsByMainNum)) continue;
            for (String num : numsByMainNum) {
                customerNumRelationMap.put(num, customerNum);
                allCustomerNums.add(num);
            }
        }
        log.info("listBatch: allCustomerNums:{}, customerNumRelationMap:{}", (Object)allCustomerNums, (Object)customerNumRelationMap);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)params.getBizId())).must((QueryBuilder)QueryBuilders.termsQuery((String)"followType", (Collection)params.getFollowTypes())).must((QueryBuilder)QueryBuilders.termsQuery((String)"customerNum.keyword", (Collection)allCustomerNums));
        if (StringUtils.isNotBlank((CharSequence)params.getProductLineId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"productLineId", (Object)params.getProductLineId()));
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{params.getStartTime(), params.getEndTime()})) {
            Date startTime = params.getStartTime();
            Long startTimestamp = DateUtil.getStartTime((Date)startTime);
            Date endTime = params.getEndTime();
            Long endTimestamp = DateUtil.getEndTime((Date)endTime);
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"followTime").from((Object)startTimestamp).to((Object)endTimestamp));
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("followTime", asc != null && asc == 1 ? SortOrder.ASC : SortOrder.DESC);
        searchSourceBuilder.size(10000);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + params.getBizId()});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("listBatch: Failed query follow from Elastic Search.", (Throwable)e);
            return Maps.newHashMap();
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            return Maps.newHashMap();
        }
        HashMap<String, List<FollowResp>> result = new HashMap<String, List<FollowResp>>();
        for (SearchHit searchHit : searchHits) {
            try {
                String doc = searchHit.getSourceAsString();
                FollowResp msg = (FollowResp)JacksonUtil.str2Obj((String)doc, FollowResp.class);
                String key = (String)customerNumRelationMap.get(msg.getCustomerNum());
                List<FollowResp> respList = result.getOrDefault(key, Lists.newArrayList());
                respList.add(msg);
                result.put(key, respList);
            }
            catch (IOException e) {
                log.error("listBatch: add error : ", (Throwable)e);
            }
        }
        return result;
    }

    public FollowListResp countByUserIdOrWeworkNum(FollowQueryParams params) {
        SearchResponse searchResponse;
        List userIds = params.getUserIds();
        List weworkNums = params.getWeworkNums();
        FollowListResp followListResp = new FollowListResp();
        if (CollectionUtils.isEmpty((Collection)userIds) && CollectionUtils.isEmpty((Collection)weworkNums)) {
            log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)params));
            return followListResp;
        }
        if (Objects.isNull(params.getBizId()) || Objects.isNull(params.getStartTime()) || Objects.isNull(params.getEndTime())) {
            log.info("\u67e5\u8be2\u5546\u5bb6\u6216\u65f6\u95f4\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)params));
            return followListResp;
        }
        RangeQueryBuilder rangeByFollowTime = QueryBuilders.rangeQuery((String)"followTime");
        rangeByFollowTime.gte((Object)params.getStartTime().getTime());
        rangeByFollowTime.lte((Object)params.getEndTime().getTime());
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)rangeByFollowTime).must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)params.getBizId())).should((QueryBuilder)QueryBuilders.termsQuery((String)"weworkUserNum.keyword", (Collection)weworkNums)).should((QueryBuilder)QueryBuilders.termsQuery((String)"userId", (Collection)userIds)).minimumShouldMatch(1);
        TermsAggregationBuilder subAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"customerNum").field("customerNum.keyword");
        TermsAggregationBuilder userIdAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"userId").field("userId");
        userIdAgg.subAggregation((AggregationBuilder)subAgg);
        TermsAggregationBuilder weworkUserNumAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"weworkUserNum").field("weworkUserNum.keyword");
        weworkUserNumAgg.subAggregation((AggregationBuilder)subAgg);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)userIdAgg);
        searchSourceBuilder.aggregation((AggregationBuilder)weworkUserNumAgg);
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + params.getBizId()});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse)) {
            return null;
        }
        Aggregations aggregations = searchResponse.getAggregations();
        Terms weworkUserNumAggResp = (Terms)aggregations.get("weworkUserNum");
        Terms userIdAggResp = (Terms)aggregations.get("userId");
        List numBuckets = weworkUserNumAggResp.getBuckets();
        List userIdBuckets = userIdAggResp.getBuckets();
        HashMap numCount = Maps.newHashMap();
        for (Terms.Bucket numBucket : numBuckets) {
            String key = numBucket.getKeyAsString();
            Long counts = this.countByCustomerNum(numBucket.getAggregations(), "customerNum");
            numCount.put(key, counts);
        }
        HashMap userIdCount = Maps.newHashMap();
        for (Terms.Bucket numBucket : userIdBuckets) {
            long key = numBucket.getKeyAsNumber().longValue();
            Long counts = this.countByCustomerNum(numBucket.getAggregations(), "customerNum");
            userIdCount.put(key, counts);
        }
        followListResp.setWeworkNumCount((Map)numCount);
        followListResp.setUserIdsCount((Map)userIdCount);
        return followListResp;
    }

    public void mergeFollowRecord(Long bizId, String mainCustomerNum, List<String> customerNums) {
        if (CollectionUtils.isEmpty(customerNums)) {
            return;
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)bizId)).must((QueryBuilder)QueryBuilders.termsQuery((String)"followType", (Collection)Lists.newArrayList((Object[])new Integer[]{CustomerFollowType.USER_FOLLOW.getValue()}))).must((QueryBuilder)QueryBuilders.termsQuery((String)"customerNum.keyword", customerNums));
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + bizId});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        try {
            SearchResponse response = this.restHighLevelClient.search(searchRequest, new Header[0]);
            SearchHit[] hits = response.getHits().getHits();
            if (hits.length == 0) {
                return;
            }
            BulkRequest bulkRequest = new BulkRequest();
            for (SearchHit searchHit : hits) {
                UpdateRequest updateRequest = new UpdateRequest(this.index + "_" + bizId, "doc", searchHit.getId());
                updateRequest.doc(XContentFactory.jsonBuilder().startObject().field("customerNum", mainCustomerNum).endObject());
                bulkRequest.add(updateRequest);
            }
            this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
    }

    public void fixCustomerFollow(Long bizId, List<String> customerNums, Integer isAllFollowType) {
        if (bizId == null) {
            return;
        }
        log.info("fixCustomerFollow: bizId:{}, customerNums:{}", (Object)bizId, customerNums);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)bizId)).must((QueryBuilder)QueryBuilders.existsQuery((String)"weworkUserName"));
        BoolQueryBuilder subQuery = QueryBuilders.boolQuery();
        subQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"userId", (long)-1L));
        subQuery.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"userId")));
        subQuery.minimumShouldMatch(NumberUtils.INTEGER_ONE.intValue());
        queryBuilder.must((QueryBuilder)subQuery);
        if (isAllFollowType == null || isAllFollowType.equals(NumberUtils.INTEGER_ZERO)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"followType", (Collection)Lists.newArrayList((Object[])new Integer[]{CustomerFollowType.USER_FOLLOW.getValue(), CustomerFollowType.MOD_FOLLOW.getValue()})));
        }
        if (CollectionUtils.isNotEmpty(customerNums)) {
            HashSet allCustomerNums = Sets.newHashSet();
            customerNums.forEach(a -> {
                List tempList = this.customerNumService.getCustomerNums(bizId, a);
                if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                    allCustomerNums.addAll(tempList);
                }
            });
            log.info("fixCustomerFollow: bizId:{}, allCustomerNums:{}", (Object)bizId, (Object)allCustomerNums);
            if (CollectionUtils.isNotEmpty((Collection)allCustomerNums)) {
                queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"customerNum.keyword", (Collection)allCustomerNums));
            }
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + bizId});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        searchSourceBuilder.size(10000);
        try {
            SearchResponse response = this.restHighLevelClient.search(searchRequest, new Header[0]);
            SearchHit[] hits = response.getHits().getHits();
            if (hits == null || hits.length == 0) {
                log.info("fixCustomerFollow: hits\u4e3a\u7a7a, bizId:{}", (Object)bizId);
                return;
            }
            HashSet nameSet = Sets.newHashSet();
            for (SearchHit searchHit : hits) {
                try {
                    String doc = searchHit.getSourceAsString();
                    FollowResp msg = (FollowResp)JacksonUtil.str2Obj((String)doc, FollowResp.class);
                    if (!StringUtils.isNotBlank((CharSequence)msg.getWeworkUserName())) continue;
                    nameSet.add(msg.getWeworkUserName());
                }
                catch (IOException e) {
                    log.error("fixCustomerFollow: e = " + e);
                }
            }
            if (CollectionUtils.isEmpty((Collection)nameSet)) {
                log.info("fixCustomerFollow: \u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u7528\u6237\u540d, bizId:{}", (Object)bizId);
                return;
            }
            HashMap name2UserIdMap = Maps.newHashMap();
            Lists.partition((List)Lists.newArrayList((Iterable)nameSet), (int)300).forEach(list -> {
                Map tmpMap = this.scrmUserService.getUserIdByName(bizId, list);
                if (MapUtils.isNotEmpty((Map)tmpMap)) {
                    name2UserIdMap.putAll(tmpMap);
                }
            });
            if (MapUtils.isEmpty((Map)name2UserIdMap)) {
                log.info("fixCustomerFollow: \u6839\u636e\u540d\u5b57\u65e0\u6cd5\u67e5\u8be2\u5230userId, bizId:{}, nameSet:{}", (Object)bizId, (Object)nameSet);
                return;
            }
            HashSet updateUserIds = Sets.newHashSet();
            HashSet updateCustomerNums = Sets.newHashSet();
            BulkRequest bulkRequest = new BulkRequest();
            for (SearchHit searchHit : hits) {
                Long userId;
                FollowResp msg = null;
                try {
                    String doc = searchHit.getSourceAsString();
                    msg = (FollowResp)JacksonUtil.str2Obj((String)doc, FollowResp.class);
                }
                catch (IOException e) {
                    log.error("fixCustomerFollow: \u66f4\u65b0 e = " + e);
                }
                if (msg == null || StringUtils.isBlank((CharSequence)msg.getWeworkUserName()) || (userId = (Long)name2UserIdMap.get(msg.getWeworkUserName())) == null) continue;
                UpdateRequest updateRequest = new UpdateRequest(this.index + "_" + bizId, "doc", searchHit.getId());
                updateRequest.doc(XContentFactory.jsonBuilder().startObject().field("userId", userId).endObject());
                bulkRequest.add(updateRequest);
                updateUserIds.add(userId);
                updateCustomerNums.add(msg.getCustomerNum());
            }
            log.info("fixCustomerFollow: bizId:{}, updateUserIds:{}, updateCustomerNums:{}, size:{}", new Object[]{bizId, updateUserIds, updateCustomerNums, bulkRequest.numberOfActions()});
            if (bulkRequest.numberOfActions() > 0) {
                this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
            }
        }
        catch (Exception e) {
            log.error("fixCustomerFollow: \u4fee\u590d\u5931\u8d25, e = ", (Throwable)e);
        }
    }

    private Long countByCustomerNum(Aggregations agg, String itemsName) {
        if (Objects.isNull(agg)) {
            return 0L;
        }
        Terms customerNum = (Terms)agg.get(itemsName);
        if (Objects.isNull(customerNum)) {
            return 0L;
        }
        List buckets = customerNum.getBuckets();
        if (CollectionUtils.isEmpty((Collection)buckets)) {
            return 0L;
        }
        return customerNum.getBuckets().size();
    }

    private IndexRequest newIndexRequest(FollowReq params) {
        Map map = JacksonUtil.toMap((Object)params);
        map.put("timestamp", System.currentTimeMillis());
        IndexRequest indexRequest = new IndexRequest(this.index + "_" + params.getBizId(), "doc", this.idGen.getNum());
        indexRequest.source(map, XContentType.JSON);
        return indexRequest;
    }

    private void write(FollowReq params) {
        IndexRequest indexRequest = this.newIndexRequest(params);
        try {
            this.restHighLevelClient.index(indexRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("es\u63d2\u5165\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("es\u63d2\u5165\u5f02\u5e38", e);
        }
    }

    private void asyncBatchWrite(List<FollowReq> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List partition = Lists.partition(list, (int)100);
        for (List part : partition) {
            this.executorService.submit(() -> {
                try {
                    this.batchWrite(part);
                }
                catch (Exception e) {
                    log.error("write data failed", (Throwable)e);
                }
            });
        }
    }

    private void batchWrite(List<FollowReq> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (FollowReq it : list) {
            bulkRequest.add(this.newIndexRequest(it));
        }
        BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
        log.info("bulk response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            if (response.getFailureMessage() == null) continue;
            log.error("response.id:{}, error:{}", (Object)response.getId(), (Object)response.getFailureMessage());
        }
    }

    public List<CustomerAllocAggResp> aggAllocRecord(CustomerAllocAggReq req) {
        SearchResponse searchResponse;
        log.info("aggAllocRecord,req:{}", (Object)req);
        req.validate();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"bizId", (Object)req.getBizId())).must((QueryBuilder)QueryBuilders.matchQuery((String)"followType", (Object)CustomerFollowType.LEADS_BIND_OR_RELEASE.getValue()));
        if (ObjectUtils.allNotNull((Object[])new Object[]{req.getStartTime(), req.getEndTime()})) {
            Date startTime = req.getStartTime();
            Date endTime = req.getEndTime();
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"followTime").from((Object)startTime.getTime()).to((Object)endTime.getTime()));
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getOpList())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"jsonContent.leadTransfer.op", (Collection)req.getOpList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getUserNums())) {
            if (req.getAggType() == null || NumberUtils.INTEGER_ONE.equals(req.getAggType())) {
                queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"jsonContent.leadTransfer.bindTo.id.keyword", (Collection)req.getUserNums()));
            } else {
                queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"jsonContent.leadTransfer.releaseFrom.id.keyword", (Collection)req.getUserNums()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getCustomerNums())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"customerNum.keyword", (Collection)req.getCustomerNums()));
        }
        TermsAggregationBuilder userNumsAggregation = (TermsAggregationBuilder)AggregationBuilders.terms((String)"userNums").size(CollectionUtils.isNotEmpty((Collection)req.getUserNums()) ? req.getUserNums().size() + 1 : 10000).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"customerNums").field("customerNum.keyword")).size(10000));
        if (req.getAggType() == null || NumberUtils.INTEGER_ONE.equals(req.getAggType())) {
            userNumsAggregation.field("jsonContent.leadTransfer.bindTo.id.keyword");
        } else {
            userNumsAggregation.field("jsonContent.leadTransfer.releaseFrom.id.keyword");
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)userNumsAggregation);
        searchSourceBuilder.sort("followTime", SortOrder.ASC);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index + "_" + req.getBizId()});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("aggAllocRecord,error,searchRequest:{}", (Object)searchRequest, (Object)e);
            return Collections.emptyList();
        }
        HashMap<String, Set> userNumAndCustomerNumMap = new HashMap<String, Set>();
        HashSet<String> customerNumSet = new HashSet<String>();
        Terms userNumsTerms = (Terms)searchResponse.getAggregations().get("userNums");
        for (Terms.Bucket userNumsBucket : userNumsTerms.getBuckets()) {
            String userNum = userNumsBucket.getKeyAsString();
            ParsedStringTerms customerNumsTerms = (ParsedStringTerms)userNumsBucket.getAggregations().get("customerNums");
            for (Terms.Bucket bucket : customerNumsTerms.getBuckets()) {
                String customerNum = bucket.getKeyAsString();
                Set orDefault = userNumAndCustomerNumMap.getOrDefault(userNum, new HashSet());
                orDefault.add(customerNum);
                userNumAndCustomerNumMap.put(userNum, orDefault);
                customerNumSet.add(customerNum);
            }
        }
        if (userNumAndCustomerNumMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList customerNumList = new ArrayList(customerNumSet);
        customerNumSet = null;
        List partition = Lists.partition(customerNumList, (int)100);
        HashMap customerNumMobileMap = new HashMap();
        for (List customerNums : partition) {
            Map map = this.customerNumService.getMobileByCustomerNums(req.getBizId(), (Collection)customerNums);
            customerNumMobileMap.putAll(map);
        }
        ArrayList<CustomerAllocAggResp> list = new ArrayList<CustomerAllocAggResp>();
        for (Map.Entry entry : userNumAndCustomerNumMap.entrySet()) {
            String userNum = (String)entry.getKey();
            Set customerNums = (Set)entry.getValue();
            CustomerAllocAggResp resp = new CustomerAllocAggResp();
            resp.setUserNum(userNum);
            ArrayList<IdAndNameDto> customerNumAndMobile = new ArrayList<IdAndNameDto>();
            for (String customerNum : customerNums) {
                String mobile;
                if (StringUtils.isBlank((CharSequence)customerNum) || StringUtils.isBlank((CharSequence)(mobile = (String)customerNumMobileMap.get(customerNum)))) continue;
                customerNumAndMobile.add(new IdAndNameDto(customerNum, mobile));
            }
            if (CollectionUtils.isEmpty(customerNumAndMobile)) continue;
            resp.setCustomerNums(customerNumAndMobile);
            list.add(resp);
        }
        log.info("aggAllocRecord list:{}", (Object)list.size());
        return list;
    }
}

