/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.biz.operator.executor;

import cn.kinyun.customer.center.common.service.RedisDistributedLock;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.OperatorResult;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OperatorResultService {
    private static final Logger log = LoggerFactory.getLogger(OperatorResultService.class);
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private RedisDistributedLock lock;
    @Value(value="${scrm.elasticsearch.operatorResultIndex}")
    private String operatorResultIndex;
    private static final String TYPE = "doc";

    public void saveResult(OperatorResult result) {
        log.info("save operator result with data={}", (Object)result);
        Preconditions.checkArgument((boolean)Objects.nonNull(result), (Object)"result can not be null");
        result.validate();
        Map map = JacksonUtil.toMap((Object)result);
        IndexRequest indexRequest = new IndexRequest(this.operatorResultIndex, TYPE, result.getRequestId());
        indexRequest.source(map, XContentType.JSON);
        try {
            this.client.index(indexRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("save to operatorResult with error", (Throwable)e);
        }
    }

    public void updateResult(OperatorResult result) {
        log.info("update operator result with data={}", (Object)result);
        Preconditions.checkArgument((boolean)Objects.nonNull(result), (Object)"result can not be null");
        result.setUpdateTime(new Date());
        result.validate();
        UpdateRequest updateRequest = new UpdateRequest(this.operatorResultIndex, TYPE, result.getRequestId());
        Map map = JacksonUtil.toMap((Object)result);
        updateRequest.doc(map, XContentType.JSON);
        try {
            this.client.update(updateRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("update operatorResult with error", (Throwable)e);
        }
    }

    public OperatorResult queryByRequestId(String requestId) {
        log.info("query operator result with requestId={}", (Object)requestId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)requestId), (Object)"requestId is not null or empty");
        GetRequest getRequest = new GetRequest(this.operatorResultIndex, TYPE, requestId);
        GetResponse searchResponse = null;
        try {
            searchResponse = this.client.get(getRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("search operator result with error", (Throwable)e);
            return null;
        }
        if (Objects.isNull(searchResponse) || !searchResponse.isExists()) {
            log.error("requestId is not exists");
            return null;
        }
        try {
            String doc = searchResponse.getSourceAsString();
            return (OperatorResult)JacksonUtil.str2Obj((String)doc, OperatorResult.class);
        }
        catch (IOException e) {
            log.error("parse from json with error", (Throwable)e);
            return null;
        }
    }
}

