/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.sal.customer.service.impl;

import cn.kinyun.customer.center.dal.entity.BizInitRecord;
import cn.kinyun.customer.center.dal.mapper.BizInitRecordMapper;
import cn.kinyun.customer.center.sal.customer.service.BizInitService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class BizInitServiceImpl
implements BizInitService {
    private static final Logger log = LoggerFactory.getLogger(BizInitServiceImpl.class);
    private static final String SCHEMA_SQL = "schema.sql";
    private final Set<Long> allBizIds = new HashSet<Long>();
    @Autowired
    private BizInitRecordMapper bizInitRecordMapper;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public void tryInit(Long bizId) {
        if (this.allBizIds.contains(bizId)) {
            return;
        }
        Long count = this.bizInitRecordMapper.selectCount((Wrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId));
        if (count > 0L) {
            this.allBizIds.add(bizId);
            return;
        }
        log.info("\u521d\u59cb\u5316\u6570\u636e\u5e93, bizId={}", (Object)bizId);
        this.createTables(bizId);
        try {
            BizInitRecord record = new BizInitRecord();
            record.setBizId(bizId);
            record.setCreateTime(new Date());
            this.bizInitRecordMapper.insert((Object)record);
        }
        catch (Exception e) {
            log.error("save biz init record failed", (Throwable)e);
        }
        this.allBizIds.add(bizId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Statement> readSchema(InputStream in) throws Exception {
        Statements statements;
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser((InputStream)in, (String)"UTF-8");
            statements = CCJSqlParserUtil.parseStatements((CCJSqlParser)parser);
        }
        finally {
            in.close();
        }
        return statements.getStatements();
    }

    private void createTables(Long bizId) {
        List<Statement> statements;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try (InputStream in = loader.getResourceAsStream(SCHEMA_SQL);){
            if (in == null) {
                throw new NullPointerException("\u7f3a\u5c11\u6570\u636e\u5e93\u521d\u59cb\u5316\u811a\u672c");
            }
            statements = this.readSchema(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u89e3\u6790\u6570\u636e\u5e93\u811a\u672c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u521d\u59cb\u5316\u811a\u672c", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u89e3\u6790\u6570\u636e\u811a\u672c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u521d\u59cb\u5316\u811a\u672c\u662f\u5426\u6b63\u5e38\u3002");
        }
        if (CollectionUtils.isEmpty(statements)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u8868\uff0c\u8bf7\u68c0\u67e5\u521d\u59cb\u5316\u811a\u672c\u662f\u5426\u6b63\u5e38\u3002");
        }
        for (Statement statement : statements) {
            if (!(statement instanceof CreateTable)) continue;
            this.createTable(bizId, (CreateTable)statement);
        }
    }

    private void createTable(Long bizId, CreateTable createTable) {
        Table table = createTable.getTable();
        String name = table.getName();
        if (name.startsWith("`")) {
            name = name.substring(1);
        }
        if (name.endsWith("`")) {
            name = name.substring(0, name.length() - 1);
        }
        String newName = "`" + name + "_" + bizId + "`";
        table.setName(newName);
        createTable.setIfNotExists(true);
        String sql = createTable.toString();
        log.info("create table:{}", (Object)newName);
        try {
            this.jdbcTemplate.execute(sql);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            log.error("\u521b\u5efa\u8868\u5931\u8d25:{}", (Object)sql, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u8868\u5931\u8d25:" + name);
        }
    }
}

