package cn.kinyun.customer.center.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * author: jw
 * date: 2022/4/21 上午10:44
 * content: 订单系统来源
 */
public enum OrderSource {
    OPEN_API("API", "API对接"),
    TRADE_ORDER("trade", "商品订单系统"),
    SHOP_ORDER("shop", "小商店订单"),
    AD_ORDER("ad", "广告订单"),
    MEETING_ORDER("meeting", "直播带货订单"),
    BJYX_ORDER("bjyx", "百家云校");

    private static final Map<String, OrderSource> CACHE;

    static {
        CACHE = new HashMap<>();
        for (OrderSource e : values()) {
            CACHE.put(e.value, e);
        }
    }

    public static OrderSource getType(String value) {
        return CACHE.get(value);
    }

    private String value;
    private String desc;

    OrderSource(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
