package cn.kinyun.customer.center.dto.req.order;

import cn.kinyun.customer.center.dto.req.BaseReq;
import cn.kinyun.customer.center.dto.req.ExtendFieldDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * @author Created by chenjiaqiang on 2021/12/13
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class OrderReq extends BaseReq {


    private Long customerOrderId;
    /**
     * 表的唯一索引
     */
    private String customerOrderNum;
    // 订单编号
    private String orderNo;

    // 产品编号
    private String skuNo;

    // 产品名称
    private String skuName;

    // 产品封面地址
    private String skuImgUrl;

    // 产品金额
    private Long skuAmount;

    // 商户对应的企业ID
    private String corpId;

    private List<OrderSkuListReq> orderSkuListReqs;

    // 订单金额
    private Long orderAmount;

    // 已支付金额
    private Long paidAmount;

    private Long shouldPayAmount;

    // 退款时间
    private Date refundTime;

    // 支付状态
    private Integer payStatus;

    // 退款单号
    private String refundNo;

    // 退款金额 单位为毫
    private Long refundAmount;

    // 支付时间
    private Date payTime;

    // 退款状态
    private Integer refundStatus;

    // 录单人
    private Long createBy;

    // 订单创建时间
    private Date createTime;

    // 订单备注
    private String remark;

    // 关联数据类型
    private String fkType;

    private String fkId;

    private Integer isDeleted;


    private String customerMobile;

    private String customerName;


    /**
     * 支付凭证
     */
    private String paymentVoucherUrl;

    /**
     * 业绩归属部门Id
     */
    private Long achieveDepartId;

    /**
     * 优惠金额
     */
    private Long discountAmount;


    /**
     * 支付流水号
     */
    private String payNo;

    /**
     * 支付方式
     */
    private Integer paidChannelType;

    /**
     * 录入方式 见 OrderEntryMethodEnum
     */
    private Integer entryMethod;

    /**
     * 更新之前的成单人id
     */
    private Long beforeOrderUser;

    /**
     * 更新之后的成单人id
     */
    private Long afterOrderUser;

    /**
     * 订单业绩系数是百分数
     */
    private Double performanceRate;

    /**
     * 动态字段， 字段属性名，字段属性值
     */
    private List<ExtendFieldDto> dynamicColValue;

}
