/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.enums;

import java.util.HashMap;
import java.util.Map;

public enum OrderSource {
    OPEN_API("API", "API\u5bf9\u63a5"),
    TRADE_ORDER("trade", "\u5546\u54c1\u8ba2\u5355\u7cfb\u7edf"),
    SHOP_ORDER("shop", "\u5c0f\u5546\u5e97\u8ba2\u5355"),
    AD_ORDER("ad", "\u5e7f\u544a\u8ba2\u5355"),
    MEETING_ORDER("meeting", "\u76f4\u64ad\u5e26\u8d27\u8ba2\u5355");

    private static final Map<String, OrderSource> CACHE;
    private String value;
    private String desc;

    public static OrderSource getType(String value) {
        return CACHE.get(value);
    }

    private OrderSource(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CACHE = new HashMap<String, OrderSource>();
        for (OrderSource e : OrderSource.values()) {
            CACHE.put(e.value, e);
        }
    }
}

