package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2021/12/14
 */
@Data
public abstract class BaseBatchReq<T> implements Serializable {

    /**
     * 商户ID
     */
    protected Long bizId;

    /**
     * 数据来源
     */
    protected String source;

    protected List<T> list;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(source), "source不能为空");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(list), "list不能为空");
    }
}
