package cn.kinyun.customer.center.service;

import cn.kinyun.customer.center.dto.req.CustomerInfoPageReq;
import cn.kinyun.customer.center.dto.req.order.OrderRecordReq;
import cn.kinyun.customer.center.dto.req.order.OrderReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderPayStatusReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderRefundInfoReq;
import cn.kinyun.customer.center.dto.resp.CustomerOrderResp;
import cn.kinyun.customer.center.dto.resp.CustomerOrderWeworkInfoResp;

import java.util.List;

/**
 * desc: 客户订单接口
 *
 * @author yanmaoyuan
 * @date 2021/12/10
 */
public interface CcCustomerOrderService {

    /**
     * 插入订单
     *
     * @param params
     */
    void addOrder(OrderReq params);

    /**
     * 插入订单支付记录
     *
     * @param params
     */
    void addOrderPayRecord(OrderRecordReq params);

    /**
     * 更新支付状态
     *
     * @param params
     */
    void setOrderPayStatus(SetOrderPayStatusReq params);

    /**
     * 退款信息更新
     *
     * @param params
     */
    void setOrderRefundInfo(SetOrderRefundInfoReq params);

    /**
     *  查询用户订单信息
     * */
    CustomerOrderResp queryCustomerOrderInfo(CustomerInfoPageReq pageReq);

    /**
     *  查询订单列表
     * */
    List<CustomerOrderWeworkInfoResp> queryCustomerOrderList(Long bizId, String customerNum);
}
