package cn.kinyun.customer.center.service;

import java.util.List;

/**
 * desc: 客户标识接口
 *
 * @author yanmaoyuan
 * @date 2021/12/9
 */
public interface CcCustomerNumService {

    /**
     * 根据type、id1、id2获取客户唯一编号
     *
     * @param bizId   商户ID
     * @param type    客户标识类型
     * @param id1     标识1
     * @param id2     标识2
     * @param unionId unionId
     * @see cn.kinyun.customer.center.enums.CustomerIdType
     */
    String getCustomerNumByType(Long bizId, int type, String id1, String id2, String unionId);

    // 根据手机号获取customerNum
    String getCustomerNumByMobile(Long bizId, String mobile);

    // 根据企业客户ID获取customerNum
    String getCustomerNumByWeworkContactId(Long bizId, String contactId, String unionId);// unionId 选填

    // 根据公众号粉丝获取customerNum
    String getCustomerNumByOfficialFans(Long bizId, String appId, String openId, String unionId);// unionId 选填

    // 根据小程序获取customerNum
    String getCustomerNumByMiniProgram(Long bizId, String appId, String openId, String unionId);// unionId 选填

    // 根据H5页面的cookie获取customerNum
    String getCustomerNumByH5Cookie(Long bizId, String cookie);

    // 根据企业微信授权得到的openId获取customerNum
    String getCustomerNumByWeworkOpenId(Long bizId, String openId);

    String getWeworkContactId(Long bizId, String customerNum);

    //////////////// 查询已经绑定的客户

    List<String> getCustomerNumsByType(Long bizId, int type, String id1, String id2, String unionId);

    // 根据手机号获取customerNum
    List<String> getCustomerNumsByMobile(Long bizId, String mobile);

    // 根据企业客户ID获取customerNum
    List<String> getCustomerNumsByWeworkContactId(Long bizId, String contactId, String unionId);// unionId 选填

    // 根据公众号粉丝获取customerNum
    List<String> getCustomerNumsByOfficialFans(Long bizId, String appId, String openId, String unionId);// unionId 选填

    // 根据小程序获取customerNum
    List<String> getCustomerNumsByMiniProgram(Long bizId, String appId, String openId, String unionId);// unionId 选填

    // 根据H5页面的cookie获取customerNum
    List<String> getCustomerNumsByH5Cookie(Long bizId, String cookie);

    // 根据企业微信授权的OpenId获取customerNum
    List<String> getCustomerNumsByWeworkOpenId(Long bizId, String openId);

    /////////////// 绑定客户

    // 绑定企业客户ID和手机号
    boolean bindWeworkContactAndMobile(Long bizId, String contactId, String mobile, String moduleType);

    // 绑定小程序和手机号
    boolean bindMiniProgramAndMobile(Long bizId, String appId, String openId, String mobile);

    // 绑定小商店账号和手机号
    boolean bindAccountAndMobile(Long bizId, String account, String mobile);

    boolean bindContactIdAndOpenId(Long bizId, String contactId, String openId, String moduleType);

    // 判断手机号是否存在
    boolean mobileIsExist(Long bizId, String mobile);

    // 判断appId和openId是否存在
    boolean appIdAndOpenIdIsExistByMiniProgram(Long bizId, String appId, String openId, String unionId);// unionId 选填

    /**
     * @param bizId
     * @param mobile1
     * @param mobile2
     * @param moduleType
     * @return
     */
    boolean bindMobile1AndMobile2(Long bizId, String mobile1, String mobile2, String moduleType);

    /**
     * 所有的customerNum
     *
     * @param bizId
     * @param customerNum
     * @return
     */
    List<String> getCustomerNums(Long bizId, String customerNum);

    /**
     * getMainNum
     *
     * @param bizId
     * @param customerNum
     * @return
     */
    String getMainNum(Long bizId, String customerNum);

    /**
     * 线索的customerNum
     *
     * @param bizId
     * @param customerNum
     * @return
     */
    List<String> getLeadsCustomerNum(Long bizId, String customerNum);

    /**
     * 根据企业客户Id（weworkContactId）查询手机号，已废弃
     **/
    String getMobileByContactId(Long bizId,String contactId);

    /**
     * 根据企业客户Id（weworkContactId）查询手机号，返回的是list
     **/
    List<String> getMobilesByContactId(Long bizId,String contactId);

}
