package cn.kinyun.customer.center.dto.req.order;

import cn.kinyun.customer.center.dto.req.BaseReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * @author Created by chenjiaqiang on 2021/12/13
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class OrderReq extends BaseReq {

    // 订单编号
    private String orderNo;

    // 产品编号
    private String skuNo;

    // 产品名称
    private String skuName;

    // 产品封面地址
    private String skuImgUrl;

    // 订单金额
    private Long orderAmount;

    // 已支付金额
    private Long paidAmount;

    // 支付状态
    private Integer payStatus;

    // 退款单号
    private String refundNo;

    // 退款金额 单位为毫
    private Long refundAmount;

    // 退款时间
    private Date refundTime;

    // 退款状态
    private Integer refundStatus;

    // 录单人
    private Long createBy;

    // 订单创建时间
    private Date createTime;

    // 订单备注
    private String remark;

    // 关联数据类型
    private String fkType;

    private String fkId;

    private Integer isDeleted;

}
