package cn.kinyun.customer.center.dto.req.event;

import cn.kinyun.customer.center.dto.req.follow.FormSubmitDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author lanye
 */
@Data
public class EventData implements Serializable {
    private String accessNum;    //页面访问记录num

    private EventPage page;

    private EventSharer sharer;

    private EventVisitor visitor;

    private EventModule module;

    private AccessInfo accessInfo;

    //表单提交内容
    private List<FormSubmitDto> submitList;

    private boolean isNewMobile;

    private String mobile;

    // ------------- 企微好友 -----------------

    private String contactId;

    private String name;

    private String avatar;

    private String corpName;

    private String corpFullName;

    private Integer type;

    private Integer gender;

    private String remark;

    private List<String> weworkTagIds;

    private String weworkUserNum;

    private String weworkUserName;

    private String opUserId;  //发起操作的userId或contactId

    private Date addTime;

    private Date deletedTime;

    private Integer addType;

    private String state;

    // ------------- 进群退群 -----------------

    private String weworkRoomId;

    private String roomName;

    private String memberId;

    private Date joinTime;

    private Integer joinScene;

    private Date quitTime;

    private Integer quitScene;

    private String ownerId;

    // ------------- 粉丝 -----------------

    private String fansId;

    private String appId;

    private String openId;

    private Date operateTime;

    // ------------- 订单 -----------------

    private String orderNo;

    private String orderType;

    /**
     * 订单金额 单位毫
     */
    private Long orderAmount;

    private Date createTime;

    /**
     * 支付金额 单位毫
     */
    private Long payAmount;

    private Date payTime;

    private String payChannelName;


    private String refundNo;

    /**
     * 退款金额 单位毫
     */
    private Long refundAmount;

    private String refundTypeDesc;

    private Date refundTime;

    // ------------- 数据打通 -----------------

    private String id1;

    private Integer id1Type;

    private String id2;

    private Integer id2Type;

    private String bindRelationsType;

    // ------------- 签署合同 -----------------

    /**
     * 合同模板名称
     */
    private String contractName;
    /**
     * 合同签署人名称
     */
    private String userName;

}
