package cn.kinyun.customer.center.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum TuitionReportTypeEnum {
    PAYMENT("收款单"),
    REFUND("退款单");


    private final String desc;

    TuitionReportTypeEnum(String desc) {
        this.desc = desc;
    }

    private static final Map<String, TuitionReportTypeEnum> cache;

    static {
        cache = new HashMap<>();
        for (TuitionReportTypeEnum item : TuitionReportTypeEnum.values()) {
            cache.put(item.getDesc(), item);
        }
    }

    public static TuitionReportTypeEnum get(String desc) {
        return cache.get(desc);
    }

    public static TuitionReportTypeEnum getByDesc(String desc) {
        if (StringUtils.isBlank(desc)) {
            return null;
        }
        for (TuitionReportTypeEnum value : values()) {
            String de = value.getDesc();
            if (StringUtils.equals(de, desc)) {
                return value;
            }
        }
        return null;
    }
}
