package cn.kinyun.customer.center.dto.resp;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * author: jw
 * date: 2022/4/19 下午4:13
 * content:
 */
@Data
@ToString(callSuper = true)
public class OrderListResp implements Serializable {

    private Long bizId;
    private String corpId;

    private String phone;
    private String crmCustomerName;
    private String customerNum;
    private String leadsNum;
    private String productLineNum;

    private String id;

    //订单信息
    private String orderNo;  //订单编号

    private Date orderTime;   //下单时间

    private String source;    //来源

    private String sourceDesc;

    private List<String> skuNames;  //商品名

    private List<OrderSkuResp> skuList;  //商品名

    //付款信息
    //价格金额都是放大一万倍
    private Long orderAmount;   //订单金额

    private Long discountAmount;  //优惠券金额

    private Long paidAmount;    //付款金额

    private Long refundAmount;

    private Integer paidChannelType;      //支付方式

    private String paidTypeDesc;   //支付方式描述

    private Integer status;

    private String statusDesc;

    /**
     * 详情页用的订单状态
     */
    private String orderStatusDesc;

    /**
     * 详情页用的订单状态
     */
    private Integer orderStatus;

    private String payNo;   //支付流水号

    private List<OrderPayRecordResp> payRecordList;   //支付信息

    private List<RefundOrderListResp> refundOrderList;   //退款信息

    private String paymentVoucherUrl;  //支付凭证url

    private List<String> paymentVoucherUrlList;  //支付凭证url

    //客户信息
    private String customerName;    //客户名

    private String customerMobile;  //客户手机号

    private Long userId;     //成单人id

    //归属信息
    private String userName;  //成单人名

    private Long achieveDepartId;  //业绩归属部门id

    private String achieveDepartDesc;   //归属部门描述

    private List<ExtendFieldResp> extendFiled;   //业务扩展字段

    //订单录入信息
    private String entryUser;  //录入人

    private Date entryTime;    // 录入时间

    private String remark;

    private Integer isEntry;            //是否是手动录入订单, 1 手动录入

    /**
     * 订单应付金额
     */
    private Long shouldPayAmount;

    /**
     * 配送地址
     */
    private String deliveryAddress;

    private String receiveName;

    private String receiveTel;

    private List<LogisticsResp> logisticsList;   //物流信息

    private Boolean canBeDecode = Boolean.FALSE;

    private boolean useInnerPay;

    private Long createBy;

    /**
     * 订单是否能删除必须满足
     * 1. 是手动录入的订单
     * 2. 没有内部支付信息
     * 3. 数据权限满足部门管辖权限
     */
    private boolean enableDel;

    /**
     * 订单是否能删除必须满足
     * 1. 是手动录入的订单
     * 2. 没有内部支付信息
     * 3. 操作人是当前订单的创建人
     */
    private boolean enableEdit;

    /**
     * 推广人
     */
    private Long promoterId;

    ///////////////scrm设置字段/////////////////
    /**
     * 推广人姓名
     */
    private String promoterName;
    /**
     * 微信头像
     */
    private String wechatAvatar;
    /**
     * 微信昵称
     */
    private String wechatAlias;

    /**
     * 是否是网校的订单 0:否 1:是
     * 对于网校的订单不能进行编辑和退款操作
     */
    private Integer isNetSchoolOrder;

    /**
     * 客户来源
     */
    private String studentTypeName;
    /**
     * 客户渠道
     */
    private String channelName;

    /**
     * 支付主体名称
     */
    private String payGroupName;

    /**
     * 网校校区id
     */
    private Long netSchoolId;
    private String netSchoolName;

    /**
     * 合同签署状态 0:未签署 1:已签署
     */
    private Integer contractSignStatus;
    private String downloadUrl;
    private String viewUrl;
    private String contractId;

    /**
     * 实际服务周期
     **/
    private Integer realServicePeriod;

    /**
     * 实际服务周期时间
     **/
    private Date realServicePeriodTime;

    /**
     * 免费服务周期
     **/
    private Integer freeServicePeriod;

    /**
     * 免费服务周期时间
     **/
    private Date freeServicePeriodTime;

    private String qqWechat; // 客户qq或微信
    private Long consultantId; //首咨人
    private String consultantName; // 首咨人姓名
    private Date validateDateBegin; // 课程有效期开始时间
    private Date validateDateEnd; // 课程有效期结束时间
}
