package cn.kinyun.customer.center.dto.req.order;

import cn.kinyun.customer.center.dto.req.BaseReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author Created by chenjiaqiang on 2021/12/13
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class OrderRecordReq extends BaseReq implements Serializable {

    private String num;
    // 支付渠道
    private Integer channelType;

    // 支付编号
    private String payNo;

    // 订单编号
    private String orderNo;

    // 支付金额
    private Long payAmount;

    private Integer payStatus;

    private Date payTime;

    private String fkType;

    private String fkId;
    /**
     * 支付凭证
     */
    private String paymentVoucherUrl;

    private List<String> paymentVoucherUrlList;

    /**
     * 邮费
     */
    private Long postAmount;

    /**
     * 平台支付流水号
     */
    private String transaction;

    /**
     * 平台类型
     */
    private Integer platformType;

    /**
     * 是否手动录入 0否 1是
     */
    private Integer entry = 0;

    private Integer isDeleted = 0;

    private Integer newLeads;// 1 是， 0 否

    private String requestId;

    private String weworkProductId;
}
