package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author louis
 * @date 2023/2/28
 */
@Data
public class CcCustomerAreaReq implements Serializable {
    private static final long serialVersionUID = 4911427187265227113L;
    private Long bizId;
    private Date startTime;
    private Date endTime;
    private List<String> customerNums;

    public void validateParam() {
        Preconditions.checkArgument(this.bizId != null, "商户id 不能为空");
        Preconditions.checkArgument(Objects.nonNull(this.startTime), "开始时间 不能为空");
        Preconditions.checkArgument(Objects.nonNull(this.endTime), "结束时间 不能为空");
    }

}
