package cn.kinyun.customer.center.dto.resp;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author lanye
 */
@Data
@ToString(callSuper = true)
public class RefundOrderListResp implements Serializable {

    private String phone;
    private String crmCustomerName;
    private String customerNum;
    private String leadsNum;
    private String productLineNum;

    private String num;
    // 订单编号
    private String orderNo;

    private Date orderTime;

    private List<String> skuNames;

    private Long orderPrice;

    private Long paidAmount;

    private String source;

    private String sourceDesc;

    //客户信息
    private String customerName;    //客户名

    private String customerMobile;  //客户手机号

    private String id;

    // 退款单号 关联外部退款单编号
    private String refundNo;

    // 退款金额
    private Long refundAmount;

    // 退款状态
    private Integer refundStatus;

    private Integer refundType;

    //审批状态
    private Integer auditStatus;

    private String refundStatusDesc;

    private String refundTypeDesc;

    private String auditStatusDesc;

    //审批备注
    private String auditRemark;

    private String refundFailReason;

    private Date refundTime;

    private String remark;

    private String createUser;

    private Date createTime;

    // 详情字段
    private String userName;  //成单人名

    private List<String> attachments;

    private Long orderAmount;

    private Long otherAmount;

    private List<String> transferAttachments;

    private String accountName;

    private String account;

    private String bank;

    private String transferNo;

    private String refundSerialNo;

    private List<String> refundSerialNos;

    private String reason;

    /**
     * 退款方式
     */
    private String refundWay;

    /**
     * 审批申请人
     */
    private String approvalApply;

    /**
     * 审批时间
     */
    private Date applyTime;

    /**
     * 订单审批人
     */
    private String approvalUser;

    private Long createBy;
}