package cn.kinyun.customer.center.dto.req.order;

import cn.kinyun.customer.center.dto.req.BaseReq;
import cn.kinyun.customer.center.dto.req.ExtendFieldDto;
import cn.kinyun.customer.center.enums.OrderSource;
import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author Created by chenjiaqiang on 2021/12/13
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class OrderReq extends BaseReq {



    private Long customerOrderId;
    /**
     * 表的唯一索引
     */
    private String customerOrderNum;
    // 订单编号
    private String orderNo;

    // 产品编号
    private String skuNo;

    // 产品名称
    private String skuName;

    // 产品数量
    private Integer skuCount;

    // 产品封面地址
    private String skuImgUrl;

    /**
     * 产品金额,新增已启用，请使用  {@link OrderSkuListReq#getSkuAmount()}
      */
    private Long skuAmount;

    // 商户对应的企业ID
    private String corpId;

    /**
     * 订单商品信息
     */
    private List<OrderSkuListReq> orderSkuListReqs;

    // 订单金额
    private Long orderAmount;

    // 已支付金额
    private Long paidAmount;

    /**
     * 应付金额
     */
    private Long shouldPayAmount;

    // 支付状态
    private Integer payStatus;

    // 退款单号
    private String refundNo;

    // 退款金额 单位为毫
    private Long refundAmount;

    // 退款时间
    private Date refundTime;

    // 退款状态
    private Integer refundStatus;

    // 录单人
    private Long createBy;

    // 订单创建时间
    private Date createTime;

    // 订单备注
    private String remark;

    // 关联数据类型
    private String fkType;

    private String fkId;

    private Integer isDeleted;


    private String customerMobile;

    private String customerName;


    /**
     * 支付凭证
     */
    private String paymentVoucherUrl;

    /**
     * 业绩归属部门Id
     */
    private Long achieveDepartId;

    /**
     * 优惠金额
     */
    private Long discountAmount;


    /**
     * 支付流水号
     */
    private String payNo;

    /**
     * 支付方式
     */
    private Integer paidChannelType;

    /**
     * 录入方式 见 OrderEntryMethodEnum
     */
    private Integer entryMethod;

    /**
     * 更新之前的成单人id
     */
    private Long beforeOrderUser;

    /**
     * 更新之后的成单人id
     */
    private Long afterOrderUser;

    /**
     * 动态字段， 字段属性名，字段属性值
     */
    private List<ExtendFieldDto> dynamicColValue;

    /**
     * 订单状态
     */
    private Integer status;


    /**
     * 主订单类型
     */
    private Integer type;

    /**
     * 支付类型
     */
    private Integer payType;


    /**
     * 支付时间
     */
    private Date payTime;


    /**
     * 配送地址
     */
    private String deliveryAddress;

    /**
     * 售后人手机号
     */
    private String receiveTel;

    /**
     * 收货人名称
     */
    private String receiveName;


    /**
     * 平台类型
     */
    private Integer platformType;

    /**
     * 防止消息错乱消费
     */
    private Date updateTime;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 店铺唯一识别id
     */
    private String shopId;


    private Integer newLeads;
    /**
     * 订单来源
     */
    private String orderSource;

    /**
     * 下单开始时间
     */
    private Date orderTimeStart;

    /**
     * 下单结束时间
     */
    private Date orderTimeEnd;

    private List<String> customerNums;

    /**
     * 推广人ID
     */
    private Long promoterId;

    /**
     * 数据渠道num
     */
    private String channelNum;

    //网校同步过来的订单属于哪个分校的
    private Long schoolId;

    /**
     * 订单从哪个系统过来的 scrm/scrm-open-api
     */
    private String originSys;

    public void validate() {

        Preconditions.checkArgument(bizId != null, "bizId is null");
        Preconditions.checkArgument(StringUtils.isNotBlank(source), "source is null");

        Preconditions.checkArgument(StringUtils.isNotBlank(orderNo), "orderNo is null");
    }

    public void validateCustomerNumAndMobile() {
        Preconditions.checkArgument(StringUtils.isNotBlank(customerMobile) || StringUtils.isNotBlank(customerNum), "customerNum, customerMobile can not be null or empty at same time");
    }
}
