package cn.kinyun.customer.center.dto.req.alloc;

import cn.kinyun.customer.center.dto.req.IdAndNameDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CrmLeadsAllocRuleDto implements Serializable {

    private Long id;

    private String num;

    private Long bizId;

    private String corpId;

    /**
     * 省
     */
    private String provinceId;

    private Long productLineId;

    private IdAndNameDto productLine;

    /**
     * 市
     */
    private String cityId;

    /**
     * 区域
     */
    private String areaCode;

    private List<IdAndNameDto> areas;

    /**
     * 表达式逻辑关系:and = 0;or=1
     */
    private Integer logic;

    /**
     * 分配模式：0=轮流分配，1=随机分配
     */
    private Integer allocMode = 0;

    /**
     * 分配模式：0=用户，1=部门
     */
    private Integer memberType = 0;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 更新人id
     */
    private Long updateBy;

    private Date createTime;

    private Date updateTime;

    /**
     * 是否启用0=false,1=true
     */
    private Integer enable;

    /**
     * 是否删除0=false,1=true
     */
    private Integer isDeleted;

    /**
     * 执行顺序
     */
    private Integer seq;

    /**
     * 字段条件json
     */
    private String expression;

    /**
     * 人员/部门配置信息
     */
    private String allocMemberInfo;

    /**
     * 人员/部门权重
     */
    private String allocMemberRatio;

}