/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.enums.electricity;

import cn.kinyun.customer.center.enums.electricity.OrderStatusEnum;
import com.google.common.collect.Lists;
import com.kuaike.common.enums.EnumService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public enum DouOrderStatusEnum implements EnumService
{
    TO_CONFIRM(1, "\u5f85\u786e\u8ba4/\u5f85\u652f\u4ed8-\u8ba2\u5355\u521b\u5efa\u5b8c\u6bd5", OrderStatusEnum.WAIT_PAY.getValue()),
    PAID(105, "\u5df2\u652f\u4ed8;", OrderStatusEnum.HAD_PAY.getValue()),
    STOCKING(2, "\u5907\u8d27\u4e2d", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    PART_DELIVERY(101, "\u90e8\u5206\u53d1\u8d27", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    DELIVERY(3, "\u5df2\u53d1\u8d27\uff08\u5168\u90e8\u53d1\u8d27\uff09", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    CANCELED(4, "\u5df2\u53d6\u6d88", OrderStatusEnum.CLOSED.getValue()),
    TRADE_SUCCESS(5, "\u5df2\u5b8c\u6210\uff08\u5df2\u6536\u8d27\uff09", OrderStatusEnum.SUCCESSED.getValue());

    private final int id;
    private final String name;
    private final int orderStatus;
    private static final Map<Integer, DouOrderStatusEnum> CACHE;
    private static final Map<Integer, List<Integer>> statusCache;

    private DouOrderStatusEnum(int id, String name, int orderStatus) {
        this.id = id;
        this.name = name;
        this.orderStatus = orderStatus;
    }

    public int getValue() {
        return this.id;
    }

    public String getDesc() {
        return this.name;
    }

    public Integer getOrderStatus() {
        return this.orderStatus;
    }

    public static DouOrderStatusEnum getByEnumName(String enumName) {
        DouOrderStatusEnum[] values;
        for (DouOrderStatusEnum value : values = DouOrderStatusEnum.values()) {
            if (!StringUtils.equals((CharSequence)value.name(), (CharSequence)enumName)) continue;
            return value;
        }
        return null;
    }

    public static List<Integer> getDouOrderStatus(Integer id) {
        return statusCache.get(id);
    }

    public static DouOrderStatusEnum get(int id) {
        return CACHE.get(id);
    }

    public static List<Integer> getPaidStatus() {
        ArrayList statusList = Lists.newArrayList();
        List<Integer> hadPayList = DouOrderStatusEnum.getDouOrderStatus(OrderStatusEnum.HAD_PAY.getValue());
        List<Integer> waitList = DouOrderStatusEnum.getDouOrderStatus(OrderStatusEnum.WAIT_DELIVERY.getValue());
        List<Integer> successList = DouOrderStatusEnum.getDouOrderStatus(OrderStatusEnum.SUCCESSED.getValue());
        if (CollectionUtils.isNotEmpty(hadPayList)) {
            statusList.addAll(hadPayList);
        }
        if (CollectionUtils.isNotEmpty(waitList)) {
            statusList.addAll(waitList);
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            statusList.addAll(successList);
        }
        return statusList;
    }

    static {
        CACHE = new HashMap<Integer, DouOrderStatusEnum>(3);
        for (DouOrderStatusEnum item : DouOrderStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
        statusCache = new HashMap<Integer, List<Integer>>();
        for (DouOrderStatusEnum item : DouOrderStatusEnum.values()) {
            List<Integer> statusList = statusCache.getOrDefault(item.getOrderStatus(), Lists.newArrayList());
            statusList.add(item.getValue());
            statusCache.put(item.getOrderStatus(), statusList);
        }
    }
}

