/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.enums;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum RefundTypeEnum {
    UNKNOWN(0, "\u672a\u77e5"),
    WAY_BACK(1, "\u539f\u8def\u9000\u56de"),
    TRANSFER(2, "\u94f6\u884c\u5361\u8f6c\u8d26");

    private int value;
    private String desc;
    private static final Map<Integer, RefundTypeEnum> cache;

    private RefundTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static RefundTypeEnum get(int value) {
        return cache.get(value);
    }

    public static RefundTypeEnum getByDesc(String desc) {
        if (StringUtils.isBlank((CharSequence)desc)) {
            return null;
        }
        for (RefundTypeEnum value : RefundTypeEnum.values()) {
            String de = value.getDesc();
            if (!StringUtils.equals((CharSequence)de, (CharSequence)desc)) continue;
            return value;
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        cache = new HashMap<Integer, RefundTypeEnum>();
        for (RefundTypeEnum item : RefundTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }
}

