package cn.kinyun.customer.center.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lanye
 **/
@SuppressWarnings("java:S2386")
@Getter
public enum OrderEventEnum {
    CUSTOMER(1, "客户信息", "ccCustomerDetailServiceImpl", "syncElectricPlatformCustomer"),
    LEADS(2, "线索信息", "ccCustomerDetailServiceImpl", "addOrderLeads"),
    GOODS(3, "商品信息", "ccCustomerOrderServiceImpl", "addOrderPayRecord"),
    ORDER(4, "订单信息", "ccCustomerOrderServiceImpl", "addOrder"),
    PAY(5, "支付信息", "ccCustomerOrderServiceImpl", "addOrderPayRecord"),
    LOGISTIC(6, "物流信息", "ccLogisticServiceImpl", "addLogistic"),
    REFUND(7, "退款", "ccCustomerOrderServiceImpl", "refundOrder");

    private int value;
    private String desc;
    /**
     * 此处可利用bean和method反射实现低代码调用,但对性能有影响,暂不使用
     */
    private String bean;
    private String method;

    OrderEventEnum(int value, String desc, String bean, String method) {
        this.value = value;
        this.desc = desc;
        this.bean = bean;
        this.method = method;
    }

    public static final Map<Integer, OrderEventEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (OrderEventEnum item : OrderEventEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static OrderEventEnum get(int value) {
        return CACHE.get(value);
    }
}
