package cn.kinyun.customer.center.dto.req.order;

import cn.kinyun.customer.center.dto.req.BaseReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lanye
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class OrderSkuListReq extends BaseReq {

    // 产品编号
    private String skuNo;

    // 产品名称
    private String skuName;

    // 产品封面地址
    private String skuImgUrl;

    // 产品金额
    private Long skuAmount;

    // 备注
    private String remark;

    /**
     * 商品数量
     */
    private Long goodsNum;


    /**
     * 有赞通过这个字段关联退款信息
     */
    private String oid;

    /**
     * 产品原价，和skuAmount 不一样，skuAmount 可能是折扣后价格
     */
    private Long totalPrice;

    /**
     * 商品别名
     */
    private String alias;

    /**
     * 商品地址
     */
    private String goodsUrl;


    /**
     * sku 规格信息
     */
    private String skuProperties;


    private Integer platformType;

    private String productId;

    private String outProductId;
}
