package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @Date: 2021/12/20 17:14
 * @Author: dayu
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CustomerDetailReq extends BaseReq {

    private String avatar;

    private String name;

    private String area;

    private String corpName;

    private String corpFullName;

    private Integer type;

    private Integer gender;

    private String remark;

    private String channelId;

    /**
     * 手机号信息
     */
    private String mobile;

    /**
     * 注册用户的地址
     */
    private String address;

    private String encodeName;

    private String encodeAddress;

    private String encodeMobile;

    /**
     * 企微unionId,
     */
    private String unionId;

    private Integer platformCode;


    /**
     * 是否覆盖
     */
    private Integer coverValue;

    private Long tradeAmount;

    private PageDto pageDto;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(customerNum), "customerNum不能为空");
    }

    public boolean validateByQuery() {
        if (Objects.isNull(bizId)) {
            return false;
        }
        if (StringUtils.isNotBlank(name)) {
            return true;
        }
        return false;
    }


}
