/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.enums;

import cn.kinyun.customer.center.enums.electricity.PlatformEnum;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum OrderSource {
    OPEN_API("API", "API\u5bf9\u63a5", false, false),
    TRADE_ORDER("trade", "\u5546\u54c1\u8ba2\u5355\u7cfb\u7edf", false, false),
    SHOP_ORDER("shop", "\u5c0f\u5546\u5e97\u8ba2\u5355", false, false),
    AD_ORDER("ad", "\u5e7f\u544a\u8ba2\u5355", false, false),
    MEETING_ORDER("meeting", "\u76f4\u64ad\u5e26\u8d27\u8ba2\u5355", false, false),
    ELECTRIC_ORDER("electric", "\u7535\u5546\u8ba2\u5355", true, false),
    YZ_WX_ORDER("electric_yz_wx", "\u6709\u8d5e(\u5fae\u4fe1)", true, true),
    YZ_3RD_ORDER("electric_yz_3rd", "\u6709\u8d5e(\u5546\u5bb6\u81ea\u7531)", true, true),
    YZ_BUYER_ORDER("electric_yz_buyer", "\u6709\u8d5e(\u4e70\u5bb6\u7248)", true, true),
    YZ_BROWSER_ORDER("electric_yz_browser", "\u6709\u8d5e(\u7cfb\u7edf\u6d4f\u89c8\u5668)", true, true),
    YZ_ALI_ORDER("electric_yz_ali", "\u6709\u8d5e(\u652f\u4ed8\u5b9d)", true, true),
    YZ_QQ_ORDER("electric_yz_qq", "\u6709\u8d5e(\u817e\u8bafqq)", true, true),
    YZ_WB_ORDER("electric_yz_wb", "\u6709\u8d5e(\u5fae\u535a)", true, true),
    YZ_OTH_ORDER("electric_yz_other", "\u6709\u8d5e(\u5176\u4ed6)", true, true),
    DOU_ORDER("electric_dou", "\u6296\u5e97", true, true),
    TAOBAO_ORDER("electric_taobao", "\u6dd8\u5b9d\u7535\u5546", true, false),
    PC("0", "\u7ebf\u4e0bPC", false, false),
    MOBILE("1", "\u7ebf\u4e0b\u624b\u673a", false, false),
    APP("2", "APP", false, false),
    WAP("3", "WAP", false, false),
    GUAN_WANG("4", "\u5b98\u7f51", false, false),
    TIAN_MAO("5", "\u5929\u732b", false, false),
    WEI_DIAN("6", "\u5fae\u5e97", false, false),
    JIA_MENG("7", "\u52a0\u76df", false, false),
    WEI_KAI_JIANG("8", "\u5fae\u5f00\u8bb2", false, false),
    JD("9", "\u4eac\u4e1c\u65d7\u8230\u5e97", false, false),
    CCTALK("10", "cctalk", false, false),
    XIAO_E_TONG("11", "\u5fae\u4fe1\u516c\u4f17\u53f7\u5c0f\u9e45\u901a", false, false),
    YOU_ZAN("12", "\u6709\u8d5e", false, false),
    WANG_XIAO("13", "\u5317\u65b9\u533a\u7f51\u6821", false, false),
    DOU_DIAN("14", "\u6296\u5e97", false, false);

    private static final Map<String, OrderSource> CACHE;
    private String value;
    private String desc;
    private Boolean electric;
    private Boolean canBeDecode;

    public static OrderSource getType(String value) {
        return CACHE.get(value);
    }

    private OrderSource(String value, String desc, boolean electric, Boolean canBeDecode) {
        this.value = value;
        this.desc = desc;
        this.electric = electric;
        this.canBeDecode = canBeDecode;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isElectric() {
        return this.electric;
    }

    public Boolean getCanBeDecode() {
        return this.canBeDecode;
    }

    public static List<String> getByPlatform(PlatformEnum platformEnum) {
        if (Objects.isNull((Object)platformEnum)) {
            return Lists.newArrayList();
        }
        List<Object> orderSourceList = Lists.newArrayList();
        if (platformEnum.equals((Object)PlatformEnum.YOU_ZAN)) {
            orderSourceList = Arrays.stream(OrderSource.values()).filter(item -> item.getValue().startsWith("electric_yz")).map(OrderSource::getValue).collect(Collectors.toList());
        }
        if (platformEnum.equals((Object)PlatformEnum.DOU_DIAN)) {
            orderSourceList = Arrays.stream(OrderSource.values()).filter(item -> item.getValue().startsWith("electric_dou")).map(OrderSource::getValue).collect(Collectors.toList());
        }
        return orderSourceList;
    }

    public static boolean isHoudaOrder(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return false;
        }
        return PC.getValue().equals(source) || MOBILE.getValue().equals(source) || APP.getValue().equals(source) || WAP.getValue().equals(source) || GUAN_WANG.getValue().equals(source) || TIAN_MAO.getValue().equals(source) || WEI_DIAN.getValue().equals(source) || JIA_MENG.getValue().equals(source) || WEI_KAI_JIANG.getValue().equals(source) || JD.getValue().equals(source) || CCTALK.getValue().equals(source) || XIAO_E_TONG.getValue().equals(source) || YOU_ZAN.getValue().equals(source) || WANG_XIAO.getValue().equals(source) || DOU_DIAN.getValue().equals(source);
    }

    static {
        CACHE = new HashMap<String, OrderSource>();
        for (OrderSource e : OrderSource.values()) {
            CACHE.put(e.value, e);
        }
    }
}

