package cn.kinyun.customer.center.dto.req.event;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lanye
 */
@Data
public class EventModule implements Serializable {
    //标识来源的模块
    private String type;

    private String num;       //关联的主体唯一编码，比如活动， 雷达的唯一编码

    private String name;      //关联主体名， 活动名， 雷达title等

    /**
     * 活动类型
     */
    private String planType;

    private Long channelId;

    /**
     * 站点编号
     */
    private Long siteNumber;
    /**
     * 支付金额
     * 广告落地页支付
     */
    private Long payAmount;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 广告 客户添加的企微成员名称
     */
    private String weworkUserName;

    private String productId;

    private String productName;

    //直播id
    private Long meetingId;

    //直播类型
    private Integer meetingType;
}
